/*
 * Decompiled with CFR 0.152.
 */
package KdfCtr_Compile;

import BoundedInts_Compile.uint8;
import HMAC.HMac;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyEuclidean;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.KdfCtrInput;

public class __default {
    public static Result<DafnySequence<? extends Byte>, Error> KdfCounterMode(KdfCtrInput input) {
        Result<DafnySequence<? extends Byte>, Error> output = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !(!Objects.equals(input.dtor_digestAlgorithm(), DigestAlgorithm.create_SHA__256()) && !Objects.equals(input.dtor_digestAlgorithm(), DigestAlgorithm.create_SHA__384()) || !Objects.equals(BigInteger.valueOf(input.dtor_ikm().length()), BigInteger.valueOf(32L)) && !Objects.equals(BigInteger.valueOf(input.dtor_ikm().length()), BigInteger.valueOf(48L)) && !Objects.equals(BigInteger.valueOf(input.dtor_ikm().length()), BigInteger.valueOf(66L)) || !input.dtor_nonce().is_Some() || !Objects.equals(BigInteger.valueOf(input.dtor_nonce().dtor_value().length()), BigInteger.valueOf(16L)) && !Objects.equals(BigInteger.valueOf(input.dtor_nonce().dtor_value().length()), BigInteger.valueOf(32L)) || input.dtor_expectedLength() != 32 && input.dtor_expectedLength() != 64 || BigInteger.valueOf(input.dtor_expectedLength()).multiply(BigInteger.valueOf(8L)).signum() != 1 || BigInteger.valueOf(input.dtor_expectedLength()).multiply(BigInteger.valueOf(8L)).compareTo(StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT()) >= 0), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Kdf in Counter Mode input is invalid.")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        DafnySequence<? extends Byte> _1_ikm = input.dtor_ikm();
        DafnySequence<? extends Byte> _2_label__ = input.dtor_purpose().UnwrapOr((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
        DafnySequence<? extends Byte> _3_info = input.dtor_nonce().UnwrapOr((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
        DafnySequence _4_okm = DafnySequence.empty(uint8._typeDescriptor());
        int _5_internalLength = BigInteger.valueOf(4L).add(BigInteger.valueOf(__default.SEPARATION__INDICATOR().length())).add(BigInteger.valueOf(4L)).intValue();
        Outcome<Error> _6_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _6_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Helpers.unsignedToBigInteger((int)_5_internalLength).add(BigInteger.valueOf(_2_label__.length())).add(BigInteger.valueOf(_3_info.length())).compareTo(StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT()) < 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Input Length exceeds INT32_MAX_LIMIT")));
        if (_6_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _6_valueOrError1.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        DafnySequence<? extends Byte> _7_lengthBits = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(input.dtor_expectedLength() * 8);
        DafnySequence _8_explicitInfo = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_2_label__, __default.SEPARATION__INDICATOR()), _3_info), _7_lengthBits);
        Outcome<Error> _9_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _9_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(4L).add(BigInteger.valueOf(_8_explicitInfo.length())).compareTo(StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT()) < 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"PRF input length exceeds INT32_MAX_LIMIT.")));
        if (_9_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _9_valueOrError2.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        Result<DafnySequence, Error> _10_valueOrError3 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out0 = __default.RawDerive(_1_ikm, (DafnySequence<? extends Byte>)_8_explicitInfo, input.dtor_expectedLength(), 0, input.dtor_digestAlgorithm());
        _10_valueOrError3 = _out0;
        if (_10_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            output = _10_valueOrError3.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        _4_okm = _10_valueOrError3.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        output = Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), _4_okm);
        return output;
    }

    public static Result<DafnySequence<? extends Byte>, Error> RawDerive(DafnySequence<? extends Byte> ikm, DafnySequence<? extends Byte> explicitInfo, int length, int offset, DigestAlgorithm digestAlgorithm) {
        Result<DafnySequence<? extends Byte>, Error> output = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<HMac, Error> _0_valueOrError0 = null;
        Result<HMac, Error> _out0 = HMac.Build(digestAlgorithm);
        _0_valueOrError0 = _out0;
        if (_0_valueOrError0.IsFailure((TypeDescriptor<HMac>)TypeDescriptor.reference(HMac.class), Error._typeDescriptor())) {
            output = _0_valueOrError0.PropagateFailure((TypeDescriptor<HMac>)TypeDescriptor.reference(HMac.class), Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        HMac _1_hmac = _0_valueOrError0.Extract((TypeDescriptor<HMac>)TypeDescriptor.reference(HMac.class), Error._typeDescriptor());
        _1_hmac.Init(ikm);
        int _2_macLengthBytes = Digest_Compile.__default.Length(digestAlgorithm).intValue();
        int _3_iterations = DafnyEuclidean.EuclideanDivision((int)(length + _2_macLengthBytes - 1), (int)_2_macLengthBytes);
        DafnySequence _4_buffer = DafnySequence.empty(uint8._typeDescriptor());
        DafnySequence _5_i = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(__default.COUNTER__START__VALUE());
        int _hi0 = _3_iterations + 1;
        for (int _6_iteration = 1; _6_iteration < _hi0; ++_6_iteration) {
            DafnySequence<? extends Byte> _out1;
            _1_hmac.BlockUpdate(_5_i);
            _1_hmac.BlockUpdate(explicitInfo);
            DafnySequence<? extends Byte> _7_tmp = _out1 = _1_hmac.GetResult();
            _4_buffer = DafnySequence.concatenate((DafnySequence)_4_buffer, _7_tmp);
            Result<DafnySequence, Error> _8_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
            _8_valueOrError1 = __default.Increment(_5_i);
            if (_8_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
                output = _8_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
                return output;
            }
            _5_i = _8_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        }
        Outcome<Error> _9_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _9_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_4_buffer.length()).compareTo(BigInteger.valueOf(length)) >= 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Failed to derive key of requested length")));
        if (_9_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _9_valueOrError2.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        output = Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), _4_buffer.take(length));
        return output;
    }

    public static Result<DafnySequence<? extends Byte>, Error> Increment(DafnySequence<? extends Byte> x) {
        if (Integer.compareUnsigned(((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{(Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), (Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ONE)), (Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L))), (byte)((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L))) + 1)}));
        }
        if (Integer.compareUnsigned(((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{(Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), (Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ONE)), (byte)((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L))) + 1), 0}));
        }
        if (Integer.compareUnsigned(((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ONE))).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{(Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), (byte)((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ONE)) + 1), 0, 0}));
        }
        if (Integer.compareUnsigned(((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{(byte)((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO)) + 1), 0, 0, 0}));
        }
        return Result.create_Failure(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to derive key material; may have exceeded limit.")));
    }

    public static DafnySequence<? extends Byte> SEPARATION__INDICATOR() {
        return DafnySequence.of((byte[])new byte[]{0});
    }

    public static int COUNTER__START__VALUE() {
        return 1;
    }

    public String toString() {
        return "KdfCtr._default";
    }
}

