/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.termstat;

import com.o19s.es.explore.StatisticsHelper;
import com.o19s.es.termstat.TermStatQuery;
import com.o19s.es.termstat.TermStatSupplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class TermStatScorer
extends Scorer {
    private final DocIdSetIterator iter;
    private final Expression compiledExpression;
    private StatisticsHelper.AggrType aggr;
    private StatisticsHelper.AggrType posAggr;
    private final LeafReaderContext context;
    private final IndexSearcher searcher;
    private final Set<Term> terms;
    private final ScoreMode scoreMode;
    private final Map<Term, TermStates> termContexts;

    public TermStatScorer(TermStatQuery.TermStatWeight weight, IndexSearcher searcher, LeafReaderContext context, Expression compiledExpression, Set<Term> terms, ScoreMode scoreMode, StatisticsHelper.AggrType aggr, StatisticsHelper.AggrType posAggr, Map<Term, TermStates> termContexts) {
        super((Weight)weight);
        this.context = context;
        this.compiledExpression = compiledExpression;
        this.searcher = searcher;
        this.terms = terms;
        this.scoreMode = scoreMode;
        this.aggr = aggr;
        this.posAggr = posAggr;
        this.termContexts = termContexts;
        this.iter = DocIdSetIterator.all((int)context.reader().maxDoc());
    }

    public DocIdSetIterator iterator() {
        return this.iter;
    }

    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }

    public float score() throws IOException {
        TermStatSupplier tsq = new TermStatSupplier();
        tsq.setPosAggr(this.posAggr);
        tsq.bump(this.searcher, this.context, this.docID(), this.terms, this.scoreMode, this.termContexts);
        StatisticsHelper computed = new StatisticsHelper();
        final HashMap<String, Float> termStatDict = new HashMap<String, Float>();
        Bindings bindings = new Bindings(){

            public DoubleValuesSource getDoubleValuesSource(String name) {
                return DoubleValuesSource.constant((double)((Float)termStatDict.get(name)).floatValue());
            }
        };
        if (tsq.size() == 0) {
            return 0.0f;
        }
        for (int i = 0; i < tsq.size(); ++i) {
            termStatDict.put("df", (Float)((ArrayList)tsq.get("df")).get(i));
            termStatDict.put("idf", (Float)((ArrayList)tsq.get("idf")).get(i));
            termStatDict.put("tf", (Float)((ArrayList)tsq.get("tf")).get(i));
            termStatDict.put("tp", (Float)((ArrayList)tsq.get("tp")).get(i));
            termStatDict.put("ttf", (Float)((ArrayList)tsq.get("ttf")).get(i));
            termStatDict.put("matches", Float.valueOf(tsq.getMatchedTermCount()));
            termStatDict.put("unique", Float.valueOf(this.terms.size()));
            DoubleValuesSource dvSrc = this.compiledExpression.getDoubleValuesSource(bindings);
            DoubleValues values = dvSrc.getValues(this.context, null);
            values.advanceExact(this.docID());
            computed.add((float)values.doubleValue());
        }
        return computed.getAggr(this.aggr);
    }

    public int docID() {
        return this.iter.docID();
    }
}

