"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createAlertingCluster;
var _alertingPlugin = _interopRequireDefault(require("./alertingPlugin"));
var _constants = require("../../services/utils/constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createAlertingCluster(core, globalConfig, dataSourceEnabled, dataSource) {
  const {
    customHeaders,
    ...rest
  } = globalConfig.opensearch;
  if (dataSourceEnabled) {
    dataSource.registerCustomApiSchema(_alertingPlugin.default);
  }
  return core.opensearch.legacy.createClient(_constants.CLUSTER.ALERTING, {
    plugins: [_alertingPlugin.default],
    // Currently we are overriding any headers with our own since we explicitly required User-Agent to be OpenSearch Dashboards
    // for integration with our backend plugin.
    // TODO: Change our required header to x-<Header> to avoid overriding
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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