"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsAnalyticsAdaptor = void 0;
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class MetricsAnalyticsAdaptor {
  constructor() {
    _defineProperty(this, "fetch", async function (client, query, index, dataSourceMDSId) {
      try {
        let response;
        if (dataSourceMDSId) {
          response = await client.callAPI('search', {
            body: query,
            index
          });
        } else {
          response = await client.callAsCurrentUser('search', {
            body: query,
            index
          });
        }
        return response;
      } catch (error) {
        throw new Error('Fetch Otel Metrics Error:' + error);
      }
    });
    _defineProperty(this, "queryToFetchBinCount", async (client, min, max, startTime, endTime, documentName, index, dataSourceMDSId) => {
      const metricsQuery = {
        size: 0,
        query: {
          bool: {
            must: [{
              term: {
                name: {
                  value: documentName
                }
              }
            }, {
              range: {
                time: {
                  gte: startTime,
                  lte: endTime
                }
              }
            }]
          }
        },
        aggs: {
          nested_buckets: {
            nested: {
              path: 'buckets'
            },
            aggs: {
              bucket_range: {
                filter: {
                  range: {
                    'buckets.max': {
                      gt: min,
                      lte: max
                    }
                  }
                },
                aggs: {
                  bucket_count: {
                    sum: {
                      field: 'buckets.count'
                    }
                  }
                }
              }
            }
          }
        }
      };
      try {
        const response = await this.fetch(client, metricsQuery, index, dataSourceMDSId);
        return response.aggregations;
      } catch (error) {
        throw new Error('Fetch Bin count Error:' + error);
      }
    });
    _defineProperty(this, "queryToFetchSampleDocument", async (client, documentName, index, dataSourceMDSId) => {
      const metricsQuery = {
        size: 1,
        query: {
          bool: {
            must: [{
              term: {
                name: {
                  value: documentName
                }
              }
            }]
          }
        }
      };
      try {
        const response = await this.fetch(client, metricsQuery, index, dataSourceMDSId);
        return response;
      } catch (error) {
        throw new Error('Fetch Sample Document Error:' + error);
      }
    });
    _defineProperty(this, "queryToFetchDocumentNames", async (client, index, dataSourceMDSId) => {
      const metricsQuery = {
        size: 0,
        query: {
          bool: {
            filter: [{
              term: {
                kind: 'HISTOGRAM'
              }
            }]
          }
        },
        aggs: {
          distinct_names: {
            terms: {
              field: 'name',
              size: 500
            }
          }
        }
      };
      try {
        const response = await this.fetch(client, metricsQuery, index, dataSourceMDSId);
        return response;
      } catch (error) {
        throw new Error('Fetch Document Names Error:' + error);
      }
    });
  }
}
exports.MetricsAnalyticsAdaptor = MetricsAnalyticsAdaptor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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