"use strict";

require("jest-canvas-mock");
require("@testing-library/jest-dom/extend-expect");
var _react = require("@testing-library/react");
var _enzyme = _interopRequireDefault(require("enzyme"));
var _enzymeAdapterReact = _interopRequireDefault(require("enzyme-adapter-react-16"));
var _useContext = require("./mocks/useContext.mock");
var _DataStore = require("../public/store/DataStore");
var _services = _interopRequireDefault(require("./mocks/services"));
var _NotificationsStart = _interopRequireDefault(require("./mocks/services/notifications/NotificationsStart.mock"));
var _stringPrototype = _interopRequireDefault(require("string.prototype.replaceall"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// @ts-ignore

_stringPrototype.default.shim();
_enzyme.default.configure({
  adapter: new _enzymeAdapterReact.default()
});
(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
jest.mock('@elastic/eui/lib/eui_components/form/form_row/make_id', () => () => 'some_make_id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'some_html_id';
  }
}));

// @ts-ignore
window.Worker = function () {
  this.postMessage = () => {};
  // @ts-ignore
  this.terminate = () => {};
};

// @ts-ignore
window.URL = {
  createObjectURL: () => {
    return '';
  }
};

// https://github.com/elastic/eui/issues/2530
jest.mock('@elastic/eui/lib/eui_components/icon', () => ({
  EuiIcon: () => 'EuiIconMock',
  __esModule: true,
  IconPropType: require('@elastic/eui/lib/eui_components/icon/icon').IconPropType,
  ICON_TYPES: require('@elastic/eui/lib/eui_components/icon/icon').TYPES,
  ICON_SIZES: require('@elastic/eui/lib/eui_components/icon/icon').SIZES,
  ICON_COLORS: require('@elastic/eui/lib/eui_components/icon/icon').COLORS
}));

/**
 * Moment timezones are not working from jest so here we mock
 * moment.tz.names function
 *
 * Also, format function is mocked to return always the same value so that we can correctly test
 * functions that call this
 */
jest.mock('moment', () => {
  const moment = jest.requireActual('moment');

  // Set moment tz mock
  if (!moment.tz) moment.tz = {};
  moment.tz.names = () => ['Pacific/Tahiti'];
  const momentInstance = moment();
  momentInstance.format = jest.fn().mockReturnValue('2023-01-25T10:05');
  function fakeMoment() {
    return momentInstance;
  }
  Object.assign(fakeMoment, moment);
  return fakeMoment;
});

/**
 * React useContext is mocked to return the mocked services
 * so that this works in all tests
 */
jest.mock('react', () => {
  const ActualReact = jest.requireActual('react');
  return {
    ...ActualReact,
    useContext: () => _useContext.mockContexts
  };
});

/**
 * Mocks the vega view renderer
 */
jest.mock('vega/build-es5/vega.js', () => {
  const vega = jest.requireActual('vega/build-es5/vega.js');
  return {
    ...vega,
    View: jest.fn().mockReturnValue({
      tooltip: jest.fn(),
      runAsync: jest.fn().mockReturnValue(new Promise(jest.fn()))
    })
  };
});
_DataStore.DataStore.init(_services.default, _NotificationsStart.default);
jest.setTimeout(10000); // in milliseconds
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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