/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) / 3ul) => u64vec3(444444444444444419ul, 28ul, 31ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) / 1192ul) => u64vec3(1118568232662192ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) / 1048576ul) => u64vec3(1271565755208ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) / 4251475ul) => u64vec3(313616646771ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) / 29852643761ul) => u64vec3(44663827ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) / 4398046511104ul) => u64vec3(303164ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) / 3948976685146ul) => u64vec3(337640ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) / 135763469567146206ul) => u64vec3(9ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) / 11654173250180970009ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) / 3ul) => u64vec3(55ul, 22ul, 62ul)
 * (u64vec3(167ul, 66ul, 187ul) / 1192ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) / 1048576ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) / 4251475ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) / 29852643761ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) / 4398046511104ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) / 3948976685146ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) / 135763469567146206ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) / 11654173250180970009ul) => u64vec3(0ul, 0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) / 3ul), u64vec3(444444444444444419ul, 28ul, 31ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) / 1192ul), u64vec3(1118568232662192ul, 0ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) / 1048576ul), u64vec3(1271565755208ul, 0ul, 0ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) / 4251475ul), u64vec3(313616646771ul, 0ul, 0ul))) ? 1 : -1] array3;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) / 29852643761ul), u64vec3(44663827ul, 0ul, 0ul))) ? 1 : -1] array4;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) / 4398046511104ul), u64vec3(303164ul, 0ul, 0ul))) ? 1 : -1] array5;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) / 3948976685146ul), u64vec3(337640ul, 0ul, 0ul))) ? 1 : -1] array6;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) / 135763469567146206ul), u64vec3(9ul, 0ul, 0ul))) ? 1 : -1] array7;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) / 11654173250180970009ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array8;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) / 3ul), u64vec3(55ul, 22ul, 62ul))) ? 1 : -1] array9;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) / 1192ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array10;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) / 1048576ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array11;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) / 4251475ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array12;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) / 29852643761ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array13;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) / 4398046511104ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array14;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) / 3948976685146ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array15;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) / 135763469567146206ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array16;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) / 11654173250180970009ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
