/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(38, 35) * 12) => ivec2(456, 420)
 * (ivec2(38, 35) * -6) => ivec2(-228, -210)
 * (ivec2(38, 35) * 76) => ivec2(2888, 2660)
 * (ivec2(38, 35) * -32) => ivec2(-1216, -1120)
 * (ivec2(38, 35) * 0) => ivec2(0, 0)
 * (ivec2(64, -9) * 12) => ivec2(768, -108)
 * (ivec2(64, -9) * -6) => ivec2(-384, 54)
 * (ivec2(64, -9) * 76) => ivec2(4864, -684)
 * (ivec2(64, -9) * -32) => ivec2(-2048, 288)
 * (ivec2(64, -9) * 0) => ivec2(0, 0)
 * (ivec2(64, 9) * 12) => ivec2(768, 108)
 * (ivec2(64, 9) * -6) => ivec2(-384, -54)
 * (ivec2(64, 9) * 76) => ivec2(4864, 684)
 * (ivec2(64, 9) * -32) => ivec2(-2048, -288)
 * (ivec2(64, 9) * 0) => ivec2(0, 0)
 */
#version 150

void main()
{
  float[all(equal((ivec2(38, 35) * 12), ivec2(456, 420))) ? 1 : -1] array0;
  float[all(equal((ivec2(38, 35) * -6), ivec2(-228, -210))) ? 1 : -1] array1;
  float[all(equal((ivec2(38, 35) * 76), ivec2(2888, 2660))) ? 1 : -1] array2;
  float[all(equal((ivec2(38, 35) * -32), ivec2(-1216, -1120))) ? 1 : -1] array3;
  float[all(equal((ivec2(38, 35) * 0), ivec2(0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec2(64, -9) * 12), ivec2(768, -108))) ? 1 : -1] array5;
  float[all(equal((ivec2(64, -9) * -6), ivec2(-384, 54))) ? 1 : -1] array6;
  float[all(equal((ivec2(64, -9) * 76), ivec2(4864, -684))) ? 1 : -1] array7;
  float[all(equal((ivec2(64, -9) * -32), ivec2(-2048, 288))) ? 1 : -1] array8;
  float[all(equal((ivec2(64, -9) * 0), ivec2(0, 0))) ? 1 : -1] array9;
  float[all(equal((ivec2(64, 9) * 12), ivec2(768, 108))) ? 1 : -1] array10;
  float[all(equal((ivec2(64, 9) * -6), ivec2(-384, -54))) ? 1 : -1] array11;
  float[all(equal((ivec2(64, 9) * 76), ivec2(4864, 684))) ? 1 : -1] array12;
  float[all(equal((ivec2(64, 9) * -32), ivec2(-2048, -288))) ? 1 : -1] array13;
  float[all(equal((ivec2(64, 9) * 0), ivec2(0, 0))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
