/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PLine;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PSmoothTriangle;
import processing.core.PTriangle;
import processing.core.PVector;

public class PGraphics3D
extends PGraphics {
    public float[] zbuffer;
    public PMatrix3D modelview;
    public PMatrix3D modelviewInv;
    protected boolean sizeChanged;
    public PMatrix3D camera;
    protected PMatrix3D cameraInv;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    public PMatrix3D projection;
    public static final int MAX_LIGHTS = 8;
    public int lightCount = 0;
    public int[] lightType;
    public PVector[] lightPosition;
    public PVector[] lightNormal;
    public float[] lightFalloffConstant;
    public float[] lightFalloffLinear;
    public float[] lightFalloffQuadratic;
    public float[] lightSpotAngle;
    public float[] lightSpotAngleCos;
    public float[] lightSpotConcentration;
    public float[][] lightDiffuse;
    public float[][] lightSpecular;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    public static final int TRI_DIFFUSE_R = 0;
    public static final int TRI_DIFFUSE_G = 1;
    public static final int TRI_DIFFUSE_B = 2;
    public static final int TRI_DIFFUSE_A = 3;
    public static final int TRI_SPECULAR_R = 4;
    public static final int TRI_SPECULAR_G = 5;
    public static final int TRI_SPECULAR_B = 6;
    public static final int TRI_COLOR_COUNT = 7;
    private boolean lightingDependsOnVertexPosition;
    static final int LIGHT_AMBIENT_R = 0;
    static final int LIGHT_AMBIENT_G = 1;
    static final int LIGHT_AMBIENT_B = 2;
    static final int LIGHT_DIFFUSE_R = 3;
    static final int LIGHT_DIFFUSE_G = 4;
    static final int LIGHT_DIFFUSE_B = 5;
    static final int LIGHT_SPECULAR_R = 6;
    static final int LIGHT_SPECULAR_G = 7;
    static final int LIGHT_SPECULAR_B = 8;
    static final int LIGHT_COLOR_COUNT = 9;
    protected float[] tempLightingContribution = new float[9];
    protected PVector lightTriangleNorm = new PVector();
    protected boolean manipulatingCamera;
    float[][] matrixStack = new float[32][16];
    float[][] matrixInvStack = new float[32][16];
    int matrixStackDepth;
    protected int matrixMode = 1;
    float[][] pmatrixStack = new float[32][16];
    int pmatrixStackDepth;
    protected PMatrix3D forwardTransform;
    protected PMatrix3D reverseTransform;
    protected float leftScreen;
    protected float rightScreen;
    protected float topScreen;
    protected float bottomScreen;
    protected float nearPlane;
    private boolean frustumMode = false;
    protected static boolean s_enableAccurateTextures = false;
    public PSmoothTriangle smoothTriangle;
    protected int shapeFirst;
    protected int shapeLast;
    protected int shapeLastPlusClipped;
    protected int[] vertexOrder = new int[512];
    protected int pathCount;
    protected int[] pathOffset = new int[64];
    protected int[] pathLength = new int[64];
    protected static final int VERTEX1 = 0;
    protected static final int VERTEX2 = 1;
    protected static final int VERTEX3 = 2;
    protected static final int STROKE_COLOR = 1;
    protected static final int TEXTURE_INDEX = 3;
    protected static final int POINT_FIELD_COUNT = 2;
    protected static final int LINE_FIELD_COUNT = 2;
    protected static final int TRIANGLE_FIELD_COUNT = 4;
    static final int DEFAULT_POINTS = 512;
    protected int[][] points = new int[512][2];
    protected int pointCount;
    static final int DEFAULT_LINES = 512;
    public PLine line;
    protected int[][] lines = new int[512][2];
    protected int lineCount;
    static final int DEFAULT_TRIANGLES = 256;
    public PTriangle triangle;
    protected int[][] triangles = new int[256][4];
    protected float[][][] triangleColors = new float[256][3][7];
    protected int triangleCount;
    static final int DEFAULT_TEXTURES = 3;
    protected PImage[] textures = new PImage[3];
    int textureIndex;
    DirectColorModel cm;
    MemoryImageSource mis;
    float[] worldNormal = new float[4];
    PVector lightPositionVec = new PVector();
    PVector lightDirectionVec = new PVector();

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
        this.lightType = new int[8];
        this.lightPosition = new PVector[8];
        this.lightNormal = new PVector[8];
        for (int i = 0; i < 8; ++i) {
            this.lightPosition[i] = new PVector();
            this.lightNormal[i] = new PVector();
        }
        this.lightDiffuse = new float[8][3];
        this.lightSpecular = new float[8][3];
        this.lightFalloffConstant = new float[8];
        this.lightFalloffLinear = new float[8];
        this.lightFalloffQuadratic = new float[8];
        this.lightSpotAngle = new float[8];
        this.lightSpotAngleCos = new float[8];
        this.lightSpotConcentration = new float[8];
        this.currentLightSpecular = new float[3];
        this.projection = new PMatrix3D();
        this.modelview = new PMatrix3D();
        this.modelviewInv = new PMatrix3D();
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / (float)Math.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
        this.camera = new PMatrix3D();
        this.cameraInv = new PMatrix3D();
        this.sizeChanged = true;
    }

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        this.zbuffer = new float[this.pixelCount];
        if (this.primarySurface) {
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.mis.setFullBufferUpdates(true);
            this.mis.setAnimated(true);
            this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        } else {
            Arrays.fill(this.zbuffer, Float.MAX_VALUE);
        }
        this.line = new PLine(this);
        this.triangle = new PTriangle(this);
        this.smoothTriangle = new PSmoothTriangle(this);
    }

    public void beginDraw() {
        if (!this.settingsInited) {
            this.defaultSettings();
        }
        if (this.sizeChanged) {
            this.camera();
            this.perspective();
            this.sizeChanged = false;
        }
        this.resetMatrix();
        this.vertexCount = 0;
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
        this.lightCount = 0;
        this.lightingDependsOnVertexPosition = false;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.shapeFirst = 0;
        Arrays.fill(this.textures, null);
        this.textureIndex = 0;
        this.normal(0.0f, 0.0f, 1.0f);
    }

    public void endDraw() {
        if (this.hints[5]) {
            this.flush();
        }
        if (this.mis != null) {
            this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        }
        this.updatePixels();
    }

    protected void defaultSettings() {
        super.defaultSettings();
        this.manipulatingCamera = false;
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.camera();
        this.perspective();
        this.textureMode(2);
        this.emissive(0.0f);
        this.specular(0.5f);
        this.shininess(1.0f);
    }

    public void hint(int n) {
        if (n == -5) {
            this.flush();
        } else if (n == 4 && this.zbuffer != null) {
            Arrays.fill(this.zbuffer, Float.MAX_VALUE);
        }
        super.hint(n);
    }

    public void beginShape(int n) {
        this.shape = n;
        if (this.hints[5]) {
            this.shapeFirst = this.vertexCount;
            this.shapeLast = 0;
        } else {
            this.vertexCount = 0;
            if (this.line != null) {
                this.line.reset();
            }
            this.lineCount = 0;
            if (this.triangle != null) {
                this.triangle.reset();
            }
            this.triangleCount = 0;
        }
        this.textureImage = null;
        this.curveVertexCount = 0;
        this.normalMode = 0;
    }

    public void texture(PImage pImage) {
        this.textureImage = pImage;
        if (this.textureIndex == this.textures.length - 1) {
            this.textures = (PImage[])PApplet.expand(this.textures);
        }
        if (this.textures[this.textureIndex] != null) {
            ++this.textureIndex;
        }
        this.textures[this.textureIndex] = pImage;
    }

    public void vertex(float f, float f2) {
        this.vertex(f, f2, 0.0f);
    }

    public void vertex(float f, float f2, float f3, float f4) {
        this.vertex(f, f2, 0.0f, f3, f4);
    }

    public void endShape(int n) {
        this.shapeLastPlusClipped = this.shapeLast = this.vertexCount;
        if (this.vertexCount == 0) {
            this.shape = 0;
            return;
        }
        this.endShapeModelToCamera(this.shapeFirst, this.shapeLast);
        if (this.stroke) {
            this.endShapeStroke(n);
        }
        if (this.fill || this.textureImage != null) {
            this.endShapeFill();
        }
        this.endShapeLighting(this.lightCount > 0 && this.fill);
        this.endShapeCameraToScreen(this.shapeFirst, this.shapeLastPlusClipped);
        if (!this.hints[5]) {
            if ((this.fill || this.textureImage != null) && this.triangleCount > 0) {
                this.renderTriangles(0, this.triangleCount);
                if (this.raw != null) {
                    this.rawTriangles(0, this.triangleCount);
                }
                this.triangleCount = 0;
            }
            if (this.stroke) {
                if (this.pointCount > 0) {
                    this.renderPoints(0, this.pointCount);
                    if (this.raw != null) {
                        this.rawPoints(0, this.pointCount);
                    }
                    this.pointCount = 0;
                }
                if (this.lineCount > 0) {
                    this.renderLines(0, this.lineCount);
                    if (this.raw != null) {
                        this.rawLines(0, this.lineCount);
                    }
                    this.lineCount = 0;
                }
            }
            this.pathCount = 0;
        }
        this.shape = 0;
    }

    protected void endShapeModelToCamera(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            float[] fArray = this.vertices[i];
            fArray[21] = this.modelview.m00 * fArray[0] + this.modelview.m01 * fArray[1] + this.modelview.m02 * fArray[2] + this.modelview.m03;
            fArray[22] = this.modelview.m10 * fArray[0] + this.modelview.m11 * fArray[1] + this.modelview.m12 * fArray[2] + this.modelview.m13;
            fArray[23] = this.modelview.m20 * fArray[0] + this.modelview.m21 * fArray[1] + this.modelview.m22 * fArray[2] + this.modelview.m23;
            fArray[24] = this.modelview.m30 * fArray[0] + this.modelview.m31 * fArray[1] + this.modelview.m32 * fArray[2] + this.modelview.m33;
            if (fArray[24] != 0.0f && fArray[24] != 1.0f) {
                fArray[21] = fArray[21] / fArray[24];
                fArray[22] = fArray[22] / fArray[24];
                fArray[23] = fArray[23] / fArray[24];
            }
            fArray[24] = 1.0f;
        }
    }

    protected void endShapeStroke(int n) {
        switch (this.shape) {
            case 2: {
                int n2 = this.shapeLast;
                for (int i = this.shapeFirst; i < n2; ++i) {
                    this.addPoint(i);
                }
                break;
            }
            case 4: {
                int n3 = this.lineCount;
                int n4 = this.shapeLast - 1;
                if (this.shape != 4) {
                    this.addLineBreak();
                }
                for (int i = this.shapeFirst; i < n4; i += 2) {
                    if (this.shape == 4) {
                        this.addLineBreak();
                    }
                    this.addLine(i, i + 1);
                }
                if (n != 2) break;
                this.addLine(n4, this.lines[n3][0]);
                break;
            }
            case 9: {
                for (int i = this.shapeFirst; i < this.shapeLast - 2; i += 3) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 1);
                    this.addLine(i + 1, i + 2);
                    this.addLine(i + 2, i + 0);
                }
                break;
            }
            case 10: {
                int n5;
                int n6 = this.shapeLast - 1;
                this.addLineBreak();
                for (n5 = this.shapeFirst; n5 < n6; ++n5) {
                    this.addLine(n5, n5 + 1);
                }
                n6 = this.shapeLast - 2;
                for (n5 = this.shapeFirst; n5 < n6; ++n5) {
                    this.addLineBreak();
                    this.addLine(n5, n5 + 2);
                }
                break;
            }
            case 11: {
                int n7;
                for (n7 = this.shapeFirst + 1; n7 < this.shapeLast; ++n7) {
                    this.addLineBreak();
                    this.addLine(this.shapeFirst, n7);
                }
                this.addLineBreak();
                for (n7 = this.shapeFirst + 1; n7 < this.shapeLast - 1; ++n7) {
                    this.addLine(n7, n7 + 1);
                }
                this.addLine(this.shapeLast - 1, this.shapeFirst + 1);
                break;
            }
            case 16: {
                for (int i = this.shapeFirst; i < this.shapeLast; i += 4) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 1);
                    this.addLine(i + 1, i + 2);
                    this.addLine(i + 2, i + 3);
                    this.addLine(i + 3, i + 0);
                }
                break;
            }
            case 17: {
                for (int i = this.shapeFirst; i < this.shapeLast - 3; i += 2) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 2);
                    this.addLine(i + 2, i + 3);
                    this.addLine(i + 3, i + 1);
                    this.addLine(i + 1, i + 0);
                }
                break;
            }
            case 20: {
                int n8 = this.shapeLast - 1;
                this.addLineBreak();
                for (int i = this.shapeFirst; i < n8; ++i) {
                    this.addLine(i, i + 1);
                }
                if (n != 2) break;
                this.addLine(n8, this.shapeFirst);
            }
        }
    }

    protected void endShapeFill() {
        switch (this.shape) {
            case 11: {
                int n = this.shapeLast - 1;
                for (int i = this.shapeFirst + 1; i < n; ++i) {
                    this.addTriangle(this.shapeFirst, i, i + 1);
                }
                break;
            }
            case 9: {
                int n = this.shapeLast - 2;
                for (int i = this.shapeFirst; i < n; i += 3) {
                    if (i % 2 == 0) {
                        this.addTriangle(i, i + 2, i + 1);
                        continue;
                    }
                    this.addTriangle(i, i + 1, i + 2);
                }
                break;
            }
            case 10: {
                int n = this.shapeLast - 2;
                for (int i = this.shapeFirst; i < n; ++i) {
                    if (i % 2 == 0) {
                        this.addTriangle(i, i + 2, i + 1);
                        continue;
                    }
                    this.addTriangle(i, i + 1, i + 2);
                }
                break;
            }
            case 16: {
                int n = this.vertexCount - 3;
                for (int i = this.shapeFirst; i < n; i += 4) {
                    this.addTriangle(i, i + 1, i + 2);
                    this.addTriangle(i, i + 2, i + 3);
                }
                break;
            }
            case 17: {
                int n = this.vertexCount - 3;
                for (int i = this.shapeFirst; i < n; i += 2) {
                    this.addTriangle(i + 0, i + 2, i + 1);
                    this.addTriangle(i + 2, i + 3, i + 1);
                }
                break;
            }
            case 20: {
                this.addPolygonTriangles();
            }
        }
    }

    protected void endShapeLighting(boolean bl) {
        if (bl) {
            if (!this.lightingDependsOnVertexPosition && this.normalMode == 1) {
                this.calcLightingContribution(this.shapeFirst, this.tempLightingContribution);
                for (int i = 0; i < this.triangleCount; ++i) {
                    this.lightTriangle(i, this.tempLightingContribution);
                }
            } else {
                for (int i = 0; i < this.triangleCount; ++i) {
                    this.lightTriangle(i);
                }
            }
        } else {
            for (int i = 0; i < this.triangleCount; ++i) {
                int n = this.triangles[i][0];
                this.copyPrelitVertexColor(i, n, 0);
                n = this.triangles[i][1];
                this.copyPrelitVertexColor(i, n, 1);
                n = this.triangles[i][2];
                this.copyPrelitVertexColor(i, n, 2);
            }
        }
    }

    protected void endShapeCameraToScreen(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            float[] fArray = this.vertices[i];
            float f = this.projection.m00 * fArray[21] + this.projection.m01 * fArray[22] + this.projection.m02 * fArray[23] + this.projection.m03 * fArray[24];
            float f2 = this.projection.m10 * fArray[21] + this.projection.m11 * fArray[22] + this.projection.m12 * fArray[23] + this.projection.m13 * fArray[24];
            float f3 = this.projection.m20 * fArray[21] + this.projection.m21 * fArray[22] + this.projection.m22 * fArray[23] + this.projection.m23 * fArray[24];
            float f4 = this.projection.m30 * fArray[21] + this.projection.m31 * fArray[22] + this.projection.m32 * fArray[23] + this.projection.m33 * fArray[24];
            if (f4 != 0.0f && f4 != 1.0f) {
                f /= f4;
                f2 /= f4;
                f3 /= f4;
            }
            fArray[18] = (float)this.width * (1.0f + f) / 2.0f;
            fArray[19] = (float)this.height * (1.0f + f2) / 2.0f;
            fArray[20] = (f3 + 1.0f) / 2.0f;
        }
    }

    protected void addPoint(int n) {
        if (this.pointCount == this.points.length) {
            int[][] nArray = new int[this.pointCount << 1][2];
            System.arraycopy(this.points, 0, nArray, 0, this.pointCount);
            this.points = nArray;
        }
        this.points[this.pointCount][0] = n;
        this.points[this.pointCount][1] = this.strokeColor;
        ++this.pointCount;
    }

    protected void renderPoints(int n, int n2) {
        if (this.strokeWeight != 1.0f) {
            for (int i = n; i < n2; ++i) {
                float[] fArray = this.vertices[this.points[i][0]];
                this.renderLineVertices(fArray, fArray);
            }
        } else {
            for (int i = n; i < n2; ++i) {
                float[] fArray = this.vertices[this.points[i][0]];
                int n3 = (int)(fArray[18] + 0.4999f);
                int n4 = (int)(fArray[19] + 0.4999f);
                if (n3 < 0 || n3 >= this.width || n4 < 0 || n4 >= this.height) continue;
                int n5 = n4 * this.width + n3;
                this.pixels[n5] = this.points[i][1];
                this.zbuffer[n5] = fArray[20];
            }
        }
    }

    protected void rawPoints(int n, int n2) {
        this.raw.colorMode(1, 1.0f);
        this.raw.noFill();
        this.raw.strokeWeight(this.vertices[this.lines[n][0]][17]);
        this.raw.beginShape(2);
        for (int i = n; i < n2; ++i) {
            float[] fArray = this.vertices[this.lines[i][0]];
            if (this.raw.is3D()) {
                if (fArray[24] == 0.0f) continue;
                this.raw.stroke(fArray[13], fArray[14], fArray[15], fArray[16]);
                this.raw.vertex(fArray[21] / fArray[24], fArray[22] / fArray[24], fArray[23] / fArray[24]);
                continue;
            }
            this.raw.stroke(fArray[13], fArray[14], fArray[15], fArray[16]);
            this.raw.vertex(fArray[18], fArray[19]);
        }
        this.raw.endShape();
    }

    protected final void addLineBreak() {
        if (this.pathCount == this.pathOffset.length) {
            this.pathOffset = PApplet.expand(this.pathOffset);
            this.pathLength = PApplet.expand(this.pathLength);
        }
        this.pathOffset[this.pathCount] = this.lineCount;
        this.pathLength[this.pathCount] = 0;
        ++this.pathCount;
    }

    protected void addLine(int n, int n2) {
        this.addLineWithClip(n, n2);
    }

    protected final void addLineWithClip(int n, int n2) {
        float f = this.vertices[n][23];
        float f2 = this.vertices[n2][23];
        if (f > this.cameraNear) {
            if (f2 > this.cameraNear) {
                return;
            }
            int n3 = this.interpolateClipVertex(n, n2);
            this.addLineWithoutClip(n3, n2);
            return;
        }
        if (f2 <= this.cameraNear) {
            this.addLineWithoutClip(n, n2);
            return;
        }
        int n4 = this.interpolateClipVertex(n, n2);
        this.addLineWithoutClip(n, n4);
    }

    protected final void addLineWithoutClip(int n, int n2) {
        if (this.lineCount == this.lines.length) {
            int[][] nArray = new int[this.lineCount << 1][2];
            System.arraycopy(this.lines, 0, nArray, 0, this.lineCount);
            this.lines = nArray;
        }
        this.lines[this.lineCount][0] = n;
        this.lines[this.lineCount][1] = n2;
        ++this.lineCount;
        int n3 = this.pathCount - 1;
        this.pathLength[n3] = this.pathLength[n3] + 1;
    }

    protected void renderLines(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.renderLineVertices(this.vertices[this.lines[i][0]], this.vertices[this.lines[i][1]]);
        }
    }

    protected void renderLineVertices(float[] fArray, float[] fArray2) {
        if (fArray[17] > 1.25f || fArray[17] < 0.75f) {
            float f = fArray[18];
            float f2 = fArray[19];
            float f3 = fArray2[18];
            float f4 = fArray2[19];
            float f5 = fArray[17] / 2.0f;
            if (f == f3 && f2 == f4) {
                f2 -= f5;
                f4 += f5;
            }
            float f6 = f3 - f + 1.0E-4f;
            float f7 = f4 - f2 + 1.0E-4f;
            float f8 = (float)Math.sqrt(f6 * f6 + f7 * f7);
            float f9 = f5 / f8;
            float f10 = f9 * f7;
            float f11 = f9 * f6;
            float f12 = f9 * f7;
            float f13 = f9 * f6;
            float f14 = f + f10;
            float f15 = f2 - f11;
            float f16 = f - f10;
            float f17 = f2 + f11;
            float f18 = f3 + f12;
            float f19 = f4 - f13;
            float f20 = f3 - f12;
            float f21 = f4 + f13;
            if (this.smooth) {
                this.smoothTriangle.reset(3);
                this.smoothTriangle.smooth = true;
                this.smoothTriangle.interpARGB = true;
                this.smoothTriangle.setVertices(f14, f15, fArray[20], f20, f21, fArray2[20], f16, f17, fArray[20]);
                this.smoothTriangle.setIntensities(fArray[13], fArray[14], fArray[15], fArray[16], fArray2[13], fArray2[14], fArray2[15], fArray2[16], fArray[13], fArray[14], fArray[15], fArray[16]);
                this.smoothTriangle.render();
                this.smoothTriangle.setVertices(f14, f15, fArray[20], f20, f21, fArray2[20], f18, f19, fArray2[20]);
                this.smoothTriangle.setIntensities(fArray[13], fArray[14], fArray[15], fArray[16], fArray2[13], fArray2[14], fArray2[15], fArray2[16], fArray2[13], fArray2[14], fArray2[15], fArray2[16]);
                this.smoothTriangle.render();
            } else {
                this.triangle.reset();
                this.triangle.setVertices(f14, f15, fArray[20], f20, f21, fArray2[20], f16, f17, fArray[20]);
                this.triangle.setIntensities(fArray[13], fArray[14], fArray[15], fArray[16], fArray2[13], fArray2[14], fArray2[15], fArray2[16], fArray[13], fArray[14], fArray[15], fArray[16]);
                this.triangle.render();
                this.triangle.setVertices(f14, f15, fArray[20], f20, f21, fArray2[20], f18, f19, fArray2[20]);
                this.triangle.setIntensities(fArray[13], fArray[14], fArray[15], fArray[16], fArray2[13], fArray2[14], fArray2[15], fArray2[16], fArray2[13], fArray2[14], fArray2[15], fArray2[16]);
                this.triangle.render();
            }
        } else {
            this.line.reset();
            this.line.setIntensities(fArray[13], fArray[14], fArray[15], fArray[16], fArray2[13], fArray2[14], fArray2[15], fArray2[16]);
            this.line.setVertices(fArray[18], fArray[19], fArray[20], fArray2[18], fArray2[19], fArray2[20]);
            this.line.draw();
        }
    }

    protected void rawLines(int n, int n2) {
        this.raw.colorMode(1, 1.0f);
        this.raw.noFill();
        this.raw.beginShape(4);
        for (int i = n; i < n2; ++i) {
            float[] fArray = this.vertices[this.lines[i][0]];
            float[] fArray2 = this.vertices[this.lines[i][1]];
            this.raw.strokeWeight(this.vertices[this.lines[i][1]][17]);
            if (this.raw.is3D()) {
                if (fArray[24] == 0.0f || fArray2[24] == 0.0f) continue;
                this.raw.stroke(fArray[13], fArray[14], fArray[15], fArray[16]);
                this.raw.vertex(fArray[21] / fArray[24], fArray[22] / fArray[24], fArray[23] / fArray[24]);
                this.raw.stroke(fArray2[13], fArray2[14], fArray2[15], fArray2[16]);
                this.raw.vertex(fArray2[21] / fArray2[24], fArray2[22] / fArray2[24], fArray2[23] / fArray2[24]);
                continue;
            }
            if (!this.raw.is2D()) continue;
            this.raw.stroke(fArray[13], fArray[14], fArray[15], fArray[16]);
            this.raw.vertex(fArray[18], fArray[19]);
            this.raw.stroke(fArray2[13], fArray2[14], fArray2[15], fArray2[16]);
            this.raw.vertex(fArray2[18], fArray2[19]);
        }
        this.raw.endShape();
    }

    protected void addTriangle(int n, int n2, int n3) {
        this.addTriangleWithClip(n, n2, n3);
    }

    protected final void addTriangleWithClip(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        this.cameraNear = -8.0f;
        if (this.vertices[n][23] > this.cameraNear) {
            bl = true;
            ++n4;
        }
        if (this.vertices[n2][23] > this.cameraNear) {
            bl2 = true;
            ++n4;
        }
        if (this.vertices[n3][23] > this.cameraNear) {
            ++n4;
        }
        if (n4 == 0) {
            this.addTriangleWithoutClip(n, n2, n3);
        } else if (n4 != 3) {
            if (n4 == 2) {
                int n5;
                int n6;
                int n7;
                if (!bl) {
                    n7 = n;
                    n6 = n2;
                    n5 = n3;
                } else if (!bl2) {
                    n7 = n2;
                    n6 = n;
                    n5 = n3;
                } else {
                    n7 = n3;
                    n6 = n2;
                    n5 = n;
                }
                int n8 = this.interpolateClipVertex(n7, n6);
                int n9 = this.interpolateClipVertex(n7, n5);
                this.addTriangleWithoutClip(n7, n8, n9);
            } else {
                int n10;
                int n11;
                int n12;
                if (bl) {
                    n12 = n3;
                    n11 = n2;
                    n10 = n;
                } else if (bl2) {
                    n12 = n;
                    n11 = n3;
                    n10 = n2;
                } else {
                    n12 = n;
                    n11 = n2;
                    n10 = n3;
                }
                int n13 = this.interpolateClipVertex(n12, n10);
                int n14 = this.interpolateClipVertex(n11, n10);
                this.addTriangleWithoutClip(n12, n13, n11);
                this.addTriangleWithoutClip(n11, n13, n14);
            }
        }
    }

    protected final int interpolateClipVertex(int n, int n2) {
        float[] fArray;
        float[] fArray2;
        if (this.vertices[n][23] < this.vertices[n2][23]) {
            fArray2 = this.vertices[n2];
            fArray = this.vertices[n];
        } else {
            fArray2 = this.vertices[n];
            fArray = this.vertices[n2];
        }
        float f = fArray2[23];
        float f2 = fArray[23];
        float f3 = f - f2;
        if (f3 == 0.0f) {
            return n;
        }
        float f4 = (this.cameraNear - f2) / f3;
        float f5 = 1.0f - f4;
        this.vertex(f4 * fArray2[0] + f5 * fArray[0], f4 * fArray2[1] + f5 * fArray[1], f4 * fArray2[2] + f5 * fArray[2]);
        int n3 = this.vertexCount - 1;
        ++this.shapeLastPlusClipped;
        float[] fArray3 = this.vertices[n3];
        fArray3[18] = f4 * fArray2[18] + f5 * fArray[18];
        fArray3[19] = f4 * fArray2[19] + f5 * fArray[19];
        fArray3[20] = f4 * fArray2[20] + f5 * fArray[20];
        fArray3[21] = f4 * fArray2[21] + f5 * fArray[21];
        fArray3[22] = f4 * fArray2[22] + f5 * fArray[22];
        fArray3[23] = f4 * fArray2[23] + f5 * fArray[23];
        fArray3[24] = f4 * fArray2[24] + f5 * fArray[24];
        fArray3[3] = f4 * fArray2[3] + f5 * fArray[3];
        fArray3[4] = f4 * fArray2[4] + f5 * fArray[4];
        fArray3[5] = f4 * fArray2[5] + f5 * fArray[5];
        fArray3[6] = f4 * fArray2[6] + f5 * fArray[6];
        fArray3[7] = f4 * fArray2[7] + f5 * fArray[7];
        fArray3[8] = f4 * fArray2[8] + f5 * fArray[8];
        fArray3[13] = f4 * fArray2[13] + f5 * fArray[13];
        fArray3[14] = f4 * fArray2[14] + f5 * fArray[14];
        fArray3[15] = f4 * fArray2[15] + f5 * fArray[15];
        fArray3[16] = f4 * fArray2[16] + f5 * fArray[16];
        fArray3[9] = f4 * fArray2[9] + f5 * fArray[9];
        fArray3[10] = f4 * fArray2[10] + f5 * fArray[10];
        fArray3[11] = f4 * fArray2[11] + f5 * fArray[11];
        fArray3[25] = f4 * fArray2[25] + f5 * fArray[25];
        fArray3[26] = f4 * fArray2[26] + f5 * fArray[26];
        fArray3[27] = f4 * fArray2[27] + f5 * fArray[27];
        fArray3[28] = f4 * fArray2[28] + f5 * fArray[28];
        fArray3[29] = f4 * fArray2[29] + f5 * fArray[29];
        fArray3[30] = f4 * fArray2[30] + f5 * fArray[30];
        fArray3[32] = f4 * fArray2[32] + f5 * fArray[32];
        fArray3[33] = f4 * fArray2[33] + f5 * fArray[33];
        fArray3[34] = f4 * fArray2[34] + f5 * fArray[34];
        fArray3[31] = f4 * fArray2[31] + f5 * fArray[31];
        fArray3[35] = 0.0f;
        return n3;
    }

    protected final void addTriangleWithoutClip(int n, int n2, int n3) {
        if (this.triangleCount == this.triangles.length) {
            int[][] nArray = new int[this.triangleCount << 1][4];
            System.arraycopy(this.triangles, 0, nArray, 0, this.triangleCount);
            this.triangles = nArray;
            float[][][] fArray = new float[this.triangleCount << 1][3][7];
            System.arraycopy(this.triangleColors, 0, fArray, 0, this.triangleCount);
            this.triangleColors = fArray;
        }
        this.triangles[this.triangleCount][0] = n;
        this.triangles[this.triangleCount][1] = n2;
        this.triangles[this.triangleCount][2] = n3;
        this.triangles[this.triangleCount][3] = this.textureImage == null ? -1 : this.textureIndex;
        ++this.triangleCount;
    }

    protected void addPolygonTriangles() {
        float[] fArray;
        float[] fArray2;
        int n;
        int n2;
        if (this.vertexOrder.length != this.vertices.length) {
            int[] nArray = new int[this.vertices.length];
            PApplet.arrayCopy(this.vertexOrder, nArray, this.vertexOrder.length);
            this.vertexOrder = nArray;
        }
        int n3 = 0;
        int n4 = 1;
        float f = 0.0f;
        int n5 = this.shapeLast - 1;
        int n6 = this.shapeFirst;
        while (n6 < this.shapeLast) {
            f += this.vertices[n6][n3] * this.vertices[n5][n4] - this.vertices[n5][n3] * this.vertices[n6][n4];
            n5 = n6++;
        }
        if (f == 0.0f) {
            n5 = 0;
            n6 = 0;
            for (n2 = this.shapeFirst; n2 < this.shapeLast; ++n2) {
                for (n = n2; n < this.shapeLast; ++n) {
                    if (this.vertices[n2][0] != this.vertices[n][0]) {
                        n5 = 1;
                    }
                    if (this.vertices[n2][1] == this.vertices[n][1]) continue;
                    n6 = 1;
                }
            }
            if (n5 != 0) {
                n4 = 2;
            } else if (n6 != 0) {
                n3 = 1;
                n4 = 2;
            } else {
                return;
            }
            n2 = this.shapeLast - 1;
            n = this.shapeFirst;
            while (n < this.shapeLast) {
                f += this.vertices[n][n3] * this.vertices[n2][n4] - this.vertices[n2][n3] * this.vertices[n][n4];
                n2 = n++;
            }
        }
        if (this.abs((fArray2 = this.vertices[this.shapeFirst])[0] - (fArray = this.vertices[this.shapeLast - 1])[0]) < 1.0E-4f && this.abs(fArray2[1] - fArray[1]) < 1.0E-4f && this.abs(fArray2[2] - fArray[2]) < 1.0E-4f) {
            --this.shapeLast;
        }
        n2 = 0;
        if (f > 0.0f) {
            n = this.shapeFirst;
            while (n < this.shapeLast) {
                n2 = n - this.shapeFirst;
                this.vertexOrder[n2] = n++;
            }
        } else {
            for (n = this.shapeFirst; n < this.shapeLast; ++n) {
                n2 = n - this.shapeFirst;
                this.vertexOrder[n2] = this.shapeLast - 1 - n2;
            }
        }
        n = this.shapeLast - this.shapeFirst;
        int n7 = 2 * n;
        int n8 = 0;
        int n9 = n - 1;
        while (n > 2) {
            int n10;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            int n11;
            boolean bl = true;
            if (0 >= n7--) break;
            int n12 = n9;
            if (n <= n12) {
                n12 = 0;
            }
            if (n <= (n9 = n12 + 1)) {
                n9 = 0;
            }
            if (n <= (n11 = n9 + 1)) {
                n11 = 0;
            }
            if ((double)1.0E-4f > ((d6 = (double)(-10.0f * this.vertices[this.vertexOrder[n9]][n3])) - (d5 = (double)(-10.0f * this.vertices[this.vertexOrder[n12]][n3]))) * ((d4 = (double)(10.0f * this.vertices[this.vertexOrder[n11]][n4])) - (d3 = (double)(10.0f * this.vertices[this.vertexOrder[n12]][n4]))) - ((d2 = (double)(10.0f * this.vertices[this.vertexOrder[n9]][n4])) - d3) * ((d = (double)(-10.0f * this.vertices[this.vertexOrder[n11]][n3])) - d5)) continue;
            for (n10 = 0; n10 < n; ++n10) {
                if (n10 == n12 || n10 == n9 || n10 == n11) continue;
                double d7 = -10.0f * this.vertices[this.vertexOrder[n10]][n3];
                double d8 = 10.0f * this.vertices[this.vertexOrder[n10]][n4];
                double d9 = d - d6;
                double d10 = d4 - d2;
                double d11 = d5 - d;
                double d12 = d3 - d4;
                double d13 = d6 - d5;
                double d14 = d2 - d3;
                double d15 = d7 - d5;
                double d16 = d8 - d3;
                double d17 = d7 - d6;
                double d18 = d8 - d2;
                double d19 = d7 - d;
                double d20 = d8 - d4;
                double d21 = d9 * d18 - d10 * d17;
                double d22 = d13 * d16 - d14 * d15;
                double d23 = d11 * d20 - d12 * d19;
                if (!(d21 >= 0.0) || !(d23 >= 0.0) || !(d22 >= 0.0)) continue;
                bl = false;
            }
            if (!bl) continue;
            this.addTriangle(this.vertexOrder[n12], this.vertexOrder[n9], this.vertexOrder[n11]);
            ++n8;
            n10 = n9;
            for (int i = n9 + 1; i < n; ++i) {
                this.vertexOrder[n10] = this.vertexOrder[i];
                ++n10;
            }
            n7 = 2 * --n;
        }
    }

    private void toWorldNormal(float f, float f2, float f3, float[] fArray) {
        fArray[0] = this.modelviewInv.m00 * f + this.modelviewInv.m10 * f2 + this.modelviewInv.m20 * f3 + this.modelviewInv.m30;
        fArray[1] = this.modelviewInv.m01 * f + this.modelviewInv.m11 * f2 + this.modelviewInv.m21 * f3 + this.modelviewInv.m31;
        fArray[2] = this.modelviewInv.m02 * f + this.modelviewInv.m12 * f2 + this.modelviewInv.m22 * f3 + this.modelviewInv.m32;
        fArray[3] = this.modelviewInv.m03 * f + this.modelviewInv.m13 * f2 + this.modelviewInv.m23 * f3 + this.modelviewInv.m33;
        if (fArray[3] != 0.0f && fArray[3] != 1.0f) {
            fArray[0] = fArray[0] / fArray[3];
            fArray[1] = fArray[1] / fArray[3];
            fArray[2] = fArray[2] / fArray[3];
        }
        fArray[3] = 1.0f;
        float f4 = this.mag(fArray[0], fArray[1], fArray[2]);
        if (f4 != 0.0f && f4 != 1.0f) {
            fArray[0] = fArray[0] / f4;
            fArray[1] = fArray[1] / f4;
            fArray[2] = fArray[2] / f4;
        }
    }

    private void calcLightingContribution(int n, float[] fArray) {
        this.calcLightingContribution(n, fArray, false);
    }

    private void calcLightingContribution(int n, float[] fArray, boolean bl) {
        float[] fArray2 = this.vertices[n];
        float f = fArray2[28];
        float f2 = fArray2[29];
        float f3 = fArray2[30];
        float f4 = fArray2[21];
        float f5 = fArray2[22];
        float f6 = fArray2[23];
        float f7 = fArray2[31];
        float f8 = fArray2[9];
        float f9 = fArray2[10];
        float f10 = fArray2[11];
        if (!bl) {
            this.toWorldNormal(fArray2[9], fArray2[10], fArray2[11], this.worldNormal);
            f8 = this.worldNormal[0];
            f9 = this.worldNormal[1];
            f10 = this.worldNormal[2];
        } else {
            f8 = fArray2[9];
            f9 = fArray2[10];
            f10 = fArray2[11];
        }
        float f11 = this.dot(f8, f9, f10, -f4, -f5, -f6);
        if (f11 < 0.0f) {
            f8 = -f8;
            f9 = -f9;
            f10 = -f10;
        }
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 0.0f;
        for (int i = 0; i < this.lightCount; ++i) {
            float f12;
            float f13;
            float f14;
            float f15;
            float f16;
            float f17;
            float f18;
            float f19;
            float f20 = this.lightFalloffConstant[i];
            float f21 = 1.0f;
            if (this.lightType[i] == 0) {
                if (this.lightFalloffQuadratic[i] != 0.0f || this.lightFalloffLinear[i] != 0.0f) {
                    f19 = this.mag(this.lightPosition[i].x - f4, this.lightPosition[i].y - f5, this.lightPosition[i].z - f6);
                    f20 += this.lightFalloffQuadratic[i] * f19 + this.lightFalloffLinear[i] * this.sqrt(f19);
                }
                if (f20 == 0.0f) {
                    f20 = 1.0f;
                }
                fArray[0] = fArray[0] + this.lightDiffuse[i][0] / f20;
                fArray[1] = fArray[1] + this.lightDiffuse[i][1] / f20;
                fArray[2] = fArray[2] + this.lightDiffuse[i][2] / f20;
                continue;
            }
            float f22 = 0.0f;
            float f23 = 0.0f;
            if (this.lightType[i] == 1) {
                f19 = -this.lightNormal[i].x;
                f18 = -this.lightNormal[i].y;
                f17 = -this.lightNormal[i].z;
                f20 = 1.0f;
                f23 = f8 * f19 + f9 * f18 + f10 * f17;
                if (f23 <= 0.0f) {
                    continue;
                }
            } else {
                f19 = this.lightPosition[i].x - f4;
                f18 = this.lightPosition[i].y - f5;
                f17 = this.lightPosition[i].z - f6;
                f16 = this.mag(f19, f18, f17);
                if (f16 != 0.0f) {
                    f19 /= f16;
                    f18 /= f16;
                    f17 /= f16;
                }
                if ((f23 = f8 * f19 + f9 * f18 + f10 * f17) <= 0.0f) continue;
                if (this.lightType[i] == 3) {
                    f22 = -(this.lightNormal[i].x * f19 + this.lightNormal[i].y * f18 + this.lightNormal[i].z * f17);
                    if (f22 <= this.lightSpotAngleCos[i]) continue;
                    f21 = (float)Math.pow(f22, this.lightSpotConcentration[i]);
                }
                if (this.lightFalloffQuadratic[i] != 0.0f || this.lightFalloffLinear[i] != 0.0f) {
                    f20 += this.lightFalloffQuadratic[i] * f16 + this.lightFalloffLinear[i] * this.sqrt(f16);
                }
            }
            if (f20 == 0.0f) {
                f20 = 1.0f;
            }
            f16 = f23 * f21 / f20;
            fArray[3] = fArray[3] + this.lightDiffuse[i][0] * f16;
            fArray[4] = fArray[4] + this.lightDiffuse[i][1] * f16;
            fArray[5] = fArray[5] + this.lightDiffuse[i][2] * f16;
            if (!(f > 0.0f) && !(f2 > 0.0f) && !(f3 > 0.0f) || !(this.lightSpecular[i][0] > 0.0f) && !(this.lightSpecular[i][1] > 0.0f) && !(this.lightSpecular[i][2] > 0.0f)) continue;
            float f24 = this.mag(f4, f5, f6);
            if (f24 != 0.0f) {
                f4 /= f24;
                f5 /= f24;
                f6 /= f24;
            }
            if ((f24 = this.mag(f15 = f19 - f4, f14 = f18 - f5, f13 = f17 - f6)) != 0.0f) {
                f15 /= f24;
                f14 /= f24;
                f13 /= f24;
            }
            if (!((f12 = f15 * f8 + f14 * f9 + f13 * f10) > 0.0f)) continue;
            f12 = (float)Math.pow(f12, f7);
            f16 = f12 * f21 / f20;
            fArray[6] = fArray[6] + this.lightSpecular[i][0] * f16;
            fArray[7] = fArray[7] + this.lightSpecular[i][1] * f16;
            fArray[8] = fArray[8] + this.lightSpecular[i][2] * f16;
        }
    }

    private void applyLightingContribution(int n, float[] fArray) {
        float[] fArray2 = this.vertices[n];
        fArray2[3] = this.clamp(fArray2[32] + fArray2[25] * fArray[0] + fArray2[3] * fArray[3]);
        fArray2[4] = this.clamp(fArray2[33] + fArray2[26] * fArray[1] + fArray2[4] * fArray[4]);
        fArray2[5] = this.clamp(fArray2[34] + fArray2[27] * fArray[2] + fArray2[5] * fArray[5]);
        fArray2[6] = this.clamp(fArray2[6]);
        fArray2[28] = this.clamp(fArray2[28] * fArray[6]);
        fArray2[29] = this.clamp(fArray2[29] * fArray[7]);
        fArray2[30] = this.clamp(fArray2[30] * fArray[8]);
        fArray2[35] = 1.0f;
    }

    private void lightVertex(int n, float[] fArray) {
        this.calcLightingContribution(n, fArray);
        this.applyLightingContribution(n, fArray);
    }

    private void lightUnlitVertex(int n, float[] fArray) {
        if (this.vertices[n][35] == 0.0f) {
            this.lightVertex(n, fArray);
        }
    }

    private void copyPrelitVertexColor(int n, int n2, int n3) {
        float[] fArray = this.triangleColors[n][n3];
        float[] fArray2 = this.vertices[n2];
        fArray[0] = fArray2[3];
        fArray[1] = fArray2[4];
        fArray[2] = fArray2[5];
        fArray[3] = fArray2[6];
        fArray[4] = fArray2[28];
        fArray[5] = fArray2[29];
        fArray[6] = fArray2[30];
    }

    private void copyVertexColor(int n, int n2, int n3, float[] fArray) {
        float[] fArray2 = this.triangleColors[n][n3];
        float[] fArray3 = this.vertices[n2];
        fArray2[0] = this.clamp(fArray3[32] + fArray3[25] * fArray[0] + fArray3[3] * fArray[3]);
        fArray2[1] = this.clamp(fArray3[33] + fArray3[26] * fArray[1] + fArray3[4] * fArray[4]);
        fArray2[2] = this.clamp(fArray3[34] + fArray3[27] * fArray[2] + fArray3[5] * fArray[5]);
        fArray2[3] = this.clamp(fArray3[6]);
        fArray2[4] = this.clamp(fArray3[28] * fArray[6]);
        fArray2[5] = this.clamp(fArray3[29] * fArray[7]);
        fArray2[6] = this.clamp(fArray3[30] * fArray[8]);
    }

    private void lightTriangle(int n, float[] fArray) {
        int n2 = this.triangles[n][0];
        this.copyVertexColor(n, n2, 0, fArray);
        n2 = this.triangles[n][1];
        this.copyVertexColor(n, n2, 1, fArray);
        n2 = this.triangles[n][2];
        this.copyVertexColor(n, n2, 2, fArray);
    }

    private void lightTriangle(int n) {
        if (this.normalMode == 2) {
            int n2 = this.triangles[n][0];
            this.lightUnlitVertex(n2, this.tempLightingContribution);
            this.copyPrelitVertexColor(n, n2, 0);
            n2 = this.triangles[n][1];
            this.lightUnlitVertex(n2, this.tempLightingContribution);
            this.copyPrelitVertexColor(n, n2, 1);
            n2 = this.triangles[n][2];
            this.lightUnlitVertex(n2, this.tempLightingContribution);
            this.copyPrelitVertexColor(n, n2, 2);
        } else if (!this.lightingDependsOnVertexPosition) {
            int n3 = this.triangles[n][0];
            int n4 = this.triangles[n][1];
            int n5 = this.triangles[n][2];
            this.cross(this.vertices[n4][21] - this.vertices[n3][21], this.vertices[n4][22] - this.vertices[n3][22], this.vertices[n4][23] - this.vertices[n3][23], this.vertices[n5][21] - this.vertices[n3][21], this.vertices[n5][22] - this.vertices[n3][22], this.vertices[n5][23] - this.vertices[n3][23], this.lightTriangleNorm);
            this.lightTriangleNorm.normalize();
            this.vertices[n3][9] = this.lightTriangleNorm.x;
            this.vertices[n3][10] = this.lightTriangleNorm.y;
            this.vertices[n3][11] = this.lightTriangleNorm.z;
            this.calcLightingContribution(n3, this.tempLightingContribution, true);
            this.copyVertexColor(n, n3, 0, this.tempLightingContribution);
            this.copyVertexColor(n, n4, 1, this.tempLightingContribution);
            this.copyVertexColor(n, n5, 2, this.tempLightingContribution);
        } else if (this.normalMode == 1) {
            int n6 = this.triangles[n][0];
            this.vertices[n6][9] = this.vertices[this.shapeFirst][9];
            this.vertices[n6][10] = this.vertices[this.shapeFirst][10];
            this.vertices[n6][11] = this.vertices[this.shapeFirst][11];
            this.calcLightingContribution(n6, this.tempLightingContribution);
            this.copyVertexColor(n, n6, 0, this.tempLightingContribution);
            n6 = this.triangles[n][1];
            this.vertices[n6][9] = this.vertices[this.shapeFirst][9];
            this.vertices[n6][10] = this.vertices[this.shapeFirst][10];
            this.vertices[n6][11] = this.vertices[this.shapeFirst][11];
            this.calcLightingContribution(n6, this.tempLightingContribution);
            this.copyVertexColor(n, n6, 1, this.tempLightingContribution);
            n6 = this.triangles[n][2];
            this.vertices[n6][9] = this.vertices[this.shapeFirst][9];
            this.vertices[n6][10] = this.vertices[this.shapeFirst][10];
            this.vertices[n6][11] = this.vertices[this.shapeFirst][11];
            this.calcLightingContribution(n6, this.tempLightingContribution);
            this.copyVertexColor(n, n6, 2, this.tempLightingContribution);
        } else {
            int n7 = this.triangles[n][0];
            int n8 = this.triangles[n][1];
            int n9 = this.triangles[n][2];
            this.cross(this.vertices[n8][21] - this.vertices[n7][21], this.vertices[n8][22] - this.vertices[n7][22], this.vertices[n8][23] - this.vertices[n7][23], this.vertices[n9][21] - this.vertices[n7][21], this.vertices[n9][22] - this.vertices[n7][22], this.vertices[n9][23] - this.vertices[n7][23], this.lightTriangleNorm);
            this.lightTriangleNorm.normalize();
            this.vertices[n7][9] = this.lightTriangleNorm.x;
            this.vertices[n7][10] = this.lightTriangleNorm.y;
            this.vertices[n7][11] = this.lightTriangleNorm.z;
            this.calcLightingContribution(n7, this.tempLightingContribution, true);
            this.copyVertexColor(n, n7, 0, this.tempLightingContribution);
            this.vertices[n8][9] = this.lightTriangleNorm.x;
            this.vertices[n8][10] = this.lightTriangleNorm.y;
            this.vertices[n8][11] = this.lightTriangleNorm.z;
            this.calcLightingContribution(n8, this.tempLightingContribution, true);
            this.copyVertexColor(n, n8, 1, this.tempLightingContribution);
            this.vertices[n9][9] = this.lightTriangleNorm.x;
            this.vertices[n9][10] = this.lightTriangleNorm.y;
            this.vertices[n9][11] = this.lightTriangleNorm.z;
            this.calcLightingContribution(n9, this.tempLightingContribution, true);
            this.copyVertexColor(n, n9, 2, this.tempLightingContribution);
        }
    }

    protected void renderTriangles(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            float[] fArray = this.vertices[this.triangles[i][0]];
            float[] fArray2 = this.vertices[this.triangles[i][1]];
            float[] fArray3 = this.vertices[this.triangles[i][2]];
            int n3 = this.triangles[i][3];
            this.triangle.reset();
            float f = this.clamp(this.triangleColors[i][0][0] + this.triangleColors[i][0][4]);
            float f2 = this.clamp(this.triangleColors[i][0][1] + this.triangleColors[i][0][5]);
            float f3 = this.clamp(this.triangleColors[i][0][2] + this.triangleColors[i][0][6]);
            float f4 = this.clamp(this.triangleColors[i][1][0] + this.triangleColors[i][1][4]);
            float f5 = this.clamp(this.triangleColors[i][1][1] + this.triangleColors[i][1][5]);
            float f6 = this.clamp(this.triangleColors[i][1][2] + this.triangleColors[i][1][6]);
            float f7 = this.clamp(this.triangleColors[i][2][0] + this.triangleColors[i][2][4]);
            float f8 = this.clamp(this.triangleColors[i][2][1] + this.triangleColors[i][2][5]);
            float f9 = this.clamp(this.triangleColors[i][2][2] + this.triangleColors[i][2][6]);
            boolean bl = false;
            if (s_enableAccurateTextures && this.frustumMode) {
                boolean bl2 = true;
                this.smoothTriangle.reset(3);
                this.smoothTriangle.smooth = true;
                this.smoothTriangle.interpARGB = true;
                this.smoothTriangle.setIntensities(f, f2, f3, fArray[6], f4, f5, f6, fArray2[6], f7, f8, f9, fArray3[6]);
                if (n3 > -1 && this.textures[n3] != null) {
                    this.smoothTriangle.setCamVertices(fArray[21], fArray[22], fArray[23], fArray2[21], fArray2[22], fArray2[23], fArray3[21], fArray3[22], fArray3[23]);
                    this.smoothTriangle.interpUV = true;
                    this.smoothTriangle.texture(this.textures[n3]);
                    float f10 = this.textures[n3].width;
                    float f11 = this.textures[n3].height;
                    this.smoothTriangle.vertices[0][7] = fArray[7] * f10;
                    this.smoothTriangle.vertices[0][8] = fArray[8] * f11;
                    this.smoothTriangle.vertices[1][7] = fArray2[7] * f10;
                    this.smoothTriangle.vertices[1][8] = fArray2[8] * f11;
                    this.smoothTriangle.vertices[2][7] = fArray3[7] * f10;
                    this.smoothTriangle.vertices[2][8] = fArray3[8] * f11;
                } else {
                    this.smoothTriangle.interpUV = false;
                    bl2 = false;
                }
                this.smoothTriangle.setVertices(fArray[18], fArray[19], fArray[20], fArray2[18], fArray2[19], fArray2[20], fArray3[18], fArray3[19], fArray3[20]);
                if (!bl2 || this.smoothTriangle.precomputeAccurateTexturing()) {
                    this.smoothTriangle.render();
                } else {
                    bl = true;
                }
            }
            if (s_enableAccurateTextures && !bl && this.frustumMode) continue;
            if (n3 > -1 && this.textures[n3] != null) {
                this.triangle.setTexture(this.textures[n3]);
                this.triangle.setUV(fArray[7], fArray[8], fArray2[7], fArray2[8], fArray3[7], fArray3[8]);
            }
            this.triangle.setIntensities(f, f2, f3, fArray[6], f4, f5, f6, fArray2[6], f7, f8, f9, fArray3[6]);
            this.triangle.setVertices(fArray[18], fArray[19], fArray[20], fArray2[18], fArray2[19], fArray2[20], fArray3[18], fArray3[19], fArray3[20]);
            this.triangle.render();
        }
    }

    protected void rawTriangles(int n, int n2) {
        this.raw.colorMode(1, 1.0f);
        this.raw.noStroke();
        this.raw.beginShape(9);
        for (int i = n; i < n2; ++i) {
            PImage pImage;
            float[] fArray = this.vertices[this.triangles[i][0]];
            float[] fArray2 = this.vertices[this.triangles[i][1]];
            float[] fArray3 = this.vertices[this.triangles[i][2]];
            float f = this.clamp(this.triangleColors[i][0][0] + this.triangleColors[i][0][4]);
            float f2 = this.clamp(this.triangleColors[i][0][1] + this.triangleColors[i][0][5]);
            float f3 = this.clamp(this.triangleColors[i][0][2] + this.triangleColors[i][0][6]);
            float f4 = this.clamp(this.triangleColors[i][1][0] + this.triangleColors[i][1][4]);
            float f5 = this.clamp(this.triangleColors[i][1][1] + this.triangleColors[i][1][5]);
            float f6 = this.clamp(this.triangleColors[i][1][2] + this.triangleColors[i][1][6]);
            float f7 = this.clamp(this.triangleColors[i][2][0] + this.triangleColors[i][2][4]);
            float f8 = this.clamp(this.triangleColors[i][2][1] + this.triangleColors[i][2][5]);
            float f9 = this.clamp(this.triangleColors[i][2][2] + this.triangleColors[i][2][6]);
            int n3 = this.triangles[i][3];
            PImage pImage2 = pImage = n3 > -1 ? this.textures[n3] : null;
            if (pImage != null) {
                if (this.raw.is3D()) {
                    if (fArray[24] == 0.0f || fArray2[24] == 0.0f || fArray3[24] == 0.0f) continue;
                    this.raw.fill(f, f2, f3, fArray[6]);
                    this.raw.vertex(fArray[21] / fArray[24], fArray[22] / fArray[24], fArray[23] / fArray[24], fArray[7], fArray[8]);
                    this.raw.fill(f4, f5, f6, fArray2[6]);
                    this.raw.vertex(fArray2[21] / fArray2[24], fArray2[22] / fArray2[24], fArray2[23] / fArray2[24], fArray2[7], fArray2[8]);
                    this.raw.fill(f7, f8, f9, fArray3[6]);
                    this.raw.vertex(fArray3[21] / fArray3[24], fArray3[22] / fArray3[24], fArray3[23] / fArray3[24], fArray3[7], fArray3[8]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                this.raw.fill(f, f2, f3, fArray[6]);
                this.raw.vertex(fArray[18], fArray[19], fArray[7], fArray[8]);
                this.raw.fill(f4, f5, f6, fArray2[6]);
                this.raw.vertex(fArray2[18], fArray2[19], fArray2[7], fArray2[8]);
                this.raw.fill(f7, f8, f9, fArray3[6]);
                this.raw.vertex(fArray3[18], fArray3[19], fArray3[7], fArray3[8]);
                continue;
            }
            if (this.raw.is3D()) {
                if (fArray[24] == 0.0f || fArray2[24] == 0.0f || fArray3[24] == 0.0f) continue;
                this.raw.fill(f, f2, f3, fArray[6]);
                this.raw.vertex(fArray[21] / fArray[24], fArray[22] / fArray[24], fArray[23] / fArray[24]);
                this.raw.fill(f4, f5, f6, fArray2[6]);
                this.raw.vertex(fArray2[21] / fArray2[24], fArray2[22] / fArray2[24], fArray2[23] / fArray2[24]);
                this.raw.fill(f7, f8, f9, fArray3[6]);
                this.raw.vertex(fArray3[21] / fArray3[24], fArray3[22] / fArray3[24], fArray3[23] / fArray3[24]);
                continue;
            }
            if (!this.raw.is2D()) continue;
            this.raw.fill(f, f2, f3, fArray[6]);
            this.raw.vertex(fArray[18], fArray[19]);
            this.raw.fill(f4, f5, f6, fArray2[6]);
            this.raw.vertex(fArray2[18], fArray2[19]);
            this.raw.fill(f7, f8, f9, fArray3[6]);
            this.raw.vertex(fArray3[18], fArray3[19]);
        }
        this.raw.endShape();
    }

    public void flush() {
        if (this.hints[5]) {
            this.sort();
        }
        this.render();
    }

    protected void render() {
        if (this.pointCount > 0) {
            this.renderPoints(0, this.pointCount);
            if (this.raw != null) {
                this.rawPoints(0, this.pointCount);
            }
            this.pointCount = 0;
        }
        if (this.lineCount > 0) {
            this.renderLines(0, this.lineCount);
            if (this.raw != null) {
                this.rawLines(0, this.lineCount);
            }
            this.lineCount = 0;
            this.pathCount = 0;
        }
        if (this.triangleCount > 0) {
            this.renderTriangles(0, this.triangleCount);
            if (this.raw != null) {
                this.rawTriangles(0, this.triangleCount);
            }
            this.triangleCount = 0;
        }
    }

    protected void sort() {
        if (this.triangleCount > 0) {
            this.sortTrianglesInternal(0, this.triangleCount - 1);
        }
    }

    private void sortTrianglesInternal(int n, int n2) {
        int n3 = (n + n2) / 2;
        this.sortTrianglesSwap(n3, n2);
        int n4 = this.sortTrianglesPartition(n - 1, n2);
        this.sortTrianglesSwap(n4, n2);
        if (n4 - n > 1) {
            this.sortTrianglesInternal(n, n4 - 1);
        }
        if (n2 - n4 > 1) {
            this.sortTrianglesInternal(n4 + 1, n2);
        }
    }

    private int sortTrianglesPartition(int n, int n2) {
        int n3 = n2;
        while (true) {
            if (this.sortTrianglesCompare(++n, n3) < 0.0f) {
                continue;
            }
            while (n2 != 0 && this.sortTrianglesCompare(--n2, n3) > 0.0f) {
            }
            this.sortTrianglesSwap(n, n2);
            if (n >= n2) break;
        }
        this.sortTrianglesSwap(n, n2);
        return n;
    }

    private void sortTrianglesSwap(int n, int n2) {
        int[] nArray = this.triangles[n];
        this.triangles[n] = this.triangles[n2];
        this.triangles[n2] = nArray;
        float[][] fArray = this.triangleColors[n];
        this.triangleColors[n] = this.triangleColors[n2];
        this.triangleColors[n2] = fArray;
    }

    private float sortTrianglesCompare(int n, int n2) {
        return this.vertices[this.triangles[n2][0]][20] + this.vertices[this.triangles[n2][1]][20] + this.vertices[this.triangles[n2][2]][20] - (this.vertices[this.triangles[n][0]][20] + this.vertices[this.triangles[n][1]][20] + this.vertices[this.triangles[n][2]][20]);
    }

    protected void ellipseImpl(float f, float f2, float f3, float f4) {
        int n;
        boolean bl;
        float f5;
        float f6;
        float f7 = f3 / 2.0f;
        float f8 = f4 / 2.0f;
        float f9 = f + f7;
        float f10 = f2 + f8;
        int n2 = (int)(4.0 + Math.sqrt(f3 + f4) * 3.0);
        int n3 = PApplet.constrain(n2, 6, 100);
        if (this.fill) {
            f6 = 720.0f / (float)n3;
            f5 = 0.0f;
            bl = this.stroke;
            this.stroke = false;
            n = this.smooth;
            if (this.smooth && this.stroke) {
                this.smooth = false;
            }
            this.beginShape(11);
            this.normal(0.0f, 0.0f, 1.0f);
            this.vertex(f9, f10);
            for (int i = 0; i < n3; ++i) {
                this.vertex(f9 + cosLUT[(int)f5] * f7, f10 + sinLUT[(int)f5] * f8);
                f5 = (f5 + f6) % 720.0f;
            }
            this.vertex(f9 + cosLUT[0] * f7, f10 + sinLUT[0] * f8);
            this.endShape();
            this.stroke = bl;
            this.smooth = n;
        }
        if (this.stroke) {
            f6 = 720.0f / (float)n3;
            f5 = 0.0f;
            bl = this.fill;
            this.fill = false;
            f5 = 0.0f;
            this.beginShape();
            for (n = 0; n < n3; ++n) {
                this.vertex(f9 + cosLUT[(int)f5] * f7, f10 + sinLUT[(int)f5] * f8);
                f5 = (f5 + f6) % 720.0f;
            }
            this.endShape(2);
            this.fill = bl;
        }
    }

    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        float f7 = f3 / 2.0f;
        float f8 = f4 / 2.0f;
        float f9 = f + f7;
        float f10 = f2 + f8;
        if (this.fill) {
            bl = this.stroke;
            this.stroke = false;
            n5 = (int)(0.5f + f5 / ((float)Math.PI * 2) * 720.0f);
            n4 = (int)(0.5f + f6 / ((float)Math.PI * 2) * 720.0f);
            this.beginShape(11);
            this.vertex(f9, f10);
            n3 = 1;
            for (n2 = n5; n2 < n4; n2 += n3) {
                n = n2 % 720;
                if (n < 0) {
                    n += 720;
                }
                this.vertex(f9 + cosLUT[n] * f7, f10 + sinLUT[n] * f8);
            }
            this.vertex(f9 + cosLUT[n4 % 720] * f7, f10 + sinLUT[n4 % 720] * f8);
            this.endShape();
            this.stroke = bl;
        }
        if (this.stroke) {
            bl = this.fill;
            this.fill = false;
            n5 = (int)(0.5f + f5 / ((float)Math.PI * 2) * 720.0f);
            n4 = (int)(0.5f + f6 / ((float)Math.PI * 2) * 720.0f);
            this.beginShape();
            n3 = 1;
            for (n2 = n5; n2 < n4; n2 += n3) {
                n = n2 % 720;
                if (n < 0) {
                    n += 720;
                }
                this.vertex(f9 + cosLUT[n] * f7, f10 + sinLUT[n] * f8);
            }
            this.vertex(f9 + cosLUT[n4 % 720] * f7, f10 + sinLUT[n4 % 720] * f8);
            this.endShape();
            this.fill = bl;
        }
    }

    public void box(float f, float f2, float f3) {
        if (this.triangle != null) {
            this.triangle.setCulling(true);
        }
        super.box(f, f2, f3);
        if (this.triangle != null) {
            this.triangle.setCulling(false);
        }
    }

    public void sphere(float f) {
        if (this.triangle != null) {
            this.triangle.setCulling(true);
        }
        super.sphere(f);
        if (this.triangle != null) {
            this.triangle.setCulling(false);
        }
    }

    public void smooth() {
        s_enableAccurateTextures = true;
        this.smooth = true;
    }

    public void noSmooth() {
        s_enableAccurateTextures = false;
        this.smooth = false;
    }

    protected boolean textModeCheck(int n) {
        return this.textMode == 4 || this.textMode == 256;
    }

    public void pushMatrix() {
        if (this.matrixMode == 0) {
            if (this.pmatrixStackDepth == 32) {
                throw new RuntimeException("Too many calls to pushMatrix().");
            }
            this.projection.get(this.pmatrixStack[this.pmatrixStackDepth]);
            ++this.pmatrixStackDepth;
        } else {
            if (this.matrixStackDepth == 32) {
                throw new RuntimeException("Too many calls to pushMatrix().");
            }
            this.modelview.get(this.matrixStack[this.matrixStackDepth]);
            this.modelviewInv.get(this.matrixInvStack[this.matrixStackDepth]);
            ++this.matrixStackDepth;
        }
    }

    public void popMatrix() {
        if (this.matrixMode == 0) {
            if (this.pmatrixStackDepth == 0) {
                throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
            }
            --this.pmatrixStackDepth;
            this.projection.set(this.pmatrixStack[this.pmatrixStackDepth]);
        } else {
            if (this.matrixStackDepth == 0) {
                throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
            }
            --this.matrixStackDepth;
            this.modelview.set(this.matrixStack[this.matrixStackDepth]);
            this.modelviewInv.set(this.matrixInvStack[this.matrixStackDepth]);
        }
    }

    public void translate(float f, float f2) {
        this.translate(f, f2, 0.0f);
    }

    public void translate(float f, float f2, float f3) {
        if (this.matrixMode == 0) {
            this.projection.translate(f, f2, f3);
        } else {
            this.forwardTransform.translate(f, f2, f3);
            this.reverseTransform.invTranslate(f, f2, f3);
        }
    }

    public void rotate(float f) {
        this.rotateZ(f);
    }

    public void rotateX(float f) {
        if (this.matrixMode == 0) {
            this.projection.rotateX(f);
        } else {
            this.forwardTransform.rotateX(f);
            this.reverseTransform.invRotateX(f);
        }
    }

    public void rotateY(float f) {
        if (this.matrixMode == 0) {
            this.projection.rotateY(f);
        } else {
            this.forwardTransform.rotateY(f);
            this.reverseTransform.invRotateY(f);
        }
    }

    public void rotateZ(float f) {
        if (this.matrixMode == 0) {
            this.projection.rotateZ(f);
        } else {
            this.forwardTransform.rotateZ(f);
            this.reverseTransform.invRotateZ(f);
        }
    }

    public void rotate(float f, float f2, float f3, float f4) {
        if (this.matrixMode == 0) {
            this.projection.rotate(f, f2, f3, f4);
        } else {
            this.forwardTransform.rotate(f, f2, f3, f4);
            this.reverseTransform.invRotate(f, f2, f3, f4);
        }
    }

    public void scale(float f) {
        this.scale(f, f, f);
    }

    public void scale(float f, float f2) {
        this.scale(f, f2, 1.0f);
    }

    public void scale(float f, float f2, float f3) {
        if (this.matrixMode == 0) {
            this.projection.scale(f, f2, f3);
        } else {
            this.forwardTransform.scale(f, f2, f3);
            this.reverseTransform.invScale(f, f2, f3);
        }
    }

    public void shearX(float f) {
        float f2 = (float)Math.tan(f);
        this.applyMatrix(1.0f, f2, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void shearY(float f) {
        float f2 = (float)Math.tan(f);
        this.applyMatrix(1.0f, 0.0f, 0.0f, 0.0f, f2, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void resetMatrix() {
        if (this.matrixMode == 0) {
            this.projection.reset();
        } else {
            this.forwardTransform.reset();
            this.reverseTransform.reset();
        }
    }

    public void applyMatrix(PMatrix2D pMatrix2D) {
        this.applyMatrix(pMatrix2D.m00, pMatrix2D.m01, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, pMatrix2D.m12);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.applyMatrix(f, f2, f3, 0.0f, f4, f5, f6, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void applyMatrix(PMatrix3D pMatrix3D) {
        this.applyMatrix(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        if (this.matrixMode == 0) {
            this.projection.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        } else {
            this.forwardTransform.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
            this.reverseTransform.invApply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        }
    }

    public PMatrix getMatrix() {
        if (this.matrixMode == 0) {
            return this.projection.get();
        }
        return this.modelview.get();
    }

    public PMatrix3D getMatrix(PMatrix3D pMatrix3D) {
        if (pMatrix3D == null) {
            pMatrix3D = new PMatrix3D();
        }
        if (this.matrixMode == 0) {
            pMatrix3D.set(this.projection);
        } else {
            pMatrix3D.set(this.modelview);
        }
        return pMatrix3D;
    }

    public void setMatrix(PMatrix2D pMatrix2D) {
        this.resetMatrix();
        this.applyMatrix(pMatrix2D);
    }

    public void setMatrix(PMatrix3D pMatrix3D) {
        this.resetMatrix();
        this.applyMatrix(pMatrix3D);
    }

    public void printMatrix() {
        if (this.matrixMode == 0) {
            this.projection.print();
        } else {
            this.modelview.print();
        }
    }

    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
        this.forwardTransform = this.cameraInv;
        this.reverseTransform = this.camera;
    }

    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.manipulatingCamera = false;
    }

    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f - f4;
        float f11 = f2 - f5;
        float f12 = f3 - f6;
        float f13 = this.sqrt(f10 * f10 + f11 * f11 + f12 * f12);
        if (f13 != 0.0f) {
            f10 /= f13;
            f11 /= f13;
            f12 /= f13;
        }
        float f14 = f7;
        float f15 = f8;
        float f16 = f9;
        float f17 = f15 * f12 - f16 * f11;
        float f18 = -f14 * f12 + f16 * f10;
        float f19 = f14 * f11 - f15 * f10;
        f14 = f11 * f19 - f12 * f18;
        f15 = -f10 * f19 + f12 * f17;
        f16 = f10 * f18 - f11 * f17;
        f13 = this.sqrt(f17 * f17 + f18 * f18 + f19 * f19);
        if (f13 != 0.0f) {
            f17 /= f13;
            f18 /= f13;
            f19 /= f13;
        }
        if ((f13 = this.sqrt(f14 * f14 + f15 * f15 + f16 * f16)) != 0.0f) {
            f14 /= f13;
            f15 /= f13;
            f16 /= f13;
        }
        this.camera.set(f17, f18, f19, 0.0f, f14, f15, f16, 0.0f, f10, f11, f12, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.camera.translate(-f, -f2, -f3);
        this.cameraInv.reset();
        this.cameraInv.invApply(f17, f18, f19, 0.0f, f14, f15, f16, 0.0f, f10, f11, f12, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.cameraInv.translate(f, f2, f3);
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
    }

    public void printCamera() {
        this.camera.print();
    }

    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, -10.0f, 10.0f);
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 2.0f / (f2 - f);
        float f8 = 2.0f / (f4 - f3);
        float f9 = -2.0f / (f6 - f5);
        float f10 = -(f2 + f) / (f2 - f);
        float f11 = -(f4 + f3) / (f4 - f3);
        float f12 = -(f6 + f5) / (f6 - f5);
        this.projection.set(f7, 0.0f, 0.0f, f10, 0.0f, f8, 0.0f, f11, 0.0f, 0.0f, f9, f12, 0.0f, 0.0f, 0.0f, 1.0f);
        this.updateProjection();
        this.frustumMode = false;
    }

    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    public void perspective(float f, float f2, float f3, float f4) {
        float f5 = f3 * (float)Math.tan(f / 2.0f);
        float f6 = -f5;
        float f7 = f6 * f2;
        float f8 = f5 * f2;
        this.frustum(f7, f8, f6, f5, f3, f4);
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.leftScreen = f;
        this.rightScreen = f2;
        this.bottomScreen = f3;
        this.topScreen = f4;
        this.nearPlane = f5;
        this.frustumMode = true;
        this.projection.set(2.0f * f5 / (f2 - f), 0.0f, (f2 + f) / (f2 - f), 0.0f, 0.0f, 2.0f * f5 / (f4 - f3), (f4 + f3) / (f4 - f3), 0.0f, 0.0f, 0.0f, -(f6 + f5) / (f6 - f5), -(2.0f * f6 * f5) / (f6 - f5), 0.0f, 0.0f, -1.0f, 0.0f);
        this.updateProjection();
    }

    protected void updateProjection() {
    }

    public void printProjection() {
        this.projection.print();
    }

    public PMatrix getProjection() {
        return this.projection.get();
    }

    public void matrixMode(int n) {
        if (n == 0) {
            this.matrixMode = 0;
        } else if (n == 1) {
            this.matrixMode = 1;
        } else {
            PGraphics3D.showWarning("Invalid matrix mode. Use PROJECTION or MODELVIEW");
        }
    }

    public float screenX(float f, float f2) {
        return this.screenX(f, f2, 0.0f);
    }

    public float screenY(float f, float f2) {
        return this.screenY(f, f2, 0.0f);
    }

    public float screenX(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.projection.m00 * f4 + this.projection.m01 * f5 + this.projection.m02 * f6 + this.projection.m03 * f7;
        float f9 = this.projection.m30 * f4 + this.projection.m31 * f5 + this.projection.m32 * f6 + this.projection.m33 * f7;
        if (f9 != 0.0f) {
            f8 /= f9;
        }
        return (float)this.width * (1.0f + f8) / 2.0f;
    }

    public float screenY(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.projection.m10 * f4 + this.projection.m11 * f5 + this.projection.m12 * f6 + this.projection.m13 * f7;
        float f9 = this.projection.m30 * f4 + this.projection.m31 * f5 + this.projection.m32 * f6 + this.projection.m33 * f7;
        if (f9 != 0.0f) {
            f8 /= f9;
        }
        return (float)this.height * (1.0f + f8) / 2.0f;
    }

    public float screenZ(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.projection.m20 * f4 + this.projection.m21 * f5 + this.projection.m22 * f6 + this.projection.m23 * f7;
        float f9 = this.projection.m30 * f4 + this.projection.m31 * f5 + this.projection.m32 * f6 + this.projection.m33 * f7;
        if (f9 != 0.0f) {
            f8 /= f9;
        }
        return (f8 + 1.0f) / 2.0f;
    }

    public float modelX(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.cameraInv.m00 * f4 + this.cameraInv.m01 * f5 + this.cameraInv.m02 * f6 + this.cameraInv.m03 * f7;
        float f9 = this.cameraInv.m30 * f4 + this.cameraInv.m31 * f5 + this.cameraInv.m32 * f6 + this.cameraInv.m33 * f7;
        return f9 != 0.0f ? f8 / f9 : f8;
    }

    public float modelY(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.cameraInv.m10 * f4 + this.cameraInv.m11 * f5 + this.cameraInv.m12 * f6 + this.cameraInv.m13 * f7;
        float f9 = this.cameraInv.m30 * f4 + this.cameraInv.m31 * f5 + this.cameraInv.m32 * f6 + this.cameraInv.m33 * f7;
        return f9 != 0.0f ? f8 / f9 : f8;
    }

    public float modelZ(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.cameraInv.m20 * f4 + this.cameraInv.m21 * f5 + this.cameraInv.m22 * f6 + this.cameraInv.m23 * f7;
        float f9 = this.cameraInv.m30 * f4 + this.cameraInv.m31 * f5 + this.cameraInv.m32 * f6 + this.cameraInv.m33 * f7;
        return f9 != 0.0f ? f8 / f9 : f8;
    }

    public void strokeJoin(int n) {
        if (n != 8) {
            PGraphics3D.showMethodWarning("strokeJoin");
        }
    }

    public void strokeCap(int n) {
        if (n != 2) {
            PGraphics3D.showMethodWarning("strokeCap");
        }
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.ambientFromCalc();
    }

    public void lights() {
        int n = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = n;
        this.lightingDependsOnVertexPosition = false;
    }

    public void noLights() {
        this.flush();
        this.lightCount = 0;
    }

    public void ambientLight(float f, float f2, float f3) {
        this.ambientLight(f, f2, f3, 0.0f, 0.0f, 0.0f);
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 0;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightPosition(this.lightCount, f4, f5, f6);
        ++this.lightCount;
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 1;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightDirection(this.lightCount, f4, f5, f6);
        ++this.lightCount;
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 2;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition(this.lightCount, f4, f5, f6);
        ++this.lightCount;
        this.lightingDependsOnVertexPosition = true;
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 3;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition(this.lightCount, f4, f5, f6);
        this.lightDirection(this.lightCount, f7, f8, f9);
        this.lightSpotAngle[this.lightCount] = f10;
        this.lightSpotAngleCos[this.lightCount] = Math.max(0.0f, (float)Math.cos(f10));
        this.lightSpotConcentration[this.lightCount] = f11;
        ++this.lightCount;
        this.lightingDependsOnVertexPosition = true;
    }

    public void lightFalloff(float f, float f2, float f3) {
        this.currentLightFalloffConstant = f;
        this.currentLightFalloffLinear = f2;
        this.currentLightFalloffQuadratic = f3;
        this.lightingDependsOnVertexPosition = true;
    }

    public void lightSpecular(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
        this.lightingDependsOnVertexPosition = true;
    }

    protected void lightPosition(int n, float f, float f2, float f3) {
        this.lightPositionVec.set(f, f2, f3);
        this.modelview.mult(this.lightPositionVec, this.lightPosition[n]);
    }

    protected void lightDirection(int n, float f, float f2, float f3) {
        this.lightNormal[n].set(this.modelviewInv.m00 * f + this.modelviewInv.m10 * f2 + this.modelviewInv.m20 * f3 + this.modelviewInv.m30, this.modelviewInv.m01 * f + this.modelviewInv.m11 * f2 + this.modelviewInv.m21 * f3 + this.modelviewInv.m31, this.modelviewInv.m02 * f + this.modelviewInv.m12 * f2 + this.modelviewInv.m22 * f3 + this.modelviewInv.m32);
        this.lightNormal[n].normalize();
    }

    protected void backgroundImpl(PImage pImage) {
        System.arraycopy(pImage.pixels, 0, this.pixels, 0, this.pixels.length);
        Arrays.fill(this.zbuffer, Float.MAX_VALUE);
    }

    protected void backgroundImpl() {
        Arrays.fill(this.pixels, this.backgroundColor);
        Arrays.fill(this.zbuffer, Float.MAX_VALUE);
    }

    public boolean is2D() {
        return false;
    }

    public boolean is3D() {
        return true;
    }

    private final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    private final float mag(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    private final float clamp(float f) {
        return f < 1.0f ? f : 1.0f;
    }

    private final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    private float dot(float f, float f2, float f3, float f4, float f5, float f6) {
        return f * f4 + f2 * f5 + f3 * f6;
    }

    private final void cross(float f, float f2, float f3, float f4, float f5, float f6, PVector pVector) {
        pVector.x = f2 * f6 - f3 * f5;
        pVector.y = f3 * f4 - f * f6;
        pVector.z = f * f5 - f2 * f4;
    }
}

