# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.vmc.orgs.sddcs.clusters.msft_licensing.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Publish(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.clusters.msft_licensing.publish'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PublishStub)
        self._VAPI_OPERATION_IDS = {}


    def post(self,
             org,
             sddc,
             cluster,
             config_change,
             ):
        """
        Sets the current Microsoft license status of the given SDDC's cluster.

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :type  cluster: :class:`str`
        :param cluster: cluster identifier (required)
        :type  config_change: :class:`com.vmware.vmc.model_client.MsftLicensingConfig`
        :param config_change: The license data to set for the clusters. (required)
        :rtype: :class:`com.vmware.vmc.model_client.Task`
        :return: com.vmware.vmc.model.Task
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        """
        return self._invoke('post',
                            {
                            'org': org,
                            'sddc': sddc,
                            'cluster': cluster,
                            'config_change': config_change,
                            })
class _PublishStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for post operation
        post_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
            'cluster': type.StringType(),
            'config_change': type.ReferenceType('com.vmware.vmc.model_client', 'MsftLicensingConfig'),
        })
        post_error_dict = {
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        post_input_value_validator_list = [
        ]
        post_output_validator_list = [
        ]
        post_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/clusters/{cluster}/msft-licensing/publish',
            request_body_parameter='config_change',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
                'cluster': 'cluster',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'post': {
                'input_type': post_input_type,
                'output_type': type.ReferenceType('com.vmware.vmc.model_client', 'Task'),
                'errors': post_error_dict,
                'input_value_validator_list': post_input_value_validator_list,
                'output_validator_list': post_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'post': post_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.clusters.msft_licensing.publish',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Publish': Publish,
    }

