/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.tcp.timing;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.TimeableTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ClientTcpTransportHandler;
import java.io.IOException;

public class TimingClientTcpTransportHandler
extends ClientTcpTransportHandler
implements TimeableTransportHandler {
    private Long measurement = null;
    private boolean prependEarlyReadData = false;
    private int earlyReadData = 0;

    public TimingClientTcpTransportHandler(Connection connection) {
        super(connection);
    }

    public TimingClientTcpTransportHandler(long timeout, String hostname, int port) {
        super(timeout, hostname, port);
    }

    @Override
    public void sendData(byte[] data) throws IOException {
        long startTime = System.nanoTime();
        super.sendData(data);
        this.earlyReadData = this.inStream.read();
        long endTime = System.nanoTime();
        this.measurement = endTime - startTime;
        this.prependEarlyReadData = true;
    }

    @Override
    public byte[] fetchData() throws IOException {
        byte[] data = super.fetchData();
        if (!this.prependEarlyReadData) {
            return data;
        }
        byte[] dataWithEarlyReadByte = new byte[data.length + 1];
        dataWithEarlyReadByte[0] = (byte)this.earlyReadData;
        this.prependEarlyReadData = false;
        System.arraycopy(data, 0, dataWithEarlyReadByte, 1, data.length);
        return dataWithEarlyReadByte;
    }

    @Override
    public Long getLastMeasurement() {
        return this.measurement;
    }
}

