/*
 * Decompiled with CFR 0.152.
 */
package org.almworks.util;

import java.io.Serializable;
import java.util.Map;
import org.almworks.util.TypedKeyRegistry;

public class TypedKey
implements Serializable {
    private final String myName;
    private final Class myValueClass;
    private final transient TypedKeyRegistry myRegistry;

    protected TypedKey(String string, Class clazz, TypedKeyRegistry typedKeyRegistry) {
        this.myName = string;
        this.myValueClass = clazz;
        this.myRegistry = typedKeyRegistry;
        if (typedKeyRegistry != null) {
            typedKeyRegistry.add(this);
        }
    }

    public static TypedKey create(String string) {
        return new TypedKey(string, null, null);
    }

    public static TypedKey create(Class clazz) {
        return new TypedKey(clazz.getName(), clazz, null);
    }

    public static TypedKey create(String string, TypedKeyRegistry typedKeyRegistry) {
        return new TypedKey(string, null, typedKeyRegistry);
    }

    public static TypedKey create(String string, Class clazz) {
        return new TypedKey(string, clazz, null);
    }

    public final String getName() {
        return this.myName;
    }

    public Class getValueClass() {
        return this.myValueClass;
    }

    public String toString() {
        return this.myName;
    }

    public boolean isClassAware() {
        return this.myValueClass != null;
    }

    public boolean isRegistered() {
        return this.myRegistry != null;
    }

    public Object getFrom(Map map) {
        Object v = map.get(this);
        return this.cast(v);
    }

    public Object putTo(Map map, Object object) {
        Object object2 = map.put(this, object);
        return this.cast(object2);
    }

    public final Object cast(Object object) {
        assert (this.checkInstance(object));
        return object;
    }

    private boolean checkInstance(Object object) {
        if (object != null && this.myValueClass != null && !this.myValueClass.isInstance(object)) assert (false) : object + "[" + object.getClass() + "] is not an instance of " + this.myValueClass + " (" + this + ")";
        return true;
    }
}

