/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportLabourDetailPanel
extends ReportPanel {
    private final Map<UnitType, Map<Location, Integer>> data;
    private final TypeCountMap<UnitType> unitCount;
    private final List<Colony> colonies;
    private final UnitType unitType;

    public ReportLabourDetailPanel(FreeColClient freeColClient, UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        super(freeColClient, "report.labour.details");
        this.unitType = unitType;
        this.data = data;
        this.unitCount = unitCount;
        this.colonies = colonies;
    }

    @Override
    public void initialize() {
        MigPanel detailPanel = new MigPanel(new MigLayout("wrap 7", "[]30[][]30[][]30[][]", ""));
        detailPanel.setOpaque(false);
        detailPanel.add((Component)new JLabel(new ImageIcon(this.getImageLibrary().getScaledUnitTypeImage(this.unitType))), "spany");
        detailPanel.add(Utility.localizedLabel(this.unitType));
        detailPanel.add((Component)new JLabel(String.valueOf(this.unitCount.getCount(this.unitType))), "wrap 10");
        boolean canTrain = false;
        Map<Location, Integer> unitLocations = this.data.get(this.unitType);
        for (Colony colony : this.colonies) {
            if (unitLocations.get(colony) == null) continue;
            Object colonyName = colony.getName();
            if (colony.canTrain(this.unitType)) {
                canTrain = true;
                colonyName = (String)colonyName + "*";
            }
            JButton colonyButton = Utility.getLinkButton((String)colonyName, null, colony.getId());
            colonyButton.addActionListener(this);
            detailPanel.add(colonyButton);
            JLabel countLabel = new JLabel(unitLocations.get(colony).toString());
            countLabel.setForeground(Utility.getLinkColor());
            detailPanel.add(countLabel);
        }
        CollectionUtils.forEachMapEntry(unitLocations, e -> !(e.getKey() instanceof Colony), e -> {
            String locationName = Messages.message(((Location)e.getKey()).getLocationLabel());
            JButton linkButton = Utility.getLinkButton(locationName, null, ((Location)e.getKey()).getId());
            linkButton.addActionListener(this);
            detailPanel.add(linkButton);
            JLabel countLabel = new JLabel(((Integer)e.getValue()).toString());
            countLabel.setForeground(Utility.getLinkColor());
            detailPanel.add(countLabel);
        });
        if (canTrain) {
            detailPanel.add((Component)Utility.localizedLabel("report.labour.canTrain"), "newline 20, span");
        }
        this.reportPanel.add(detailPanel);
    }
}

