/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.util.CollectionUtils;

public class UnitChangeType
extends FreeColSpecObjectType {
    public static final String TAG = "unit-change-type";
    public static final String CAPTURE = "model.unitChange.capture";
    public static final String CLEAR_SKILL = "model.unitChange.clearSkill";
    public static final String CONVERSION = "model.unitChange.conversion";
    public static final String CREATION = "model.unitChange.creation";
    public static final String DEMOTION = "model.unitChange.demotion";
    public static final String EDUCATION = "model.unitChange.education";
    public static final String ENTER_COLONY = "model.unitChange.enterColony";
    public static final String EXPERIENCE = "model.unitChange.experience";
    public static final String FOUNDING_FATHER = "model.unitChange.foundingFather";
    public static final String INDEPENDENCE = "model.unitChange.independence";
    public static final String LOST_CITY = "model.unitChange.lostCity";
    public static final String NATIVES = "model.unitChange.natives";
    public static final String PROMOTION = "model.unitChange.promotion";
    public static final String UNDEAD = "model.unitChange.undead";
    public final Map<UnitType, List<UnitTypeChange>> changes = new HashMap<UnitType, List<UnitTypeChange>>();
    private boolean ownerChange = false;
    private static final String OWNER_CHANGE_TAG = "owner-change";

    public UnitChangeType(String id, Specification specification) {
        super(id, specification);
    }

    public boolean getOwnerChange() {
        return this.ownerChange;
    }

    protected Map<UnitType, List<UnitTypeChange>> getChanges() {
        return this.changes;
    }

    protected void setChanges(Map<UnitType, List<UnitTypeChange>> changes) {
        this.changes.clear();
        this.changes.putAll(changes);
    }

    public void addUnitTypeChange(UnitTypeChange uc) {
        CollectionUtils.appendToMapList(this.changes, uc.from, uc);
    }

    public List<UnitTypeChange> getUnitChanges(UnitType from) {
        List<UnitTypeChange> ret = this.changes.get(from);
        return ret == null ? Collections.emptyList() : ret;
    }

    public UnitTypeChange getUnitChange(UnitType fromType, UnitType toType) {
        return CollectionUtils.find(this.getUnitChanges(fromType), toType == null ? CollectionUtils.alwaysTrue() : uc -> uc.to == toType);
    }

    public void deleteUnitChanges(UnitType from) {
        this.changes.remove(from);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        UnitChangeType o = this.copyInCast(other, UnitChangeType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.setChanges(o.getChanges());
        this.ownerChange = o.getOwnerChange();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(OWNER_CHANGE_TAG, this.ownerChange);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (List<UnitTypeChange> utcs : this.changes.values()) {
            for (UnitTypeChange uc : utcs) {
                uc.toXML(xw);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.ownerChange = xr.getAttribute(OWNER_CHANGE_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.changes.clear();
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if ("unit-type-change".equals(tag)) {
            this.addUnitTypeChange(new UnitTypeChange(xr, spec));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getId()).append(' ').append(this.getSuffix()).append(" ownerChange=").append(this.ownerChange);
        for (Map.Entry<UnitType, List<UnitTypeChange>> entry : this.changes.entrySet()) {
            sb.append(' ').append(entry.getKey().getSuffix()).append('[');
            for (UnitTypeChange uc : entry.getValue()) {
                sb.append(' ').append(uc);
            }
            sb.append(" ]");
        }
        sb.append(']');
        return sb.toString();
    }
}

