/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public final class LocalVariantMetadata
extends DefaultVariantMetadata {
    private final CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> artifacts;

    public LocalVariantMetadata(String name, VariantResolveMetadata.Identifier identifier, ComponentIdentifier componentId, DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> sourceArtifacts, ImmutableCapabilities capabilities, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this(name, identifier, displayName, attributes, capabilities, calculatedValueContainerFactory.create(Describables.of((Object)displayName, (Object)"artifacts"), context -> {
            if (sourceArtifacts.isEmpty()) {
                return ImmutableList.of();
            }
            return (ImmutableList)model.fromMutableState(m -> {
                ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)sourceArtifacts.size());
                for (PublishArtifact sourceArtifact : sourceArtifacts) {
                    result.add((Object)new PublishArtifactLocalArtifactMetadata(componentId, sourceArtifact));
                }
                return result.build();
            });
        }));
    }

    public LocalVariantMetadata(String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, ImmutableCapabilities capabilities, List<LocalComponentArtifactMetadata> artifacts, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this(name, identifier, displayName, attributes, capabilities, calculatedValueContainerFactory.create(Describables.of((Object)displayName, (Object)"artifacts"), (Object)ImmutableList.copyOf(artifacts)));
    }

    private LocalVariantMetadata(String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, ImmutableCapabilities capabilities, CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> artifacts) {
        super(name, identifier, displayName, attributes, (ImmutableList<? extends ComponentArtifactMetadata>)ImmutableList.of(), (CapabilitiesMetadata)capabilities);
        this.artifacts = artifacts;
    }

    public LocalVariantMetadata prepareToResolveArtifacts() {
        this.artifacts.finalizeIfNotAlready();
        return this;
    }

    @Override
    public boolean isEligibleForCaching() {
        return true;
    }

    public ImmutableList<LocalComponentArtifactMetadata> getArtifacts() {
        return (ImmutableList)this.artifacts.get();
    }
}

