/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.codecache.disk;

import jadx.api.ICodeInfo;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeMetadata;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.files.FileUtils;
import jadx.gui.utils.codecache.disk.adapters.CodeAnnotationAdapter;
import jadx.gui.utils.codecache.disk.adapters.DataAdapterHelper;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CodeMetadataAdapter {
    private static final byte[] JADX_METADATA_HEADER = "jadxmd".getBytes(StandardCharsets.US_ASCII);
    private final CodeAnnotationAdapter codeAnnotationAdapter;

    public CodeMetadataAdapter(RootNode root) {
        this.codeAnnotationAdapter = new CodeAnnotationAdapter(root);
    }

    public void write(Path metadataFile, ICodeMetadata metadata) {
        FileUtils.makeDirsForFile((Path)metadataFile);
        try (OutputStream fileOutput = Files.newOutputStream(metadataFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fileOutput));){
            out.write(JADX_METADATA_HEADER);
            this.writeLines(out, metadata.getLineMapping());
            this.writeAnnotations(out, metadata.getAsMap());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write metadata file", e);
        }
    }

    /*
     * Exception decompiling
     */
    public ICodeInfo readAndBuild(Path metadataFile, String code) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeLines(DataOutput out, Map<Integer, Integer> lines) throws IOException {
        out.writeInt(lines.size());
        for (Map.Entry<Integer, Integer> entry : lines.entrySet()) {
            DataAdapterHelper.writeUVInt(out, entry.getKey());
            DataAdapterHelper.writeUVInt(out, entry.getValue());
        }
    }

    private Map<Integer, Integer> readLines(DataInput in) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> lines = new HashMap<Integer, Integer>(size);
        for (int i = 0; i < size; ++i) {
            int key = DataAdapterHelper.readUVInt(in);
            int value = DataAdapterHelper.readUVInt(in);
            lines.put(key, value);
        }
        return lines;
    }

    private void writeAnnotations(DataOutputStream out, Map<Integer, ICodeAnnotation> annotations) throws IOException {
        out.writeInt(annotations.size());
        for (Map.Entry<Integer, ICodeAnnotation> entry : annotations.entrySet()) {
            DataAdapterHelper.writeUVInt(out, entry.getKey());
            this.codeAnnotationAdapter.write((DataOutput)out, entry.getValue());
        }
    }

    private Map<Integer, ICodeAnnotation> readAnnotations(DataInputStream in) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, ICodeAnnotation> map = new HashMap<Integer, ICodeAnnotation>(size);
        for (int i = 0; i < size; ++i) {
            int pos = DataAdapterHelper.readUVInt(in);
            ICodeAnnotation ann = this.codeAnnotationAdapter.read(in);
            if (ann == null) continue;
            map.put(pos, ann);
        }
        return map;
    }
}

