/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoreRegistrationData
implements Serializable {
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final byte[] clientDataHash;

    public CoreRegistrationData(@Nullable AttestationObject attestationObject, @Nullable byte[] attestationObjectBytes, @Nullable byte[] clientDataHash) {
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = ArrayUtil.clone((byte[])attestationObjectBytes);
        this.clientDataHash = ArrayUtil.clone((byte[])clientDataHash);
    }

    public @Nullable AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    public @Nullable byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone((byte[])this.attestationObjectBytes);
    }

    public @Nullable byte[] getClientDataHash() {
        return ArrayUtil.clone((byte[])this.clientDataHash);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreRegistrationData that = (CoreRegistrationData)o;
        return Objects.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.attestationObjectBytes, that.attestationObjectBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash);
    }

    public int hashCode() {
        int result = Objects.hash(this.attestationObject);
        result = 31 * result + Arrays.hashCode(this.attestationObjectBytes);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        return result;
    }

    public String toString() {
        return "CoreRegistrationData(attestationObject=" + this.attestationObject + ", attestationObjectBytes=" + ArrayUtil.toHexString((byte[])this.attestationObjectBytes) + ", clientDataHash=" + ArrayUtil.toHexString((byte[])this.clientDataHash) + ')';
    }
}

