/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.types;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;
import org.openhab.core.types.Type;

@NonNullByDefault
public final class TypeParser {
    private static final String CORE_LIBRARY_PACKAGE = "org.openhab.core.library.types.";

    private TypeParser() {
    }

    public static @Nullable Type parseType(String typeName, String input) {
        try {
            Class<?> stateClass = Class.forName(CORE_LIBRARY_PACKAGE + typeName);
            Method valueOfMethod = stateClass.getMethod("valueOf", String.class);
            return (Type)valueOfMethod.invoke(stateClass, input);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public static @Nullable State parseState(List<Class<? extends State>> types, String s) {
        for (Class<? extends State> type : types) {
            try {
                Method valueOf = type.getMethod("valueOf", String.class);
                State state = (State)valueOf.invoke(type, s);
                if (state == null) continue;
                return state;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static @Nullable Command parseCommand(List<Class<? extends Command>> types, String s) {
        for (Class<? extends Command> type : types) {
            try {
                Method valueOf = type.getMethod("valueOf", String.class);
                Command value = (Command)valueOf.invoke(type, s);
                if (value == null) continue;
                return value;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }
}

