/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.grouping.DoubleRange;
import org.apache.lucene.search.grouping.DoubleRangeFactory;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;

public class DoubleRangeGroupSelector
extends GroupSelector<DoubleRange> {
    private final DoubleValuesSource source;
    private final DoubleRangeFactory rangeFactory;
    private Set<DoubleRange> inSecondPass;
    private boolean includeEmpty = true;
    private boolean positioned;
    private DoubleRange current;
    private LeafReaderContext context;
    private DoubleValues values;

    public DoubleRangeGroupSelector(DoubleValuesSource source, DoubleRangeFactory rangeFactory) {
        this.source = source;
        this.rangeFactory = rangeFactory;
    }

    @Override
    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        this.context = readerContext;
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        this.values = this.source.getValues(this.context, DoubleValuesSource.fromScorer((Scorable)scorer));
    }

    @Override
    public GroupSelector.State advanceTo(int doc) throws IOException {
        this.positioned = this.values.advanceExact(doc);
        if (!this.positioned) {
            return this.includeEmpty ? GroupSelector.State.ACCEPT : GroupSelector.State.SKIP;
        }
        this.current = this.rangeFactory.getRange(this.values.doubleValue(), this.current);
        if (this.inSecondPass == null) {
            return GroupSelector.State.ACCEPT;
        }
        return this.inSecondPass.contains(this.current) ? GroupSelector.State.ACCEPT : GroupSelector.State.SKIP;
    }

    @Override
    public DoubleRange currentValue() throws IOException {
        return this.positioned ? this.current : null;
    }

    @Override
    public DoubleRange copyValue() throws IOException {
        return this.positioned ? new DoubleRange(this.current.min, this.current.max) : null;
    }

    @Override
    public void setGroups(Collection<SearchGroup<DoubleRange>> searchGroups) {
        this.inSecondPass = new HashSet<DoubleRange>();
        this.includeEmpty = false;
        for (SearchGroup<DoubleRange> group : searchGroups) {
            if (group.groupValue == null) {
                this.includeEmpty = true;
                continue;
            }
            this.inSecondPass.add((DoubleRange)group.groupValue);
        }
    }
}

