/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsEcdhKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsEcdhKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhUnwrap;
import EcdhEdkWrapping_Compile.EcdhUnwrapInfo;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations_KmsPrivateKeyToStaticPublicKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations_KmsPublicKeyDiscovery;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsPublicKeyDiscoveryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, Error>> {
    public DecryptionMaterials _materials = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public KmsEcdhStaticConfigurations _keyAgreementScheme = KmsEcdhStaticConfigurations.Default();
    public IKMSClient _client = null;
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Byte> recipientPublicKey, IKMSClient client, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, KmsEcdhStaticConfigurations keyAgreementScheme, ECDHCurveSpec curveSpec) {
        this._materials = materials;
        this._cryptoPrimitives = cryptoPrimitives;
        this._recipientPublicKey = recipientPublicKey;
        this._keyAgreementScheme = keyAgreementScheme;
        this._client = client;
        this._curveSpec = curveSpec;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<DecryptionMaterials, Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _out5;
        Result<DecryptionMaterials, Error> res = null;
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderId()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received invalid EDK provider id for AWS KMS ECDH Keyring")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AlgorithmSuiteInfo _1_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _2_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _3_providerInfo = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _4_ciphertext = edk.dtor_ciphertext();
        Result<DafnySequence, Error> _5_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _5_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_4_ciphertext, _1_suite);
        if (_5_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _5_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _6_providerWrappedMaterial = _5_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Error> _7_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _7_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_3_providerInfo.length()).compareTo(Helpers.unsignedToBigInteger((int)Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN())) <= 0 && RawECDHKeyring_Compile.__default.ValidProviderInfoLength(_3_providerInfo), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EDK ProviderInfo longer than expected")));
        if (_7_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _7_valueOrError2.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        byte _8_keyringVersion = (Byte)_3_providerInfo.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        Outcome<Error> _9_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _9_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{_8_keyringVersion}).equals(__default.AWS__KMS__ECDH__KEYRING__VERSION()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect Keyring version found in provider info.")));
        if (_9_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _9_valueOrError3.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        BigInteger _10_recipientPublicKeyLength = BigInteger.ZERO;
        _10_recipientPublicKeyLength = Helpers.unsignedToBigInteger((int)StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)_3_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPL__INDEX(), Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX())));
        BigInteger _11_recipientPublicKeyLengthIndex = BigInteger.ZERO;
        _11_recipientPublicKeyLengthIndex = Helpers.unsignedToBigInteger((int)Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()).add(_10_recipientPublicKeyLength);
        BigInteger _12_senderPublicKeyIndex = BigInteger.ZERO;
        _12_senderPublicKeyIndex = _11_recipientPublicKeyLengthIndex.add(Constants_Compile.__default.ECDH__PROVIDER__INFO__PUBLIC__KEY__LEN());
        Outcome<Error> _13_valueOrError4 = Outcome.Default(Error._typeDescriptor());
        _13_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _11_recipientPublicKeyLengthIndex.add(BigInteger.valueOf(4L)).compareTo(BigInteger.valueOf(_3_providerInfo.length())) < 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key Provider Info Serialization Error. Serialized length less than expected.")));
        if (_13_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _13_valueOrError4.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _14_providerInfoRecipientPublicKey = _3_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX(), Helpers.toInt((BigInteger)_11_recipientPublicKeyLengthIndex));
        DafnySequence _15_providerInfoSenderPublicKey = _3_providerInfo.drop(_12_senderPublicKeyIndex);
        Result<DafnySequence, Error> _16_valueOrError5 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out0 = RawECDHKeyring_Compile.__default.DecompressPublicKey((DafnySequence<? extends Byte>)_15_providerInfoSenderPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _16_valueOrError5 = _out0;
        if (_16_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _16_valueOrError5.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _17_senderPublicKey = _16_valueOrError5.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<DafnySequence, Error> _18_valueOrError6 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out1 = RawECDHKeyring_Compile.__default.DecompressPublicKey((DafnySequence<? extends Byte>)_14_providerInfoRecipientPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _18_valueOrError6 = _out1;
        if (_18_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _18_valueOrError6.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _19_recipientPublicKey = _18_valueOrError6.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<Boolean, Error> _20_valueOrError7 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out2 = RawECDHKeyring_Compile.__default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_17_senderPublicKey);
        _20_valueOrError7 = _out2;
        if (_20_valueOrError7.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _20_valueOrError7.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _21___v0 = _20_valueOrError7.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result<Boolean, Error> _22_valueOrError8 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out3 = RawECDHKeyring_Compile.__default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_19_recipientPublicKey);
        _22_valueOrError8 = _out3;
        if (_22_valueOrError8.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _22_valueOrError8.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _23___v1 = _22_valueOrError8.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Outcome<Error> _24_valueOrError9 = Outcome.Default(Error._typeDescriptor());
        _24_valueOrError9 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PublicKeyType((DafnySequence<? extends Byte>)_17_senderPublicKey) && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PublicKeyType(this.recipientPublicKey()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received serialized sender public key of incorrect length")));
        if (_24_valueOrError9.IsFailure(Error._typeDescriptor())) {
            res = _24_valueOrError9.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _25_sharedSecretPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        DafnySequence<? extends Character> _26_sharedSecretKmsKeyId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        KmsEcdhStaticConfigurations _source0 = this.keyAgreementScheme();
        if (_source0.is_KmsPublicKeyDiscovery()) {
            KmsPublicKeyDiscoveryInput _27___mcc_h0;
            KmsPublicKeyDiscoveryInput _28_kmsPublicKeyDiscovery = _27___mcc_h0 = ((KmsEcdhStaticConfigurations_KmsPublicKeyDiscovery)_source0)._KmsPublicKeyDiscovery;
            Result<Tuple0, Error> _29_valueOrError10 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
            _29_valueOrError10 = AwsKmsUtils_Compile.__default.ValidateKmsKeyId(_28_kmsPublicKeyDiscovery.dtor_recipientKmsIdentifier());
            if (_29_valueOrError10.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                res = _29_valueOrError10.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
                return res;
            }
            Tuple0 _30___v2 = _29_valueOrError10.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            _25_sharedSecretPublicKey = _17_senderPublicKey;
            _26_sharedSecretKmsKeyId = _28_kmsPublicKeyDiscovery.dtor_recipientKmsIdentifier();
        } else {
            KmsPrivateKeyToStaticPublicKeyInput _31___mcc_h1;
            KmsPrivateKeyToStaticPublicKeyInput _32_kmsPrivateKeyToStaticPublicKey = _31___mcc_h1 = ((KmsEcdhStaticConfigurations_KmsPrivateKeyToStaticPublicKey)_source0)._KmsPrivateKeyToStaticPublicKey;
            Result<Tuple0, Error> _33_valueOrError11 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
            _33_valueOrError11 = AwsKmsUtils_Compile.__default.ValidateKmsKeyId(_32_kmsPrivateKeyToStaticPublicKey.dtor_senderKmsIdentifier());
            if (_33_valueOrError11.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                res = _33_valueOrError11.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
                return res;
            }
            Tuple0 _34___v3 = _33_valueOrError11.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            _26_sharedSecretKmsKeyId = _32_kmsPrivateKeyToStaticPublicKey.dtor_senderKmsIdentifier();
            _25_sharedSecretPublicKey = _32_kmsPrivateKeyToStaticPublicKey.dtor_recipientPublicKey().equals((Object)_19_recipientPublicKey) ? _19_recipientPublicKey : _17_senderPublicKey;
        }
        Outcome<Error> _35_valueOrError12 = Outcome.Default(Error._typeDescriptor());
        _35_valueOrError12 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PublicKeyType((DafnySequence<? extends Byte>)_25_sharedSecretPublicKey), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received Recipient Public Key of incorrect expected length")));
        if (_35_valueOrError12.IsFailure(Error._typeDescriptor())) {
            res = _35_valueOrError12.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        Result<DafnySequence, Error> _36_valueOrError13 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out4 = __default.DeriveSharedSecret(this.client(), _26_sharedSecretKmsKeyId, (DafnySequence<? extends Byte>)_25_sharedSecretPublicKey, this.grantTokens());
        _36_valueOrError13 = _out4;
        if (_36_valueOrError13.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _36_valueOrError13.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _37_sharedSecret = _36_valueOrError13.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        EcdhUnwrap _nw0 = new EcdhUnwrap();
        _nw0.__ctor((DafnySequence<? extends Byte>)_15_providerInfoSenderPublicKey, (DafnySequence<? extends Byte>)_14_providerInfoRecipientPublicKey, (DafnySequence<? extends Byte>)_37_sharedSecret, __default.AWS__KMS__ECDH__KEYRING__VERSION(), this.curveSpec(), this.cryptoPrimitives());
        EcdhUnwrap _38_ecdhUnwrap = _nw0;
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _39_unwrapOutputRes = _out5 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(EcdhUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _38_ecdhUnwrap);
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _40_valueOrError14 = Result.Default(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), UnwrapEdkMaterialOutput.Default(EcdhUnwrapInfo._typeDescriptor(), EcdhUnwrapInfo.Default()));
        _40_valueOrError14 = _39_unwrapOutputRes;
        if (_40_valueOrError14.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _40_valueOrError14.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<EcdhUnwrapInfo> _41_unwrapOutput = _40_valueOrError14.Extract(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor());
        Result<DecryptionMaterials, Error> _42_valueOrError15 = null;
        _42_valueOrError15 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _41_unwrapOutput.dtor_plaintextDataKey(), _41_unwrapOutput.dtor_symmetricSigningKey());
        if (_42_valueOrError15.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _42_valueOrError15.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _43_result = _42_valueOrError15.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _43_result);
        return res;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public KmsEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public IKMSClient client() {
        return this._client;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsEcdhKeyring.DecryptSingleEncryptedDataKey";
    }
}

