/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.upload_chunk;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.upload_chunk.MLRegisterModelMetaInput;
import org.opensearch.ml.common.transport.upload_chunk.MLRegisterModelMetaRequest;
import org.opensearch.ml.common.transport.upload_chunk.MLRegisterModelMetaResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelGroupManager;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.utils.MLExceptionUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportRegisterModelMetaAction
extends HandledTransportAction<ActionRequest, MLRegisterModelMetaResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportRegisterModelMetaAction.class);
    TransportService transportService;
    ActionFilters actionFilters;
    MLModelManager mlModelManager;
    Client client;
    ModelAccessControlHelper modelAccessControlHelper;
    MLModelGroupManager mlModelGroupManager;

    @Inject
    public TransportRegisterModelMetaAction(TransportService transportService, ActionFilters actionFilters, MLModelManager mlModelManager, Client client, ModelAccessControlHelper modelAccessControlHelper, MLModelGroupManager mlModelGroupManager) {
        super("cluster:admin/opensearch/ml/register_model_meta", transportService, actionFilters, MLRegisterModelMetaRequest::new);
        this.transportService = transportService;
        this.actionFilters = actionFilters;
        this.mlModelManager = mlModelManager;
        this.client = client;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlModelGroupManager = mlModelGroupManager;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterModelMetaResponse> listener) {
        MLRegisterModelMetaRequest registerModelMetaRequest = MLRegisterModelMetaRequest.fromActionRequest((ActionRequest)request);
        MLRegisterModelMetaInput mlUploadInput = registerModelMetaRequest.getMlRegisterModelMetaInput();
        if (StringUtils.isEmpty((CharSequence)mlUploadInput.getModelGroupId())) {
            this.mlModelGroupManager.validateUniqueModelGroupName(mlUploadInput.getName(), null, (ActionListener<SearchResponse>)ActionListener.wrap(modelGroups -> {
                if (modelGroups != null && modelGroups.getHits().getTotalHits() != null && modelGroups.getHits().getTotalHits().value != 0L) {
                    String modelGroupIdOfTheNameProvided = modelGroups.getHits().getAt(0).getId();
                    mlUploadInput.setModelGroupId(modelGroupIdOfTheNameProvided);
                    this.checkUserAccess(mlUploadInput, listener, true);
                } else {
                    this.createModelGroup(mlUploadInput, listener);
                }
            }, e -> {
                log.error("Failed to search model group index", (Throwable)e);
                listener.onFailure(e);
            }));
        } else {
            this.checkUserAccess(mlUploadInput, listener, false);
        }
    }

    private void checkUserAccess(MLRegisterModelMetaInput mlUploadInput, ActionListener<MLRegisterModelMetaResponse> listener, Boolean isModelNameAlreadyExisting) {
        User user = RestActionUtils.getUserContext(this.client);
        this.modelAccessControlHelper.validateModelGroupAccess(user, mlUploadInput.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
            if (access.booleanValue()) {
                this.createModelGroup(mlUploadInput, listener);
                return;
            }
            if (isModelNameAlreadyExisting.booleanValue()) {
                listener.onFailure((Exception)new IllegalArgumentException("The name {" + mlUploadInput.getName() + "} you provided is unavailable because it is used by another model group with id {" + mlUploadInput.getModelGroupId() + "} to which you do not have access. Please provide a different name."));
            } else {
                log.error("You don't have permissions to perform this operation on this model.");
                listener.onFailure((Exception)new IllegalArgumentException("You don't have permissions to perform this operation on this model."));
            }
        }, e -> {
            MLExceptionUtils.logException("Failed to validate model access", e, log);
            listener.onFailure(e);
        }));
    }

    private void createModelGroup(MLRegisterModelMetaInput mlUploadInput, ActionListener<MLRegisterModelMetaResponse> listener) {
        if (StringUtils.isEmpty((CharSequence)mlUploadInput.getModelGroupId())) {
            MLRegisterModelGroupInput mlRegisterModelGroupInput = this.createRegisterModelGroupRequest(mlUploadInput);
            this.mlModelGroupManager.createModelGroup(mlRegisterModelGroupInput, (ActionListener<String>)ActionListener.wrap(modelGroupId -> {
                mlUploadInput.setModelGroupId(modelGroupId);
                mlUploadInput.setDoesVersionCreateModelGroup(Boolean.valueOf(true));
                this.registerModelMeta(mlUploadInput, listener);
            }, e -> {
                MLExceptionUtils.logException("Failed to create Model Group", e, log);
                listener.onFailure(e);
            }));
        } else {
            mlUploadInput.setDoesVersionCreateModelGroup(Boolean.valueOf(false));
            this.registerModelMeta(mlUploadInput, listener);
        }
    }

    private MLRegisterModelGroupInput createRegisterModelGroupRequest(MLRegisterModelMetaInput mlUploadInput) {
        return MLRegisterModelGroupInput.builder().name(mlUploadInput.getName()).description(mlUploadInput.getDescription()).backendRoles(mlUploadInput.getBackendRoles()).modelAccessMode(mlUploadInput.getAccessMode()).isAddAllBackendRoles(mlUploadInput.getIsAddAllBackendRoles()).build();
    }

    private void registerModelMeta(MLRegisterModelMetaInput mlUploadInput, ActionListener<MLRegisterModelMetaResponse> listener) {
        this.mlModelManager.registerModelMeta(mlUploadInput, (ActionListener<String>)ActionListener.wrap(modelId -> listener.onResponse((Object)new MLRegisterModelMetaResponse(modelId, MLTaskState.CREATED.name())), ex -> {
            log.error("Failed to init model index", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }
}

