/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NoMergePolicy;
import org.opensearch.common.settings.Setting;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.MergePolicyProvider;
import org.opensearch.index.TieredMergePolicyProvider;

public class LogByteSizeMergePolicyProvider
implements MergePolicyProvider {
    private final LogByteSizeMergePolicy logByteSizeMergePolicy = new LogByteSizeMergePolicy();
    private final Logger logger;
    private final boolean mergesEnabled;
    public static final ByteSizeValue DEFAULT_MIN_MERGE = new ByteSizeValue(2L, ByteSizeUnit.MB);
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final ByteSizeValue DEFAULT_MAX_MERGED_SEGMENT = new ByteSizeValue(5L, ByteSizeUnit.GB);
    public static final ByteSizeValue DEFAULT_MAX_MERGE_SEGMENT_FORCE_MERGE = new ByteSizeValue(Long.MAX_VALUE);
    public static final Setting<Integer> INDEX_LBS_MERGE_POLICY_MERGE_FACTOR_SETTING = Setting.intSetting("index.merge.log_byte_size_policy.merge_factor", 10, 2, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_LBS_MERGE_POLICY_MIN_MERGE_SETTING = Setting.byteSizeSetting("index.merge.log_byte_size_policy.min_merge", DEFAULT_MIN_MERGE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_LBS_MAX_MERGE_SEGMENT_SETTING = Setting.byteSizeSetting("index.merge.log_byte_size_policy.max_merge_segment", DEFAULT_MAX_MERGED_SEGMENT, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_LBS_MAX_MERGE_SEGMENT_FOR_FORCED_MERGE_SETTING = Setting.byteSizeSetting("index.merge.log_byte_size_policy.max_merge_segment_forced_merge", DEFAULT_MAX_MERGE_SEGMENT_FORCE_MERGE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_LBS_MAX_MERGED_DOCS_SETTING = Setting.intSetting("index.merge.log_byte_size_policy.max_merged_docs", Integer.MAX_VALUE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_LBS_NO_CFS_RATIO_SETTING = new Setting<Double>("index.merge.log_byte_size_policy.no_cfs_ratio", Double.toString(0.1), TieredMergePolicyProvider::parseNoCFSRatio, Setting.Property.Dynamic, Setting.Property.IndexScope);

    LogByteSizeMergePolicyProvider(Logger logger, IndexSettings indexSettings) {
        this.logger = logger;
        this.mergesEnabled = indexSettings.getSettings().getAsBoolean("index.merge.enabled", true);
        this.logByteSizeMergePolicy.setMergeFactor(indexSettings.getValue(INDEX_LBS_MERGE_POLICY_MERGE_FACTOR_SETTING).intValue());
        this.logByteSizeMergePolicy.setMinMergeMB(indexSettings.getValue(INDEX_LBS_MERGE_POLICY_MIN_MERGE_SETTING).getMbFrac());
        this.logByteSizeMergePolicy.setMaxMergeMB(indexSettings.getValue(INDEX_LBS_MAX_MERGE_SEGMENT_SETTING).getMbFrac());
        this.logByteSizeMergePolicy.setMaxMergeMBForForcedMerge(indexSettings.getValue(INDEX_LBS_MAX_MERGE_SEGMENT_FOR_FORCED_MERGE_SETTING).getMbFrac());
        this.logByteSizeMergePolicy.setMaxMergeDocs(indexSettings.getValue(INDEX_LBS_MAX_MERGED_DOCS_SETTING).intValue());
        this.logByteSizeMergePolicy.setNoCFSRatio(indexSettings.getValue(INDEX_LBS_NO_CFS_RATIO_SETTING).doubleValue());
    }

    @Override
    public MergePolicy getMergePolicy() {
        return this.mergesEnabled ? this.logByteSizeMergePolicy : NoMergePolicy.INSTANCE;
    }

    void setLBSMergeFactor(int mergeFactor) {
        this.logByteSizeMergePolicy.setMergeFactor(mergeFactor);
    }

    void setLBSMaxMergeSegment(ByteSizeValue maxMergeSegment) {
        this.logByteSizeMergePolicy.setMaxMergeMB(maxMergeSegment.getMbFrac());
    }

    void setLBSMinMergedMB(ByteSizeValue minMergedSize) {
        this.logByteSizeMergePolicy.setMinMergeMB(minMergedSize.getMbFrac());
    }

    void setLBSMaxMergeMBForForcedMerge(ByteSizeValue maxMergeForcedMerge) {
        this.logByteSizeMergePolicy.setMaxMergeMBForForcedMerge(maxMergeForcedMerge.getMbFrac());
    }

    void setLBSMaxMergeDocs(int maxMergeDocs) {
        this.logByteSizeMergePolicy.setMaxMergeDocs(maxMergeDocs);
    }

    void setLBSNoCFSRatio(Double noCFSRatio) {
        this.logByteSizeMergePolicy.setNoCFSRatio(noCFSRatio.doubleValue());
    }

    public String toString() {
        return "LogByteSizeMergePolicyProvider{mergeFactor=" + this.logByteSizeMergePolicy.getMergeFactor() + ", minMergeMB=" + this.logByteSizeMergePolicy.getMinMergeMB() + ", maxMergeMB=" + this.logByteSizeMergePolicy.getMaxMergeMB() + ", maxMergeMBForForcedMerge=" + this.logByteSizeMergePolicy.getMaxMergeMBForForcedMerge() + ", maxMergedDocs=" + this.logByteSizeMergePolicy.getMaxMergeDocs() + ", noCFSRatio=" + this.logByteSizeMergePolicy.getNoCFSRatio() + "}";
    }
}

