/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.search.query.BitmapIndexQuery;
import org.roaringbitmap.RoaringBitmap;

public class BitmapDocValuesQuery
extends Query
implements Accountable {
    final String field;
    final RoaringBitmap bitmap;
    final long min;
    final long max;

    public BitmapDocValuesQuery(String field, RoaringBitmap bitmap) {
        BitmapIndexQuery.checkArgs(field, bitmap);
        this.field = field;
        this.bitmap = bitmap;
        if (!bitmap.isEmpty()) {
            this.min = bitmap.first();
            this.max = bitmap.last();
        } else {
            this.min = 0L;
            this.max = 0L;
        }
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)BitmapDocValuesQuery.this.field);
                final NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator((DocIdSetIterator)singleton){

                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return value >= BitmapDocValuesQuery.this.min && value <= BitmapDocValuesQuery.this.max && BitmapDocValuesQuery.this.bitmap.contains((int)value);
                    }

                    public float matchCost() {
                        return 5.0f;
                    }
                } : new TwoPhaseIterator((DocIdSetIterator)values){

                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            if (value < BitmapDocValuesQuery.this.min) continue;
                            if (value > BitmapDocValuesQuery.this.max) {
                                return false;
                            }
                            if (!BitmapDocValuesQuery.this.bitmap.contains((int)value)) continue;
                            return true;
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 5.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{BitmapDocValuesQuery.this.field});
            }
        };
    }

    public String toString(String field) {
        return "BitmapDocValuesQuery(field=" + this.field + ")";
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.bitmap.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        BitmapDocValuesQuery that = (BitmapDocValuesQuery)((Object)other);
        return this.field.equals(that.field) && this.bitmap.equals((Object)that.bitmap);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.bitmap);
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.shallowSizeOfInstance(BitmapIndexQuery.class) + RamUsageEstimator.sizeOf((String)this.field) + this.bitmap.getLongSizeInBytes();
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }
}

