"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOrderedJson = exports.filterByMinimatch = void 0;
var _minimatch = _interopRequireDefault(require("minimatch"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
// minimatch is a peer dependency of glob

const filterByMinimatch = (input, rules) => {
  return rules.some(item => (0, _minimatch.default)(input, item, {
    dot: true
  }));
};
exports.filterByMinimatch = filterByMinimatch;
const getOrderedJson = json => {
  const entries = Object.entries(json);
  entries.sort((a, b) => a[0] < b[0] ? -1 : 1);
  return entries.reduce((total, [key, value]) => ({
    ...total,
    [key]: value
  }), {});
};
exports.getOrderedJson = getOrderedJson;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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