"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _lodash = _interopRequireDefault(require("lodash"));
var _helpers = require("../../common/helpers");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

let metricsCounter = _lodash.default.cloneDeep(_constants.DEFAULT_METRICS_COUNTER);
class MetricsService {
  async getMetrics(_context, _request, response) {
    const metricsSnapshot = {
      ...metricsCounter
    };
    metricsCounter = _lodash.default.cloneDeep(_constants.DEFAULT_METRICS_COUNTER);
    return response.custom({
      statusCode: 200,
      body: {
        ok: true,
        response: metricsSnapshot
      }
    });
  }
  async updateMetrics(_context, request, response) {
    const metrics = request.body;
    metricsCounter = (0, _helpers.aggregateMetrics)(metrics, metricsCounter);
    return response.ok({
      body: metricsCounter
    });
  }
}
exports.default = MetricsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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