"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUGIN_PROPERTY_NAME = exports.METHOD_NAMES = exports.DEFAULT_METRICS_COUNTER = exports.CLUSTER = exports.CLIENT_THREAT_INTEL_METHODS = exports.CLIENT_RULE_METHODS = exports.CLIENT_NOTIFICATIONS_METHODS = exports.CLIENT_LOGTYPE_METHODS = exports.CLIENT_FIELD_MAPPINGS_METHODS = exports.CLIENT_DETECTOR_METHODS = exports.CLIENT_CORRELATION_METHODS = exports.CLIENT_ALERTS_METHODS = exports.BASE_API_PATH = exports.API = void 0;
var _types = require("../../types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let CLUSTER = exports.CLUSTER = /*#__PURE__*/function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["SA"] = "opensearch_security_analytics";
  CLUSTER["DATA"] = "data";
  return CLUSTER;
}({});
const BASE_API_PATH = exports.BASE_API_PATH = '/_plugins/_security_analytics';
const API = exports.API = {
  DETECTORS_BASE: `${BASE_API_PATH}/detectors`,
  CORRELATION_BASE: `${BASE_API_PATH}/correlation/rules`,
  SEARCH_DETECTORS: `${BASE_API_PATH}/detectors/_search`,
  INDICES_BASE: `${BASE_API_PATH}/indices`,
  ALIASES_BASE: `${BASE_API_PATH}/aliases`,
  FINDINGS_BASE: `${BASE_API_PATH}/findings`,
  GET_FINDINGS: `${BASE_API_PATH}/findings/_search`,
  DOCUMENT_IDS_QUERY: `${BASE_API_PATH}/document_ids_query`,
  TIME_RANGE_QUERY: `${BASE_API_PATH}/time_range_query`,
  MAPPINGS_BASE: `${BASE_API_PATH}/mappings`,
  MAPPINGS_VIEW: `${BASE_API_PATH}/mappings/view`,
  GET_ALERTS: `${BASE_API_PATH}/alerts`,
  RULES_BASE: `${BASE_API_PATH}/rules`,
  CHANNELS: `${BASE_API_PATH}/_notifications/channels`,
  PLUGINS: `${BASE_API_PATH}/_notifications/plugins`,
  NOTIFICATION_FEATURES: `${BASE_API_PATH}/_notifications/features`,
  ACKNOWLEDGE_ALERTS: `${BASE_API_PATH}/detectors/{detector_id}/_acknowledge/alerts`,
  UPDATE_ALIASES: `${BASE_API_PATH}/update_aliases`,
  CORRELATIONS: `${BASE_API_PATH}/correlations`,
  LOGTYPE_BASE: `${BASE_API_PATH}/logtype`,
  METRICS: `/api/security_analytics/stats`,
  GET_CORRELATION_ALERTS: `${BASE_API_PATH}/correlationAlerts`,
  ACK_CORRELATION_ALERTS: `${BASE_API_PATH}/_acknowledge/correlationAlerts`,
  THREAT_INTEL_BASE: `${BASE_API_PATH}/threat_intel`
};

/**
 * Property with below name is added to the prototype of Opensearch client during setup.
 * @see ../clusters/securityAnalytics/securityAnalyticsPlugin
 */
const PLUGIN_PROPERTY_NAME = exports.PLUGIN_PROPERTY_NAME = 'securityAnalytics';
const METHOD_NAMES = exports.METHOD_NAMES = {
  //Rule methods
  CREATE_RULE: 'createRule',
  DELETE_RULE: 'deleteRule',
  GET_RULE: 'getRule',
  GET_RULES: 'getRules',
  UPDATE_RULE: 'updateRules',
  // Detector methods
  CREATE_DETECTOR: 'createDetector',
  DELETE_DETECTOR: 'deleteDetector',
  GET_DETECTOR: 'getDetector',
  SEARCH_DETECTORS: 'searchDetectors',
  UPDATE_DETECTOR: 'updateDetector',
  // Correlation methods
  GET_CORRELATION_RULES: 'getCorrelationRules',
  CREATE_CORRELATION_RULE: 'createCorrelationRule',
  UPDATE_CORRELATION_RULE: 'updateCorrelationRule',
  DELETE_CORRELATION_RULE: 'deleteCorrelationRule',
  GET_CORRELATED_FINDINGS: 'getCorrelatedFindings',
  GET_ALL_CORRELATIONS: 'getAllCorrelations',
  GET_CORRELATION_ALERTS: 'getAllCorrelationAlerts',
  ACK_CORRELATION_ALERTS: 'acknowledgeCorrelationAlerts',
  // Finding methods
  GET_FINDINGS: 'getFindings',
  // Field mapping methods
  GET_MAPPINGS_VIEW: 'getFieldMappingsView',
  CREATE_MAPPINGS: 'createMappings',
  GET_MAPPINGS: 'getMappings',
  GET_INDEX_ALIAS_MAPPINGS: 'getIndexAliasMappings',
  // Alerts methods
  GET_ALERTS: 'getAlerts',
  ACKNOWLEDGE_ALERTS: 'acknowledgeAlerts',
  // Notifications methods
  GET_CHANNEl: 'getChannel',
  GET_CHANNElS: 'getChannels',
  GET_FEATURES: 'getFeatures',
  // LogType methods
  SEARCH_LOGTYPES: 'searchLogTypes',
  CREATE_LOGTYPE: 'createLogType',
  UPDATE_LOGTYPE: 'updateLogType',
  DELETE_LOGTYPE: 'deleteLogType',
  // Threat intel methods
  ADD_THREAT_INTEL_SOURCE: 'addThreatIntelSource',
  UPDATE_THREAT_INTEL_SOURCE: 'updateThreatIntelSource',
  SEARCH_THREAT_INTEL_SOURCES: 'searchThreatIntelSources',
  GET_THREAT_INTEL_SOURCE: 'getThreatIntelSource',
  DELETE_THREAT_INTEL_SOURCE: 'deleteThreatIntelSource',
  REFRESH_THREAT_INTEL_SOURCE: 'refreshThreatIntelSource',
  GET_THREAT_INTEL_IOCS: 'getThreatIntelIoCs',
  CREATE_THREAT_INTEL_MONITOR: 'createThreatIntelMonitor',
  UPDATE_THREAT_INTEL_MONITOR: 'updateThreatIntelMonitor',
  SEARCH_THREAT_INTEL_MONITORS: 'searchThreatIntelMonitors',
  DELETE_THREAT_INTEL_MONITOR: 'deleteThreatIntelMonitor',
  GET_THREAT_INTEL_FINDINGS: 'getThreatIntelFindings',
  GET_THREAT_INTEL_ALERTS: 'getThreatIntelAlerts',
  UPDATE_THREAT_INTEL_ALERTS_STATE: 'updateThreatIntelAlertsStatus'
};

/**
 * These methods are defined on the Opensearch client instance by adding them to the client's
 * prototype under the @see PLUGIN_PROPERTY_NAME field.
 * @see ../clusters/securityAnalytics/securityAnalyticsPlugin
 */
const CLIENT_RULE_METHODS = exports.CLIENT_RULE_METHODS = {
  CREATE_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_RULE}`,
  DELETE_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_RULE}`,
  GET_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_RULE}`,
  GET_RULES: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_RULES}`,
  UPDATE_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_RULE}`
};
const CLIENT_DETECTOR_METHODS = exports.CLIENT_DETECTOR_METHODS = {
  CREATE_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_DETECTOR}`,
  DELETE_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_DETECTOR}`,
  GET_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_DETECTOR}`,
  SEARCH_DETECTORS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.SEARCH_DETECTORS}`,
  UPDATE_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_DETECTOR}`,
  GET_FINDINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_FINDINGS}`
};
const CLIENT_CORRELATION_METHODS = exports.CLIENT_CORRELATION_METHODS = {
  GET_CORRELATION_RULES: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CORRELATION_RULES}`,
  CREATE_CORRELATION_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_CORRELATION_RULE}`,
  UPDATE_CORRELATION_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_CORRELATION_RULE}`,
  DELETE_CORRELATION_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_CORRELATION_RULE}`,
  GET_CORRELATED_FINDINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CORRELATED_FINDINGS}`,
  GET_ALL_CORRELATIONS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_ALL_CORRELATIONS}`,
  GET_CORRELATION_ALERTS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CORRELATION_ALERTS}`,
  ACK_CORRELATION_ALERTS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.ACK_CORRELATION_ALERTS}`
};
const CLIENT_FIELD_MAPPINGS_METHODS = exports.CLIENT_FIELD_MAPPINGS_METHODS = {
  GET_MAPPINGS_VIEW: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_MAPPINGS_VIEW}`,
  CREATE_MAPPINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_MAPPINGS}`,
  GET_MAPPINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_MAPPINGS}`,
  GET_INDEX_ALIAS_MAPPINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_INDEX_ALIAS_MAPPINGS}`
};
const CLIENT_ALERTS_METHODS = exports.CLIENT_ALERTS_METHODS = {
  ACKNOWLEDGE_ALERTS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.ACKNOWLEDGE_ALERTS}`,
  GET_ALERTS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_ALERTS}`
};
const CLIENT_NOTIFICATIONS_METHODS = exports.CLIENT_NOTIFICATIONS_METHODS = {
  GET_CHANNEL: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CHANNEl}`,
  GET_CHANNELS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CHANNElS}`,
  GET_FEATURES: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_FEATURES}`
};
const CLIENT_LOGTYPE_METHODS = exports.CLIENT_LOGTYPE_METHODS = {
  SEARCH_LOGTYPES: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.SEARCH_LOGTYPES}`,
  CREATE_LOGTYPE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_LOGTYPE}`,
  UPDATE_LOGTYPE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_LOGTYPE}`,
  DELETE_LOGTYPE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_LOGTYPE}`
};
const CLIENT_THREAT_INTEL_METHODS = exports.CLIENT_THREAT_INTEL_METHODS = {
  ADD_THREAT_INTEL_SOURCE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.ADD_THREAT_INTEL_SOURCE}`,
  UPDATE_THREAT_INTEL_SOURCE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_THREAT_INTEL_SOURCE}`,
  SEARCH_THREAT_INTEL_SOURCES: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.SEARCH_THREAT_INTEL_SOURCES}`,
  GET_THREAT_INTEL_SOURCE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_THREAT_INTEL_SOURCE}`,
  DELETE_THREAT_INTEL_SOURCE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_THREAT_INTEL_SOURCE}`,
  REFRESH_THREAT_INTEL_SOURCE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.REFRESH_THREAT_INTEL_SOURCE}`,
  GET_THREAT_INTEL_IOCS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_THREAT_INTEL_IOCS}`,
  CREATE_THREAT_INTEL_MONITOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_THREAT_INTEL_MONITOR}`,
  UPDATE_THREAT_INTEL_MONITOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_THREAT_INTEL_MONITOR}`,
  SEARCH_THREAT_INTEL_MONITORS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.SEARCH_THREAT_INTEL_MONITORS}`,
  DELETE_THREAT_INTEL_MONITOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_THREAT_INTEL_MONITOR}`,
  GET_THREAT_INTEL_FINDINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_THREAT_INTEL_FINDINGS}`,
  GET_THREAT_INTEL_ALERTS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_THREAT_INTEL_ALERTS}`,
  UPDATE_THREAT_INTEL_ALERTS_STATE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_THREAT_INTEL_ALERTS_STATE}`
};
const DEFAULT_METRICS_COUNTER = exports.DEFAULT_METRICS_COUNTER = {
  CreateDetector: {
    [_types.CreateDetectorSteps.started]: 0,
    [_types.CreateDetectorSteps.sourceSelected]: 0,
    [_types.CreateDetectorSteps.rulesConfigured]: 0,
    [_types.CreateDetectorSteps.fieldMappingsConfigured]: 0,
    [_types.CreateDetectorSteps.threatIntelConfigured]: 0,
    [_types.CreateDetectorSteps.stepTwoInitiated]: 0,
    [_types.CreateDetectorSteps.triggerConfigured]: 0,
    [_types.CreateDetectorSteps.createClicked]: 0
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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