"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeACLAuditor = exports.getACLAuditor = exports.cleanUpACLAuditor = exports.ACLAuditorStateKey = void 0;
var _router = require("../http/router");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const ACLAuditorKey = Symbol('ACLAuditor');
const ACLAuditorStateKey = exports.ACLAuditorStateKey = {
  VALIDATE_SUCCESS: 'validateSuccess',
  VALIDATE_FAILURE: 'validateFailure',
  DATABASE_OPERATION: 'databaseOperation'
};
const defaultState = {
  [ACLAuditorStateKey.VALIDATE_SUCCESS]: 0,
  [ACLAuditorStateKey.VALIDATE_FAILURE]: 0,
  [ACLAuditorStateKey.DATABASE_OPERATION]: 0
};
class ACLAuditor {
  constructor(logger) {
    this.logger = logger;
    _defineProperty(this, "state", {
      ...defaultState
    });
    _defineProperty(this, "reset", () => {
      this.state = {
        ...defaultState
      };
    });
    _defineProperty(this, "increment", (key, count) => {
      if (typeof count !== 'number' || !this.state.hasOwnProperty(key)) {
        return;
      }
      this.state[key] = this.state[key] + count;
    });
    _defineProperty(this, "checkout", requestInfo => {
      /**
       * VALIDATE_FAILURE represents the count for unauthorized call to a specific objects
       * VALIDATE_SUCCESS represents the count for authorized call to a specific objects
       * DATABASE_OPERATION represents the count for operations call to the database.
       *
       * Normally the operations call to the database should always <= the AuthZ check(VALIDATE_FAILURE + VALIDATE_SUCCESS)
       * If DATABASE_OPERATION > AuthZ check, it means we have somewhere bypasses the AuthZ check and we should audit this bypass behavior.
       */
      if (this.state[ACLAuditorStateKey.VALIDATE_FAILURE] + this.state[ACLAuditorStateKey.VALIDATE_SUCCESS] < this.state[ACLAuditorStateKey.DATABASE_OPERATION]) {
        this.logger.error(`[ACLCounterCheckoutFailed] counter state: ${JSON.stringify(this.state)}, ${requestInfo ? `requestInfo: ${requestInfo}` : ''}`);
      }
      this.reset();
    });
    _defineProperty(this, "getState", () => this.state);
  }
}
/**
 * This function will be used to initialize a new app state to the request
 *
 * @param request OpenSearchDashboardsRequest
 * @returns void
 */
const initializeACLAuditor = (request, logger) => {
  const rawRequest = (0, _router.ensureRawRequest)(request);
  const appState = rawRequest.app;
  const ACLCounterInstance = appState[ACLAuditorKey];
  if (ACLCounterInstance) {
    return;
  }
  appState[ACLAuditorKey] = new ACLAuditor(logger);
};
exports.initializeACLAuditor = initializeACLAuditor;
const getACLAuditor = request => {
  return (0, _router.ensureRawRequest)(request).app[ACLAuditorKey];
};
exports.getACLAuditor = getACLAuditor;
const cleanUpACLAuditor = request => {
  (0, _router.ensureRawRequest)(request).app[ACLAuditorKey] = undefined;
};
exports.cleanUpACLAuditor = cleanUpACLAuditor;