/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.samplers;

import io.jaegertracing.internal.samplers.GuaranteedThroughputSampler;
import io.jaegertracing.internal.samplers.ProbabilisticSampler;
import io.jaegertracing.internal.samplers.SamplingStatus;
import io.jaegertracing.internal.samplers.http.OperationSamplingParameters;
import io.jaegertracing.internal.samplers.http.PerOperationSamplingParameters;
import io.jaegertracing.spi.Sampler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerOperationSampler
implements Sampler {
    private static final Logger log = LoggerFactory.getLogger(PerOperationSampler.class);
    private final int maxOperations;
    private Map<String, GuaranteedThroughputSampler> operationNameToSampler;
    private ProbabilisticSampler defaultSampler;
    private double lowerBound;

    public PerOperationSampler(int maxOperations, OperationSamplingParameters strategies) {
        this(maxOperations, new HashMap<String, GuaranteedThroughputSampler>(), new ProbabilisticSampler(strategies.getDefaultSamplingProbability()), strategies.getDefaultLowerBoundTracesPerSecond());
        this.update(strategies);
    }

    public synchronized boolean update(OperationSamplingParameters strategies) {
        boolean isUpdated = false;
        this.lowerBound = strategies.getDefaultLowerBoundTracesPerSecond();
        ProbabilisticSampler defaultSampler = new ProbabilisticSampler(strategies.getDefaultSamplingProbability());
        if (!defaultSampler.equals(this.defaultSampler)) {
            this.defaultSampler = defaultSampler;
            isUpdated = true;
        }
        HashMap<String, GuaranteedThroughputSampler> newOpsSamplers = new HashMap<String, GuaranteedThroughputSampler>();
        for (PerOperationSamplingParameters strategy : strategies.getPerOperationStrategies()) {
            String operation = strategy.getOperation();
            double samplingRate = strategy.getProbabilisticSampling().getSamplingRate();
            GuaranteedThroughputSampler sampler = this.operationNameToSampler.get(operation);
            if (sampler != null) {
                isUpdated = sampler.update(samplingRate, this.lowerBound) || isUpdated;
                newOpsSamplers.put(operation, sampler);
                continue;
            }
            if (newOpsSamplers.size() < this.maxOperations) {
                sampler = new GuaranteedThroughputSampler(samplingRate, this.lowerBound);
                newOpsSamplers.put(operation, sampler);
                isUpdated = true;
                continue;
            }
            log.info("Exceeded the maximum number of operations({}) for per operations sampling", (Object)this.maxOperations);
        }
        this.operationNameToSampler = newOpsSamplers;
        return isUpdated;
    }

    @Override
    public synchronized SamplingStatus sample(String operation, long id) {
        GuaranteedThroughputSampler sampler = this.operationNameToSampler.get(operation);
        if (sampler != null) {
            return sampler.sample(operation, id);
        }
        if (this.operationNameToSampler.size() < this.maxOperations) {
            sampler = new GuaranteedThroughputSampler(this.defaultSampler.getSamplingRate(), this.lowerBound);
            this.operationNameToSampler.put(operation, sampler);
            return sampler.sample(operation, id);
        }
        return this.defaultSampler.sample(operation, id);
    }

    @Override
    public synchronized void close() {
        this.defaultSampler.close();
        for (GuaranteedThroughputSampler sampler : this.operationNameToSampler.values()) {
            sampler.close();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerOperationSampler)) {
            return false;
        }
        PerOperationSampler other = (PerOperationSampler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxOperations() != other.getMaxOperations()) {
            return false;
        }
        if (Double.compare(this.getLowerBound(), other.getLowerBound()) != 0) {
            return false;
        }
        Map<String, GuaranteedThroughputSampler> this$operationNameToSampler = this.getOperationNameToSampler();
        Map<String, GuaranteedThroughputSampler> other$operationNameToSampler = other.getOperationNameToSampler();
        if (this$operationNameToSampler == null ? other$operationNameToSampler != null : !((Object)this$operationNameToSampler).equals(other$operationNameToSampler)) {
            return false;
        }
        ProbabilisticSampler this$defaultSampler = this.getDefaultSampler();
        ProbabilisticSampler other$defaultSampler = other.getDefaultSampler();
        return !(this$defaultSampler == null ? other$defaultSampler != null : !((Object)this$defaultSampler).equals(other$defaultSampler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PerOperationSampler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxOperations();
        long $lowerBound = Double.doubleToLongBits(this.getLowerBound());
        result = result * 59 + (int)($lowerBound >>> 32 ^ $lowerBound);
        Map<String, GuaranteedThroughputSampler> $operationNameToSampler = this.getOperationNameToSampler();
        result = result * 59 + ($operationNameToSampler == null ? 43 : ((Object)$operationNameToSampler).hashCode());
        ProbabilisticSampler $defaultSampler = this.getDefaultSampler();
        result = result * 59 + ($defaultSampler == null ? 43 : $defaultSampler.hashCode());
        return result;
    }

    public String toString() {
        return "PerOperationSampler(maxOperations=" + this.getMaxOperations() + ", operationNameToSampler=" + this.getOperationNameToSampler() + ", defaultSampler=" + this.getDefaultSampler() + ", lowerBound=" + this.getLowerBound() + ")";
    }

    PerOperationSampler(int maxOperations, Map<String, GuaranteedThroughputSampler> operationNameToSampler, ProbabilisticSampler defaultSampler, double lowerBound) {
        this.maxOperations = maxOperations;
        this.operationNameToSampler = operationNameToSampler;
        this.defaultSampler = defaultSampler;
        this.lowerBound = lowerBound;
    }

    int getMaxOperations() {
        return this.maxOperations;
    }

    Map<String, GuaranteedThroughputSampler> getOperationNameToSampler() {
        return this.operationNameToSampler;
    }

    ProbabilisticSampler getDefaultSampler() {
        return this.defaultSampler;
    }

    double getLowerBound() {
        return this.lowerBound;
    }
}

