/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.configsets;

import java.io.InputStream;
import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.configsets.ConfigSetAPIBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.FileTypeMagicUtil;

public class UploadConfigSetFileAPI
extends ConfigSetAPIBase {
    public static final String CONFIGSET_NAME_PLACEHOLDER = "name";
    public static final String FILEPATH_PLACEHOLDER = "*";
    private static final String API_PATH = "/cluster/configs/{name}/*";

    public UploadConfigSetFileAPI(CoreContainer coreContainer) {
        super(coreContainer);
    }

    @EndPoint(method={SolrRequest.METHOD.PUT}, path={"/cluster/configs/{name}/*"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void updateConfigSetFile(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        this.ensureConfigSetUploadEnabled();
        String configSetName = req.getPathTemplateValues().get(CONFIGSET_NAME_PLACEHOLDER);
        boolean overwritesExisting = this.configSetService.checkConfigExists(configSetName);
        boolean requestIsTrusted = UploadConfigSetFileAPI.isTrusted(req.getUserPrincipal(), this.coreContainer.getAuthenticationPlugin());
        String singleFilePath = req.getPathTemplateValues().getOrDefault(FILEPATH_PLACEHOLDER, "");
        boolean allowOverwrite = req.getParams().getBool("overwrite", true);
        boolean cleanup = req.getParams().getBool("cleanup", false);
        InputStream inputStream = this.ensureNonEmptyInputStream(req);
        String fixedSingleFilePath = singleFilePath;
        if (fixedSingleFilePath.charAt(0) == '/') {
            fixedSingleFilePath = fixedSingleFilePath.substring(1);
        }
        byte[] data = inputStream.readAllBytes();
        if (fixedSingleFilePath.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The file path provided for upload, '" + singleFilePath + "', is not valid.");
        }
        if (ZkMaintenanceUtils.isFileForbiddenInConfigSets((String)fixedSingleFilePath) || FileTypeMagicUtil.isFileForbiddenInConfigset(data)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The file type provided for upload, '" + singleFilePath + "', is forbidden for use in configSets.");
        }
        if (cleanup) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet uploads do not allow cleanup=true when file path is used.");
        }
        this.createBaseNode(this.configSetService, overwritesExisting, requestIsTrusted, configSetName);
        this.configSetService.uploadFileToConfig(configSetName, fixedSingleFilePath, data, allowOverwrite);
    }
}

