/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.xml.CoreParser;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.queryparser.xml.builders.SpanQueryBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.LegacyNumericRangeQueryBuilder;
import org.apache.solr.search.SolrQueryBuilder;
import org.apache.solr.search.SolrSpanQueryBuilder;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;

public class SolrCoreParser
extends CoreParser
implements NamedListInitializedPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    protected final SolrQueryRequest req;

    public SolrCoreParser(String defaultField, Analyzer analyzer, SolrQueryRequest req) {
        super(defaultField, analyzer);
        this.queryFactory.addBuilder("LegacyNumericRangeQuery", (QueryBuilder)new LegacyNumericRangeQueryBuilder());
        this.req = req;
        if (null == req) {
            throw new NullPointerException("req must not be null");
        }
    }

    @Override
    public void init(NamedList<?> initArgs) {
        if (initArgs == null || initArgs.size() == 0) {
            return;
        }
        SolrResourceLoader loader = this.req.getCore().getResourceLoader();
        for (Map.Entry entry : initArgs) {
            String queryName = (String)entry.getKey();
            String queryBuilderClassName = (String)entry.getValue();
            try {
                SolrSpanQueryBuilder spanQueryBuilder = loader.newInstance(queryBuilderClassName, SolrSpanQueryBuilder.class, null, new Class[]{String.class, Analyzer.class, SolrQueryRequest.class, SpanQueryBuilder.class}, new Object[]{this.defaultField, this.analyzer, this.req, this});
                this.addSpanQueryBuilder(queryName, spanQueryBuilder);
            }
            catch (Exception outerException) {
                try {
                    SolrQueryBuilder queryBuilder = loader.newInstance(queryBuilderClassName, SolrQueryBuilder.class, null, new Class[]{String.class, Analyzer.class, SolrQueryRequest.class, QueryBuilder.class}, new Object[]{this.defaultField, this.analyzer, this.req, this});
                    this.addQueryBuilder(queryName, queryBuilder);
                }
                catch (Exception innerException) {
                    log.error("Class {} not found or not suitable: {} {}", new Object[]{queryBuilderClassName, outerException, innerException});
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot find suitable " + SolrSpanQueryBuilder.class.getCanonicalName() + " or " + SolrQueryBuilder.class.getCanonicalName() + " class: " + queryBuilderClassName + " in " + loader);
                }
            }
        }
    }

    protected ErrorHandler getErrorHandler() {
        return xmllog;
    }
}

