/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class GetLabelsToNodesResponsePBImpl
extends GetLabelsToNodesResponse {
    YarnServiceProtos.GetLabelsToNodesResponseProto proto = YarnServiceProtos.GetLabelsToNodesResponseProto.getDefaultInstance();
    YarnServiceProtos.GetLabelsToNodesResponseProto.Builder builder = null;
    boolean viaProto = false;
    private Map<String, Set<NodeId>> labelsToNodes;

    public GetLabelsToNodesResponsePBImpl() {
        this.builder = YarnServiceProtos.GetLabelsToNodesResponseProto.newBuilder();
    }

    public GetLabelsToNodesResponsePBImpl(YarnServiceProtos.GetLabelsToNodesResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private void initLabelsToNodes() {
        if (this.labelsToNodes != null) {
            return;
        }
        YarnServiceProtos.GetLabelsToNodesResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.LabelsToNodeIdsProto> list = p.getLabelsToNodesList();
        this.labelsToNodes = new HashMap<String, Set<NodeId>>();
        for (YarnProtos.LabelsToNodeIdsProto c : list) {
            HashSet<NodeIdPBImpl> setNodes = new HashSet<NodeIdPBImpl>();
            for (YarnProtos.NodeIdProto n : c.getNodeIdList()) {
                NodeIdPBImpl node = new NodeIdPBImpl(n);
                setNodes.add(node);
            }
            if (setNodes.isEmpty()) continue;
            this.labelsToNodes.put(c.getNodeLabels(), setNodes);
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetLabelsToNodesResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addLabelsToNodesToProto() {
        this.maybeInitBuilder();
        this.builder.clearLabelsToNodes();
        if (this.labelsToNodes == null) {
            return;
        }
        Iterable<YarnProtos.LabelsToNodeIdsProto> iterable = new Iterable<YarnProtos.LabelsToNodeIdsProto>(){

            @Override
            public Iterator<YarnProtos.LabelsToNodeIdsProto> iterator() {
                return new Iterator<YarnProtos.LabelsToNodeIdsProto>(){
                    Iterator<Map.Entry<String, Set<NodeId>>> iter;
                    {
                        this.iter = GetLabelsToNodesResponsePBImpl.this.labelsToNodes.entrySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnProtos.LabelsToNodeIdsProto next() {
                        Map.Entry<String, Set<NodeId>> now = this.iter.next();
                        HashSet<YarnProtos.NodeIdProto> nodeProtoSet = new HashSet<YarnProtos.NodeIdProto>();
                        for (NodeId n : now.getValue()) {
                            nodeProtoSet.add(GetLabelsToNodesResponsePBImpl.this.convertToProtoFormat(n));
                        }
                        return YarnProtos.LabelsToNodeIdsProto.newBuilder().setNodeLabels(now.getKey()).addAllNodeId(nodeProtoSet).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllLabelsToNodes((Iterable<? extends YarnProtos.LabelsToNodeIdsProto>)iterable);
    }

    private void mergeLocalToBuilder() {
        if (this.labelsToNodes != null) {
            this.addLabelsToNodesToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public YarnServiceProtos.GetLabelsToNodesResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetLabelsToNodesResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    @Override
    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void setLabelsToNodes(Map<String, Set<NodeId>> map) {
        this.initLabelsToNodes();
        this.labelsToNodes.clear();
        this.labelsToNodes.putAll(map);
    }

    @Override
    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public Map<String, Set<NodeId>> getLabelsToNodes() {
        this.initLabelsToNodes();
        return this.labelsToNodes;
    }
}

