/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.lucene99.Lucene99PostingsReader;
import org.apache.lucene.codecs.lucene99.Lucene99PostingsWriter;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.UniformSplitTermsReader;
import org.apache.lucene.codecs.uniformsplit.UniformSplitTermsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.IOUtils;

public class UniformSplitPostingsFormat
extends PostingsFormat {
    public static final String TERMS_DICTIONARY_EXTENSION = "ustd";
    public static final String TERMS_BLOCKS_EXTENSION = "ustb";
    public static final int VERSION_START = 0;
    public static final int VERSION_ENCODABLE_FIELDS_METADATA = 1;
    public static final int VERSION_CURRENT = 1;
    public static final String NAME = "UniformSplit";
    protected final int targetNumBlockLines;
    protected final int deltaNumLines;
    protected final BlockEncoder blockEncoder;
    protected final BlockDecoder blockDecoder;
    protected final boolean dictionaryOnHeap;

    public UniformSplitPostingsFormat() {
        this(32, 3, null, null, false);
    }

    public UniformSplitPostingsFormat(int targetNumBlockLines, int deltaNumLines, BlockEncoder blockEncoder, BlockDecoder blockDecoder, boolean dictionaryOnHeap) {
        this(NAME, targetNumBlockLines, deltaNumLines, blockEncoder, blockDecoder, dictionaryOnHeap);
    }

    protected UniformSplitPostingsFormat(String name, int targetNumBlockLines, int deltaNumLines, BlockEncoder blockEncoder, BlockDecoder blockDecoder, boolean dictionaryOnHeap) {
        super(name);
        UniformSplitTermsWriter.validateSettings(targetNumBlockLines, deltaNumLines);
        UniformSplitPostingsFormat.validateBlockEncoder(blockEncoder, blockDecoder);
        this.targetNumBlockLines = targetNumBlockLines;
        this.deltaNumLines = deltaNumLines;
        this.blockEncoder = blockEncoder;
        this.blockDecoder = blockDecoder;
        this.dictionaryOnHeap = dictionaryOnHeap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FieldsConsumer fieldsConsumer;
        block3: {
            Lucene99PostingsWriter postingsWriter = new Lucene99PostingsWriter(state);
            boolean success = false;
            try {
                FieldsConsumer termsWriter = this.createUniformSplitTermsWriter((PostingsWriterBase)postingsWriter, state, this.targetNumBlockLines, this.deltaNumLines, this.blockEncoder);
                success = true;
                fieldsConsumer = termsWriter;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsWriter});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsWriter});
        }
        return fieldsConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FieldsProducer fieldsProducer;
        block3: {
            Lucene99PostingsReader postingsReader = new Lucene99PostingsReader(state);
            boolean success = false;
            try {
                FieldsProducer termsReader = this.createUniformSplitTermsReader((PostingsReaderBase)postingsReader, state, this.blockDecoder);
                success = true;
                fieldsProducer = termsReader;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
        }
        return fieldsProducer;
    }

    protected FieldsConsumer createUniformSplitTermsWriter(PostingsWriterBase postingsWriter, SegmentWriteState state, int targetNumBlockLines, int deltaNumLines, BlockEncoder blockEncoder) throws IOException {
        return new UniformSplitTermsWriter(postingsWriter, state, targetNumBlockLines, deltaNumLines, blockEncoder);
    }

    protected FieldsProducer createUniformSplitTermsReader(PostingsReaderBase postingsReader, SegmentReadState state, BlockDecoder blockDecoder) throws IOException {
        return new UniformSplitTermsReader(postingsReader, state, blockDecoder, this.dictionaryOnHeap);
    }

    private static void validateBlockEncoder(BlockEncoder blockEncoder, BlockDecoder blockDecoder) {
        if (blockEncoder != null && blockDecoder == null || blockEncoder == null && blockDecoder != null) {
            throw new IllegalArgumentException("Invalid blockEncoder=" + blockEncoder + " and blockDecoder=" + blockDecoder + ", both must be null or both must be non-null");
        }
    }
}

