/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class ArnaviBinaryProtocolDecoder
extends BaseProtocolDecoder {
    private static final byte HEADER_START_SIGN = -1;
    private static final byte HEADER_VERSION_1 = 34;
    private static final byte HEADER_VERSION_2 = 35;
    private static final byte RECORD_PING = 0;
    private static final byte RECORD_DATA = 1;
    private static final byte RECORD_TEXT = 3;
    private static final byte RECORD_FILE = 4;
    private static final byte RECORD_BINARY = 6;
    private static final byte TAG_LATITUDE = 3;
    private static final byte TAG_LONGITUDE = 4;
    private static final byte TAG_COORD_PARAMS = 5;

    public ArnaviBinaryProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, byte version, int index) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(123);
            if (version == 34) {
                response.writeByte(0);
                response.writeByte((int)((byte)index));
            } else if (version == 35) {
                response.writeByte(4);
                response.writeByte(0);
                ByteBuffer time = ByteBuffer.allocate(4).putInt((int)(System.currentTimeMillis() / 1000L));
                ((Buffer)time).position(0);
                response.writeByte(Checksum.modulo256(time.slice()));
                response.writeBytes(time);
            }
            response.writeByte(125);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private Position decodePosition(DeviceSession deviceSession, ByteBuf buf, int length, Date time) {
        Position position = new Position();
        position.setProtocol(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(time);
        block5: for (int readBytes = 0; readBytes < length; readBytes += 5) {
            short tag = buf.readUnsignedByte();
            switch (tag) {
                case 3: {
                    position.setLatitude(buf.readFloatLE());
                    position.setValid(true);
                    continue block5;
                }
                case 4: {
                    position.setLongitude(buf.readFloatLE());
                    position.setValid(true);
                    continue block5;
                }
                case 5: {
                    position.setCourse(buf.readUnsignedByte() * 2);
                    position.setAltitude(buf.readUnsignedByte() * 10);
                    byte satellites = buf.readByte();
                    position.set("sat", satellites & 15 + (satellites >> 4) & 0xF);
                    position.setSpeed(buf.readUnsignedByte());
                    continue block5;
                }
                default: {
                    buf.skipBytes(4);
                }
            }
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        byte startSign = buf.readByte();
        if (startSign == -1) {
            byte version = buf.readByte();
            String imei = String.valueOf(buf.readLongLE());
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
            if (deviceSession != null) {
                this.sendResponse(channel, version, 0);
            }
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        short index = buf.readUnsignedByte();
        byte recordType = buf.readByte();
        while (buf.readableBytes() > 0) {
            switch (recordType) {
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    int length = buf.readUnsignedShortLE();
                    Date time = new Date(buf.readUnsignedIntLE() * 1000L);
                    if (recordType == 1) {
                        positions.add(this.decodePosition(deviceSession, buf, length, time));
                    } else {
                        buf.readBytes(length);
                    }
                    buf.readUnsignedByte();
                    break;
                }
                default: {
                    return null;
                }
            }
            recordType = buf.readByte();
        }
        this.sendResponse(channel, (byte)34, index);
        return positions;
    }
}

