/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class H02ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*").expression("..,").number("(d+)?,").groupBegin().text("V4,").expression("(.*),").or().expression("(V[^,]*),").groupEnd().number("(?:(dd)(dd)(dd))?,").groupBegin().expression("([ABV])?,").or().number("(d+),").groupEnd().groupBegin().number("-(d+)-(d+.d+),([NS]),").or().number("(d+)(dd.d+),([NS]),").or().number("(d+)(dd)(d{4}),([NS]),").groupEnd().groupBegin().number("-(d+)-(d+.d+),([EW]),").or().number("(d+)(dd.d+),([EW]),").or().number("(d+)(dd)(d{4}),([EW]),").groupEnd().number(" *(d+.?d*),").number("(d+.?d*)?,").number("(?:d+,)?").number("(?:(dd)(dd)(dd))?").groupBegin().expression(",[^,]*,").expression("[^,]*,").expression("[^,]*").groupEnd("?").groupBegin().number(",(x{8})").groupBegin().number(",(d+),").number("(-?d+),").number("(d+.d+),").number("(-?d+),").number("(x+),").number("(x+)").or().text(",").expression("(.*)").or().groupEnd().or().groupEnd().text("#").compile();
    private static final Pattern PATTERN_NBR = new PatternBuilder().text("*").expression("..,").number("(d+),").text("NBR,").number("(dd)(dd)(dd),").number("(d+),").number("(d+),").number("d+,").number("d+,").number("((?:d+,d+,-?d+,)+)").number("(dd)(dd)(dd),").number("(x{8})").any().compile();
    private static final Pattern PATTERN_LINK = new PatternBuilder().text("*").expression("..,").number("(d+),").text("LINK,").number("(dd)(dd)(dd),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(dd)(dd)(dd),").number("(x{8})").any().compile();
    private static final Pattern PATTERN_V3 = new PatternBuilder().text("*").expression("..,").number("(d+),").text("V3,").number("(dd)(dd)(dd),").number("(ddd)").number("(d+),").number("(d+),").expression("(.*),").number("(x{4}),").number("d+,").text("X,").number("(dd)(dd)(dd),").number("(x{8})").text("#").optional().compile();
    private static final Pattern PATTERN_VP1 = new PatternBuilder().text("*hq,").number("(d{15}),").text("VP1,").groupBegin().text("V,").number("(d+),").number("(d+),").expression("([^#]+)").or().expression("[AB],").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW]),").number("(d+.d+),").number("(d+.d+),").number("(dd)(dd)(dd)").groupEnd().any().compile();
    private static final Pattern PATTERN_HTBT = new PatternBuilder().text("*HQ,").number("(d{15}),").text("HTBT,").number("(d+)").any().compile();

    public H02ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static double readCoordinate(ByteBuf buf, boolean lon) {
        int degrees = BcdUtil.readInteger(buf, 2);
        if (lon) {
            degrees = degrees * 10 + (buf.getUnsignedByte(buf.readerIndex()) >> 4);
        }
        double result = 0.0;
        if (lon) {
            result = buf.readUnsignedByte() & 0xF;
        }
        int length = 6;
        if (lon) {
            length = 5;
        }
        result = result * 10.0 + (double)BcdUtil.readInteger(buf, length) * 1.0E-4;
        result /= 60.0;
        return result += (double)degrees;
    }

    private void processStatus(Position position, long status) {
        if (!BitUtil.check(status, 0)) {
            position.addAlarm("vibration");
        } else if (!BitUtil.check(status, 1) || !BitUtil.check(status, 18)) {
            position.addAlarm("sos");
        } else if (!BitUtil.check(status, 2)) {
            position.addAlarm("overspeed");
        } else if (!BitUtil.check(status, 19)) {
            position.addAlarm("powerCut");
        }
        position.set("ignition", BitUtil.check(status, 10));
        position.set("status", status);
    }

    private Integer decodeBattery(int value) {
        if (value == 0) {
            return null;
        }
        if (value <= 3) {
            return (value - 1) * 10;
        }
        if (value <= 6) {
            return (value - 1) * 20;
        }
        if (value <= 100) {
            return value;
        }
        if (value >= 241 && value <= 246) {
            return value - 240;
        }
        return null;
    }

    private Position decodeBinary(ByteBuf buf, Channel channel, SocketAddress remoteAddress) {
        Position position = new Position(this.getProtocolName());
        boolean longId = buf.readableBytes() == 42;
        buf.readByte();
        String id = longId ? ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(0, 15) : ByteBufUtil.hexDump((ByteBuf)buf.readSlice(5));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setYear(BcdUtil.readInteger(buf, 2));
        position.setTime(dateBuilder.getDate());
        double latitude = H02ProtocolDecoder.readCoordinate(buf, false);
        position.set("batteryLevel", this.decodeBattery(buf.readUnsignedByte()));
        double longitude = H02ProtocolDecoder.readCoordinate(buf, true);
        int flags = buf.readUnsignedByte() & 0xF;
        position.setValid((flags & 2) != 0);
        if ((flags & 4) == 0) {
            latitude = -latitude;
        }
        if ((flags & 8) == 0) {
            longitude = -longitude;
        }
        position.setLatitude(latitude);
        position.setLongitude(longitude);
        position.setSpeed(BcdUtil.readInteger(buf, 3));
        position.setCourse((double)(buf.readUnsignedByte() & 0xF) * 100.0 + (double)BcdUtil.readInteger(buf, 2));
        this.processStatus(position, buf.readUnsignedInt());
        return position;
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, String id, String type) {
        if (channel != null && id != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(type.equals("R12") ? "HHmmss" : "yyyyMMddHHmmss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = dateFormat.format(new Date());
            String response = type.equals("R12") ? String.format("*HQ,%s,%s,%s#", id, type, time) : String.format("*HQ,%s,V4,%s,%s#", id, type, time);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private Position decodeText(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        String id = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (parser.hasNext()) {
            position.set("result", parser.next());
        }
        if (parser.hasNext() && parser.next().equals("V1")) {
            this.sendResponse(channel, remoteAddress, id, "V1");
        } else if (this.getConfig().getBoolean(Keys.PROTOCOL_ACK.withPrefix(this.getProtocolName()))) {
            this.sendResponse(channel, remoteAddress, id, "R12");
        }
        DateBuilder dateBuilder = new DateBuilder();
        if (parser.hasNext(3)) {
            dateBuilder.setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        }
        if (parser.hasNext()) {
            position.setValid(parser.next().equals("A"));
        }
        if (parser.hasNext()) {
            parser.nextInt();
            position.setValid(true);
        }
        if (parser.hasNext(3)) {
            position.setLatitude(parser.nextCoordinate());
        }
        if (parser.hasNext(3)) {
            position.setLatitude(parser.nextCoordinate());
        }
        if (parser.hasNext(4)) {
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN_HEM));
        }
        if (parser.hasNext(3)) {
            position.setLongitude(parser.nextCoordinate());
        }
        if (parser.hasNext(3)) {
            position.setLongitude(parser.nextCoordinate());
        }
        if (parser.hasNext(4)) {
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN_HEM));
        }
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        if (parser.hasNext(3)) {
            dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setTime(dateBuilder.getDate());
        } else {
            position.setTime(new Date());
        }
        if (parser.hasNext()) {
            this.processStatus(position, parser.nextLong(16, 0L));
        }
        if (parser.hasNext(6)) {
            position.set("odometer", parser.nextInt(0));
            position.set("temp1", parser.nextInt(0));
            position.set("fuel", parser.nextDouble(0.0));
            position.setAltitude(parser.nextInt(0));
            position.setNetwork(new Network(CellTower.fromLacCid(this.getConfig(), parser.nextHexInt(0), parser.nextHexInt(0))));
        }
        if (parser.hasNext()) {
            String[] values = parser.next().split(",");
            for (int i = 0; i < values.length; ++i) {
                position.set("io" + (i + 1), values[i].trim());
            }
        }
        return position;
    }

    private Position decodeLbs(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_NBR, sentence);
        if (!parser.matches()) {
            return null;
        }
        String id = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        this.sendResponse(channel, remoteAddress, id, "NBR");
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        Network network = new Network();
        int mcc = parser.nextInt(0);
        int mnc = parser.nextInt(0);
        String[] cells = parser.next().split(",");
        for (int i = 0; i < cells.length / 3; ++i) {
            network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(cells[i * 3]), Integer.parseInt(cells[i * 3 + 1]), Integer.parseInt(cells[i * 3 + 2])));
        }
        position.setNetwork(network);
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        this.getLastLocation(position, dateBuilder.getDate());
        this.processStatus(position, parser.nextLong(16, 0L));
        return position;
    }

    private Position decodeLink(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_LINK, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.set("rssi", parser.nextInt());
        position.set("sat", parser.nextInt());
        position.set("batteryLevel", parser.nextInt());
        position.set("steps", parser.nextInt());
        position.set("turnovers", parser.nextInt());
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        this.getLastLocation(position, dateBuilder.getDate());
        this.processStatus(position, parser.nextLong(16, 0L));
        return position;
    }

    private Position decodeV3(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_V3, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        int mcc = parser.nextInt();
        int mnc = parser.nextInt();
        int count = parser.nextInt();
        Network network = new Network();
        String[] values = parser.next().split(",");
        for (int i = 0; i < count; ++i) {
            network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(values[i * 4]), Integer.parseInt(values[i * 4 + 1])));
        }
        position.setNetwork(network);
        position.set("battery", parser.nextHexInt());
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        this.getLastLocation(position, dateBuilder.getDate());
        this.processStatus(position, parser.nextLong(16, 0L));
        return position;
    }

    private Position decodeVp1(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_VP1, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (parser.hasNext(3)) {
            this.getLastLocation(position, null);
            int mcc = parser.nextInt();
            int mnc = parser.nextInt();
            Network network = new Network();
            for (String cell : parser.next().split("Y")) {
                String[] values = cell.split(",");
                network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2])));
            }
            position.setNetwork(network);
        } else {
            position.setValid(true);
            position.setLatitude(parser.nextCoordinate());
            position.setLongitude(parser.nextCoordinate());
            position.setSpeed(parser.nextDouble());
            position.setCourse(parser.nextDouble());
            position.setTime(new DateBuilder().setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0)).getDate());
        }
        return position;
    }

    private Position decodeHeartbeat(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_HTBT, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("batteryLevel", parser.nextInt());
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String marker;
        ByteBuf buf = (ByteBuf)msg;
        switch (marker = buf.toString(0, 1, StandardCharsets.US_ASCII)) {
            case "*": {
                String sentence = buf.toString(StandardCharsets.US_ASCII).trim();
                int typeStart = sentence.indexOf(44, sentence.indexOf(44) + 1) + 1;
                int typeEnd = sentence.indexOf(44, typeStart);
                if (typeEnd < 0) {
                    typeEnd = sentence.indexOf(35, typeStart);
                }
                if (typeEnd > 0) {
                    String type;
                    return switch (type = sentence.substring(typeStart, typeEnd)) {
                        case "V0", "HTBT" -> {
                            if (channel != null) {
                                String response = sentence.substring(0, typeEnd) + "#";
                                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                            }
                            yield this.decodeHeartbeat(sentence, channel, remoteAddress);
                        }
                        case "NBR" -> this.decodeLbs(sentence, channel, remoteAddress);
                        case "LINK" -> this.decodeLink(sentence, channel, remoteAddress);
                        case "V3" -> this.decodeV3(sentence, channel, remoteAddress);
                        case "VP1" -> this.decodeVp1(sentence, channel, remoteAddress);
                        default -> this.decodeText(sentence, channel, remoteAddress);
                    };
                }
                return null;
            }
            case "$": {
                return this.decodeBinary(buf, channel, remoteAddress);
            }
        }
        return null;
    }
}

