/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class SuntechProtocolDecoder
extends BaseProtocolDecoder {
    private boolean universal;
    private String prefix;
    private int protocolType;
    private int hbm;
    private boolean includeAdc;
    private boolean includeRpm;
    private boolean includeTemp;
    private ByteBuf crash;

    public SuntechProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public boolean getUniversal() {
        return this.universal;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setProtocolType(int protocolType) {
        this.protocolType = protocolType;
    }

    public int getProtocolType(long deviceId) {
        Integer value = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_TYPE, deviceId);
        return value != null ? value : this.protocolType;
    }

    public void setHbm(int hbm) {
        this.hbm = hbm;
    }

    public int getHbm(long deviceId) {
        Integer value = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_HBM, deviceId);
        return value != null ? value : this.hbm;
    }

    public void setIncludeAdc(boolean includeAdc) {
        this.includeAdc = includeAdc;
    }

    public boolean isIncludeAdc(long deviceId) {
        Boolean value = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_INCLUDE_ADC.withPrefix(this.getProtocolName()), deviceId);
        return value != null ? value : this.includeAdc;
    }

    public void setIncludeRpm(boolean includeRpm) {
        this.includeRpm = includeRpm;
    }

    public boolean isIncludeRpm(long deviceId) {
        Boolean value = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_INCLUDE_RPM.withPrefix(this.getProtocolName()), deviceId);
        return value != null ? value : this.includeRpm;
    }

    public void setIncludeTemp(boolean includeTemp) {
        this.includeTemp = includeTemp;
    }

    public boolean isIncludeTemp(long deviceId) {
        Boolean value = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_INCLUDE_TEMPERATURE.withPrefix(this.getProtocolName()), deviceId);
        return value != null ? value : this.includeTemp;
    }

    private Position decode9(Channel channel, SocketAddress remoteAddress, String[] values) throws ParseException {
        DeviceSession deviceSession;
        String type;
        int index = 1;
        if (!((type = values[index++]).equals("Location") || type.equals("Emergency") || type.equals("Alert"))) {
            return null;
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, values[index++])) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (type.equals("Emergency") || type.equals("Alert")) {
            position.addAlarm("general");
        }
        if (!type.equals("Alert") || this.getProtocolType(deviceSession.getDeviceId()) == 0) {
            position.set("versionFw", values[index++]);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        position.setTime(dateFormat.parse(values[index++] + values[index++]));
        if (this.getProtocolType(deviceSession.getDeviceId()) == 1) {
            // empty if block
        }
        int n = ++index;
        position.setLatitude(Double.parseDouble(values[n]));
        int n2 = ++index;
        position.setLongitude(Double.parseDouble(values[n2]));
        int n3 = ++index;
        position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[n3])));
        int n4 = ++index;
        position.setCourse(Double.parseDouble(values[n4]));
        int n5 = ++index;
        ++index;
        position.setValid(values[n5].equals("1"));
        if (this.getProtocolType(deviceSession.getDeviceId()) == 1) {
            position.set("odometer", Integer.parseInt(values[index++]));
        }
        return position;
    }

    private String decodeEmergency(int value) {
        return switch (value) {
            case 1 -> "sos";
            case 2 -> "parking";
            case 3 -> "powerCut";
            case 5, 6 -> "door";
            case 7 -> "movement";
            case 8 -> "vibration";
            default -> null;
        };
    }

    private String decodeAlert(int value) {
        return switch (value) {
            case 1 -> "overspeed";
            case 5 -> "geofenceExit";
            case 6 -> "geofenceEnter";
            case 14 -> "lowBattery";
            case 15 -> "vibration";
            case 16 -> "accident";
            case 40 -> "powerRestored";
            case 41 -> "powerCut";
            case 42 -> "sos";
            case 46 -> "hardAcceleration";
            case 47 -> "hardBraking";
            case 50 -> "jamming";
            case 132 -> "door";
            default -> null;
        };
    }

    private Position decode4(Channel channel, SocketAddress remoteAddress, String[] values) throws ParseException {
        DeviceSession deviceSession;
        String type;
        int index = 0;
        if (!(type = values[index++].substring(5)).equals("STT") && !type.equals("ALT")) {
            return null;
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, values[index++])) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", type);
        position.set("versionFw", values[index++]);
        int model = Integer.parseInt(values[index++]);
        if (model == 41) {
            ++index;
        }
        Network network = new Network();
        for (int i = 0; i < 7; ++i) {
            int lac;
            int rssi;
            int cid = Integer.parseInt(values[index++]);
            int mcc = Integer.parseInt(values[index++]);
            int mnc = Integer.parseInt(values[index++]);
            if (i == 0) {
                rssi = Integer.parseInt(values[index++]);
                lac = Integer.parseInt(values[index++]);
            } else {
                lac = Integer.parseInt(values[index++]);
                rssi = Integer.parseInt(values[index++]);
            }
            ++index;
            if (cid <= 0) continue;
            network.addCellTower(CellTower.from(mcc, mnc, lac, cid, rssi));
        }
        position.setNetwork(network);
        position.set("battery", Double.parseDouble(values[index++]));
        position.set("archive", values[index++].equals("0") ? Boolean.valueOf(true) : null);
        position.set("index", Integer.parseInt(values[index++]));
        position.set("status", Integer.parseInt(values[index++]));
        if (values[index].length() == 3) {
            ++index;
        }
        if (model == 41) {
            ++index;
            int n = ++index;
            ++index;
            position.set("motion", Integer.parseInt(values[n]) == 2);
        }
        if (values[index].isEmpty()) {
            this.getLastLocation(position, null);
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            position.setTime(dateFormat.parse(values[index++] + values[index++]));
            position.setLatitude(Double.parseDouble(values[index++]));
            position.setLongitude(Double.parseDouble(values[index++]));
            position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[index++])));
            position.setCourse(Double.parseDouble(values[index++]));
            position.set("sat", Integer.parseInt(values[index++]));
            position.setValid(values[index++].equals("1"));
        }
        return position;
    }

    private int decodeSerialData(Position position, String[] values, int index) {
        String attribute;
        double totalFuel = 0.0;
        for (int remaining = Integer.parseInt(values[index++]); remaining > 0; remaining -= attribute.length() + 1) {
            if ((attribute = values[index++]).startsWith("CabAVL")) {
                double fuel2;
                String[] data = attribute.split(",");
                double fuel1 = Double.parseDouble(data[2]);
                if (fuel1 > 0.0) {
                    totalFuel += fuel1;
                    position.set("fuel1", fuel1);
                }
                if (!((fuel2 = Double.parseDouble(data[3])) > 0.0)) continue;
                totalFuel += fuel2;
                position.set("fuel2", fuel2);
                continue;
            }
            if (attribute.startsWith("GTSL")) {
                position.set("driverUniqueId", attribute.split("\\|")[4]);
                continue;
            }
            if (attribute.contains("=")) {
                String[] pair = attribute.split("=");
                if (pair.length < 2) continue;
                String value = pair[1].trim();
                if (value.contains(".")) {
                    value = value.substring(0, value.indexOf(46));
                }
                switch (pair[0].charAt(0)) {
                    case 't': {
                        position.set("temp" + pair[0].charAt(2), Integer.parseInt(value, 16));
                        break;
                    }
                    case 'N': {
                        int fuel = Integer.parseInt(value, 16);
                        totalFuel += (double)fuel;
                        position.set("fuel" + pair[0].charAt(2), fuel);
                        break;
                    }
                    case 'Q': {
                        position.set("drivingQuality", Integer.parseInt(value, 16));
                    }
                }
                continue;
            }
            position.set("serial", attribute.trim());
        }
        if (totalFuel > 0.0) {
            position.set("fuel", totalFuel);
        }
        return index + 1;
    }

    private Position decode2356(Channel channel, SocketAddress remoteAddress, String protocol, String[] values) throws ParseException {
        int index = 0;
        String type = values[index++].substring(5);
        boolean result = values[index].equals("Res");
        if (result) {
            // empty if block
        }
        String[] stringArray = new String[1];
        int n = ++index;
        ++index;
        stringArray[0] = values[n];
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, stringArray);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", type);
        if (result) {
            position.set("result", String.join((CharSequence)";", Arrays.copyOfRange(values, index, values.length)));
            return position;
        }
        if (!(type.equals("STT") || type.equals("EMG") || type.equals("EVT") || type.equals("ALT") || type.equals("UEX"))) {
            return null;
        }
        if (protocol.startsWith("ST3") || protocol.equals("ST500") || protocol.equals("ST600")) {
            // empty if block
        }
        int n2 = ++index;
        position.set("versionFw", values[n2]);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        int n3 = ++index;
        int n4 = ++index;
        ++index;
        position.setTime(dateFormat.parse(values[n3] + values[n4]));
        if (!protocol.equals("ST500")) {
            long cid = Long.parseLong(values[index++], 16);
            if (protocol.equals("ST600")) {
                position.setNetwork(new Network(CellTower.from(Integer.parseInt(values[index++]), Integer.parseInt(values[index++]), Integer.parseInt(values[index++], 16), cid, Integer.parseInt(values[index++]))));
            }
        }
        position.setLatitude(Double.parseDouble(values[index++]));
        position.setLongitude(Double.parseDouble(values[index++]));
        position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[index++])));
        position.setCourse(Double.parseDouble(values[index++]));
        position.set("sat", Integer.parseInt(values[index++]));
        position.setValid(values[index++].equals("1"));
        position.set("odometer", Integer.parseInt(values[index++]));
        position.set("power", Double.parseDouble(values[index++]));
        String io = values[index++];
        if (io.length() >= 6) {
            position.set("ignition", io.charAt(0) == '1');
            position.set("in1", io.charAt(1) == '1');
            position.set("in2", io.charAt(2) == '1');
            position.set("in3", io.charAt(3) == '1');
            position.set("out1", io.charAt(4) == '1');
            position.set("out2", io.charAt(5) == '1');
        }
        switch (type) {
            case "STT": {
                position.set("status", Integer.parseInt(values[index++]));
                position.set("index", Integer.parseInt(values[index++]));
                break;
            }
            case "EMG": {
                position.addAlarm(this.decodeEmergency(Integer.parseInt(values[index++])));
                break;
            }
            case "EVT": {
                position.set("event", Integer.parseInt(values[index++]));
                break;
            }
            case "ALT": {
                position.addAlarm(this.decodeAlert(Integer.parseInt(values[index++])));
                break;
            }
            case "UEX": {
                index = this.decodeSerialData(position, values, index);
            }
        }
        if (this.getHbm(deviceSession.getDeviceId()) == 1) {
            if (index < values.length) {
                position.set("hours", UnitsConverter.msFromMinutes(Integer.parseInt(values[index++])));
            }
            if (index < values.length) {
                position.set("battery", Double.parseDouble(values[index++]));
            }
            if (index < values.length && values[index++].equals("0")) {
                position.set("archive", true);
            }
            if (this.isIncludeAdc(deviceSession.getDeviceId())) {
                for (int i = 1; i <= 3; ++i) {
                    if (index >= values.length || values[index++].isEmpty()) continue;
                    position.set("adc" + i, Double.parseDouble(values[index - 1]));
                }
            }
            if (this.isIncludeRpm(deviceSession.getDeviceId()) && index < values.length) {
                position.set("rpm", Integer.parseInt(values[index++]));
            }
            if (values.length - index >= 2) {
                String driverUniqueId;
                if (!(driverUniqueId = values[index++]).isEmpty()) {
                    position.set("driverUniqueId", driverUniqueId);
                }
                ++index;
            }
            if (this.isIncludeTemp(deviceSession.getDeviceId())) {
                for (int i = 1; i <= 3; ++i) {
                    String temperature;
                    String value;
                    if ((value = (temperature = values[index++]).substring(temperature.indexOf(58) + 1)).isEmpty()) continue;
                    position.set("temp" + i, Double.parseDouble(value));
                }
            }
        }
        return position;
    }

    private Position decodeUniversal(Channel channel, SocketAddress remoteAddress, String[] values) throws ParseException {
        Position position;
        block37: {
            int mask;
            String type;
            int index;
            block36: {
                DeviceSession deviceSession;
                index = 0;
                if (!((type = values[index++]).equals("STT") || type.equals("ALT") || type.equals("BLE") || type.equals("RES") || type.equals("UEX"))) {
                    return null;
                }
                if ((deviceSession = this.getDeviceSession(channel, remoteAddress, values[index++])) == null) {
                    return null;
                }
                position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.set("type", type);
                if (type.equals("RES")) {
                    this.getLastLocation(position, null);
                    position.set("result", Arrays.stream(values, index, values.length).collect(Collectors.joining(";")));
                    return position;
                }
                mask = type.equals("BLE") ? 6198 : Integer.parseInt(values[index++], 16);
                if (BitUtil.check(mask, 1)) {
                    ++index;
                }
                if (BitUtil.check(mask, 2)) {
                    position.set("versionFw", values[index++]);
                }
                if (BitUtil.check(mask, 3) && values[index++].equals("0")) {
                    position.set("archive", true);
                }
                if (BitUtil.check(mask, 4) && BitUtil.check(mask, 5)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHH:mm:ss");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    position.setTime(dateFormat.parse(values[index++] + values[index++]));
                }
                CellTower cellTower = new CellTower();
                if (BitUtil.check(mask, 6)) {
                    cellTower.setCellId(Long.parseLong(values[index++], 16));
                }
                if (BitUtil.check(mask, 7)) {
                    cellTower.setMobileCountryCode(Integer.parseInt(values[index++]));
                }
                if (BitUtil.check(mask, 8)) {
                    cellTower.setMobileNetworkCode(Integer.parseInt(values[index++]));
                }
                if (BitUtil.check(mask, 9)) {
                    cellTower.setLocationAreaCode(Integer.parseInt(values[index++], 16));
                }
                if (cellTower.getCellId() != null) {
                    position.setNetwork(new Network(cellTower));
                }
                if (BitUtil.check(mask, 10)) {
                    position.set("rssi", Integer.parseInt(values[index++]));
                }
                if (BitUtil.check(mask, 11)) {
                    position.setLatitude(Double.parseDouble(values[index++]));
                }
                if (BitUtil.check(mask, 12)) {
                    position.setLongitude(Double.parseDouble(values[index++]));
                }
                if (!type.equals("BLE")) break block36;
                position.setValid(true);
                int count = Integer.parseInt(values[index++]);
                for (int i = 1; i <= count; ++i) {
                    position.set("tag" + i + "Rssi", Integer.parseInt(values[index++]));
                    ++index;
                    int n = ++index;
                    position.set("tag" + i + "Id", values[n]);
                    int n2 = ++index;
                    position.set("tag" + i + "Samples", Integer.parseInt(values[n2]));
                    int n3 = ++index;
                    position.set("tag" + i + "Major", Integer.parseInt(values[n3]));
                    int n4 = ++index;
                    ++index;
                    position.set("tag" + i + "Minor", Integer.parseInt(values[n4]));
                }
                break block37;
            }
            if (BitUtil.check(mask, 13)) {
                position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[index++])));
            }
            if (BitUtil.check(mask, 14)) {
                position.setCourse(Double.parseDouble(values[index++]));
            }
            if (BitUtil.check(mask, 15)) {
                position.set("sat", Integer.parseInt(values[index++]));
            }
            if (BitUtil.check(mask, 16)) {
                position.setValid(values[index++].equals("1"));
            }
            if (BitUtil.check(mask, 17)) {
                int input = Integer.parseInt(values[index++]);
                position.set("ignition", BitUtil.check(input, 0));
                position.set("input", input);
            }
            if (BitUtil.check(mask, 18)) {
                position.set("output", Integer.parseInt(values[index++]));
            }
            String input = type;
            int i = -1;
            switch (input.hashCode()) {
                case 64905: {
                    if (!input.equals("ALT")) break;
                    i = 0;
                    break;
                }
                case 83912: {
                    if (!input.equals("UEX")) break;
                    i = 1;
                }
            }
            switch (i) {
                case 0: {
                    if (BitUtil.check(mask, 19)) {
                        int alertId = Integer.parseInt(values[index++]);
                        position.addAlarm(this.decodeAlert(alertId));
                    }
                    if (BitUtil.check(mask, 20)) {
                        position.set("alertModifier", values[index++]);
                    }
                    if (!BitUtil.check(mask, 21)) break;
                    position.set("alertData", values[index++]);
                    break;
                }
                case 1: {
                    index = this.decodeSerialData(position, values, index);
                    break;
                }
                default: {
                    if (BitUtil.check(mask, 19)) {
                        position.set("mode", Integer.parseInt(values[index++]));
                    }
                    if (BitUtil.check(mask, 20)) {
                        position.set("reason", Integer.parseInt(values[index++]));
                    }
                    if (!BitUtil.check(mask, 21)) break;
                    position.set("index", Integer.parseInt(values[index++]));
                }
            }
            if (BitUtil.check(mask, 22)) {
                ++index;
            }
            if (!BitUtil.check(mask, 23) || type.equals("UEX")) break block37;
            int assignMask = Integer.parseInt(values[index++], 16);
            for (i = 0; i <= 30; ++i) {
                if (!BitUtil.check(assignMask, i)) continue;
                position.set("io" + (i + 1), values[index++]);
            }
        }
        return position;
    }

    private Position decodeZip(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        int i;
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        short type = buf.readUnsignedByte();
        if (type != 16) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(5)).substring(0, 9));
        if (deviceSession == null) {
            return null;
        }
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).getDate());
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        position.setLatitude((double)buf.readUnsignedByte() + (double)BcdUtil.readInteger(buf, 6) / 1000000.0);
        position.setLongitude((double)buf.readUnsignedByte() + (double)BcdUtil.readInteger(buf, 6) / 1000000.0);
        position.setSpeed((double)buf.readUnsignedShort() + (double)BcdUtil.readInteger(buf, 2) / 100.0);
        position.setCourse((double)buf.readUnsignedShort() + (double)BcdUtil.readInteger(buf, 2) / 100.0);
        short flags = buf.readUnsignedByte();
        position.setValid(BitUtil.check(flags, 7));
        if (BitUtil.check(flags, 6)) {
            position.setLatitude(-position.getLatitude());
        }
        if (BitUtil.check(flags, 5)) {
            position.setLongitude(-position.getLongitude());
        }
        position.set("odometer", buf.readUnsignedInt());
        position.set("power", (double)buf.readUnsignedByte() + (double)BcdUtil.readInteger(buf, 2) / 100.0);
        short io = buf.readUnsignedByte();
        position.set("ignition", BitUtil.check(io, 0));
        for (i = 1; i <= 3; ++i) {
            position.set("in" + i, BitUtil.check(io, i));
        }
        for (i = 1; i <= 2; ++i) {
            position.set("out" + i, BitUtil.check(io, i + 3));
        }
        position.set("event", buf.readUnsignedByte());
        int hbm = this.getHbm(deviceSession.getDeviceId());
        if (hbm == 1) {
            position.set("hours", buf.readUnsignedInt());
            position.set("battery", buf.readUnsignedShort());
            position.set("archive", buf.readUnsignedByte() == 0 ? Boolean.valueOf(true) : null);
        }
        if (hbm == 2) {
            int cid = buf.readUnsignedShort();
            int mcc = buf.readUnsignedShort();
            short mnc = buf.readUnsignedByte();
            int rssi = buf.readUnsignedShort();
            int lac = buf.readUnsignedShort();
            position.setNetwork(new Network(CellTower.from(mcc, mnc, lac, cid, rssi)));
            buf.readUnsignedByte();
        }
        buf.readUnsignedByte();
        return position;
    }

    private Position decodeBinary(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(5)));
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        int mask = buf.readUnsignedMedium();
        if (BitUtil.check(mask, 1)) {
            buf.readUnsignedByte();
        }
        if (BitUtil.check(mask, 2)) {
            position.set("versionFw", String.format("%d.%d.%d", buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()));
        }
        if (BitUtil.check(mask, 3) && buf.readUnsignedByte() == 0) {
            position.set("archive", true);
        }
        if (BitUtil.check(mask, 4) && BitUtil.check(mask, 5)) {
            position.setTime(new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).getDate());
        }
        if (BitUtil.check(mask, 6)) {
            buf.readUnsignedInt();
        }
        if (BitUtil.check(mask, 7)) {
            buf.readUnsignedShort();
        }
        if (BitUtil.check(mask, 8)) {
            buf.readUnsignedShort();
        }
        if (BitUtil.check(mask, 9)) {
            buf.readUnsignedShort();
        }
        if (BitUtil.check(mask, 10)) {
            position.set("rssi", buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 11)) {
            position.setLatitude((double)BufferUtil.readSignedMagnitudeInt(buf) / 1000000.0);
        }
        if (BitUtil.check(mask, 12)) {
            position.setLongitude((double)BufferUtil.readSignedMagnitudeInt(buf) / 1000000.0);
        }
        if (BitUtil.check(mask, 13)) {
            position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() / 100.0));
        }
        if (BitUtil.check(mask, 14)) {
            position.setCourse((double)buf.readUnsignedShort() / 100.0);
        }
        if (BitUtil.check(mask, 15)) {
            position.set("sat", buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 16)) {
            position.setValid(buf.readUnsignedByte() > 0);
        }
        if (BitUtil.check(mask, 17)) {
            short input = buf.readUnsignedByte();
            position.set("ignition", BitUtil.check(input, 0));
            position.set("input", Integer.valueOf(input));
        }
        if (BitUtil.check(mask, 18)) {
            position.set("output", buf.readUnsignedByte());
        }
        short alertId = 0;
        if (BitUtil.check(mask, 19)) {
            alertId = buf.readUnsignedByte();
            if (type == 130) {
                position.addAlarm(this.decodeAlert(alertId));
            }
        }
        if (BitUtil.check(mask, 20)) {
            buf.readUnsignedShort();
        }
        if (BitUtil.check(mask, 21) && alertId == 59) {
            position.set("driverUniqueId", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)));
        }
        return position;
    }

    private Position decodeTravelReport(Channel channel, SocketAddress remoteAddress, String[] values) {
        DeviceSession deviceSession;
        int index = 1;
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, values[index++])) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("driverUniqueId", values[values.length - 1]);
        return position;
    }

    private Collection<Position> decodeCrashReport(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        if (buf.getByte(buf.readerIndex() + 3) != 59) {
            return null;
        }
        String[] values = buf.readCharSequence(23, StandardCharsets.US_ASCII).toString().split(";");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, values[1]);
        if (deviceSession == null) {
            return null;
        }
        int currentIndex = Integer.parseInt(values[2]);
        int totalIndex = Integer.parseInt(values[3]);
        if (this.crash == null) {
            this.crash = Unpooled.buffer();
        }
        this.crash.writeBytes(buf.readSlice(buf.readableBytes() - 3));
        if (currentIndex == totalIndex) {
            LinkedList<Position> positions = new LinkedList<Position>();
            Date crashTime = new DateBuilder().setDate(this.crash.readUnsignedByte(), this.crash.readUnsignedByte(), this.crash.readUnsignedByte()).setTime(this.crash.readUnsignedByte(), this.crash.readUnsignedByte(), this.crash.readUnsignedByte()).getDate();
            List<Date> times = Arrays.asList(new Date(crashTime.getTime() - 3000L), new Date(crashTime.getTime() - 2000L), new Date(crashTime.getTime() - 1000L), new Date(crashTime.getTime() + 1000L));
            for (Date time : times) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.setValid(true);
                position.setTime(time);
                position.setLatitude((double)this.crash.readIntLE() * 1.0E-7);
                position.setLongitude((double)this.crash.readIntLE() * 1.0E-7);
                position.setSpeed(UnitsConverter.knotsFromKph((double)this.crash.readUnsignedShort() * 0.01));
                position.setCourse((double)this.crash.readUnsignedShort() * 0.01);
                StringBuilder value = new StringBuilder("[");
                for (int i = 0; i < 100; ++i) {
                    if (value.length() > 1) {
                        value.append(",");
                    }
                    value.append("[");
                    value.append(this.crash.readShortLE());
                    value.append(",");
                    value.append(this.crash.readShortLE());
                    value.append(",");
                    value.append(this.crash.readShortLE());
                    value.append("]");
                }
                value.append("]");
                position.set("gSensor", value.toString());
                positions.add(position);
            }
            this.crash.release();
            this.crash = null;
            return positions;
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex()) == 2) {
            return this.decodeZip(channel, remoteAddress, buf);
        }
        if (buf.getByte(buf.readerIndex() + 1) == 0) {
            this.universal = true;
            return this.decodeBinary(channel, remoteAddress, buf);
        }
        String[] values = buf.toString(StandardCharsets.US_ASCII).split(";", -1);
        this.prefix = values[0];
        if (this.prefix.equals("CRR")) {
            return this.decodeCrashReport(channel, remoteAddress, buf);
        }
        if (this.prefix.length() < 5) {
            this.universal = true;
            return this.decodeUniversal(channel, remoteAddress, values);
        }
        if (this.prefix.endsWith("HTE")) {
            return this.decodeTravelReport(channel, remoteAddress, values);
        }
        if (this.prefix.startsWith("ST9")) {
            return this.decode9(channel, remoteAddress, values);
        }
        if (this.prefix.startsWith("ST4")) {
            return this.decode4(channel, remoteAddress, values);
        }
        return this.decode2356(channel, remoteAddress, this.prefix.substring(0, 5), values);
    }
}

