#!/usr/bin/perl
#  upgrade-splits.pl - add a comment field to all splits.  Do not run this on
#	your data file more than once!
#
#  Usage: upgrade-splits.pl <data-dir>
#
#  WARNING:  BACKUP ALL YOUR DATA FIRST!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#
#  Written by Curtis Olson.  Started July 17, 1995.
#
#  Copyright (C) 1995  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: upgrade-splits.pl,v 2.2 1996/07/13 02:58:24 curt Exp $
# (Log is kept at end of this file)


# specify the installed location of the necessary pieces.
$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "engine.pl";

($#ARGV >= 0) || 
    die "Usage: upgrade.pl <data-dir>";

print <<"EndOfWarning";
This program upgrades your commentless splits to splits with comments.

You are strongly encouraged to make BACKUPS of all your data before
attempting to do this!!!

EndOfWarning

print "Do you wish to continue? (yes/no) [no] ";

$response = <STDIN>;

if ( $response =~ m/yes/i ) {
    print "Ok, continuing:\n";
} else {
    die "Bailing out ... nothing was done to your data.\n";
}


$dir = shift(@ARGV);

-e $dir || die "Specified data directory:  '$dir' does not exist\n";

print "\n";
foreach $file ( `ls $dir/*.dir $dir/*.cbb` ) {
    chop($file);

    print "Fixing splits in '$file'\n";

    $result = &load_trans($file);
    die "Cannot open account:  $file" if ( $result eq "error" );

    # %TRANS & @KEYS are setup during the load_trans() call
    foreach $key ( sort keys %TRANS ) {
	$TRANS{$key} = &fix_splits($TRANS{$key});
    }

    if ( $file =~ m/\.cbb$/ ) {
        &save_trans("$file");
    }
}

print "\n";
print "Successfully fixed splits ... we hope :)\n";


# ----------------------------------------------------------------------------
# $Log: upgrade-splits.pl,v $
# Revision 2.2  1996/07/13 02:58:24  curt
# Misc. changes.
#
# Revision 2.1  1996/02/27  05:36:05  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:15  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
