/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.jhotdraw.gui.plaf.palette.BackdropBorder;
import org.jhotdraw.gui.plaf.palette.PaletteButtonBorder;
import org.jhotdraw.gui.plaf.palette.PaletteTextComponentBorder;

public class PaletteLookAndFeel
extends BasicLookAndFeel {
    private static PaletteLookAndFeel instance;
    private UIDefaults cachedDefaults;

    public static PaletteLookAndFeel getInstance() {
        if (instance == null) {
            instance = new PaletteLookAndFeel();
        }
        return instance;
    }

    @Override
    public String getName() {
        return "Palette Look and Feel";
    }

    @Override
    public String getID() {
        return "Palette";
    }

    @Override
    public String getDescription() {
        return "A look and feel for palette components";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public UIDefaults getCachedDefaults() {
        if (this.cachedDefaults == null) {
            this.cachedDefaults = this.getDefaults();
        }
        return this.cachedDefaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        UIDefaults uIDefaults = this.getCachedDefaults();
        Object object2 = uIDefaults.get(object);
        if (!(object2 instanceof UIDefaults.ActiveValue) && !(object2 instanceof UIDefaults.LazyValue)) {
            return object2;
        }
        if (object2 instanceof UIDefaults.LazyValue) {
            try {
                object2 = ((UIDefaults.LazyValue)object2).createValue(uIDefaults);
            }
            finally {
                if (object2 == null) {
                    uIDefaults.remove(object);
                } else {
                    uIDefaults.put(object, object2);
                }
            }
        } else {
            object2 = ((UIDefaults.ActiveValue)object2).createValue(uIDefaults);
        }
        return object2;
    }

    public Font getFont(String string) {
        return (Font)this.get(string);
    }

    public Border getBorder(String string) {
        return (Border)this.get(string);
    }

    public Color getColor(String string) {
        return (Color)this.get(string);
    }

    public Insets getInsets(String string) {
        return (Insets)this.get(string);
    }

    public boolean getBoolean(String string) {
        return (Boolean)this.get(string);
    }

    public static void installColorsAndFont(JComponent jComponent, String string, String string2, String string3) {
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            jComponent.setFont(PaletteLookAndFeel.getInstance().getFont(string3));
        }
        PaletteLookAndFeel.installColors(jComponent, string, string2);
    }

    public static void installBorder(JComponent jComponent, String string) {
        Border border = jComponent.getBorder();
        jComponent.setBorder(PaletteLookAndFeel.getInstance().getBorder(string));
    }

    public static void installColors(JComponent jComponent, String string, String string2) {
        Color color;
        Color color2 = jComponent.getBackground();
        if (color2 == null || color2 instanceof UIResource) {
            jComponent.setBackground(PaletteLookAndFeel.getInstance().getColor(string));
        }
        if ((color = jComponent.getForeground()) == null || color instanceof UIResource) {
            jComponent.setForeground(PaletteLookAndFeel.getInstance().getColor(string2));
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        uIDefaults.addResourceBundle("org.jhotdraw.gui.Labels");
        Integer n = new Integer(11);
        Integer n2 = new Integer(12);
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(1);
        UIDefaults.ProxyLazyValue proxyLazyValue = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog Sans", n3, n});
        UIDefaults.ProxyLazyValue proxyLazyValue2 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog Sans", n3, n2});
        UIDefaults.ProxyLazyValue proxyLazyValue3 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Verdana", n3, n2});
        UIDefaults.ProxyLazyValue proxyLazyValue4 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Serif", n3, n2});
        UIDefaults.ProxyLazyValue proxyLazyValue5 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"SansSerif", n3, n2});
        UIDefaults.ProxyLazyValue proxyLazyValue6 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"MonoSpaced", n3, n2});
        UIDefaults.ProxyLazyValue proxyLazyValue7 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog", n4, n2});
        ColorUIResource colorUIResource = new ColorUIResource(Color.black);
        ColorUIResource colorUIResource2 = new ColorUIResource(0xF0F0F0);
        ColorUIResource colorUIResource3 = colorUIResource;
        ColorUIResource colorUIResource4 = new ColorUIResource(11916799);
        ColorUIResource colorUIResource5 = colorUIResource;
        InsetsUIResource insetsUIResource = new InsetsUIResource(0, 0, 0, 0);
        InsetsUIResource insetsUIResource2 = new InsetsUIResource(2, 2, 2, 2);
        BackdropBorder.UIResource uIResource = new BackdropBorder.UIResource(new PaletteButtonBorder());
        BackdropBorder.UIResource uIResource2 = new BackdropBorder.UIResource(new PaletteTextComponentBorder());
        Object[] objectArray = new Object[]{"SmallSystemFont", proxyLazyValue, "Button.font", proxyLazyValue2, "Button.background", colorUIResource2, "Button.foreground", colorUIResource3, "Button.border", uIResource, "Button.margin", insetsUIResource, "Button.background", colorUIResource2, "Button.foreground", colorUIResource3, "Button.border", uIResource, "Button.margin", insetsUIResource, "FormattedTextField.font", proxyLazyValue3, "FormattedTextField.background", colorUIResource2, "FormattedTextField.foreground", colorUIResource3, "FormattedTextField.border", uIResource2, "FormattedTextField.margin", insetsUIResource, "FormattedTextField.opaque", Boolean.TRUE, "FormattedTextField.errorIndicatorForeground", new ColorUIResource(16665153), "FormattedTextField.selectionBackground", colorUIResource4, "FormattedTextField.selectionForeground", colorUIResource5, "Label.font", proxyLazyValue2, "Ribbon.border", new UIDefaults.ProxyLazyValue("javax.swing.border.MatteBorder", new Object[]{new Insets(1, 0, 0, 0), new Color(0x777777)}), "ScrollPane.border", new UIDefaults.ProxyLazyValue("javax.swing.border.MatteBorder", new Object[]{new Insets(1, 1, 1, 1), new Color(0xA5A5A5)}), "Slider.background", colorUIResource2, "Slider.foreground", colorUIResource3, "Slider.horizontalSize", new DimensionUIResource(100, 20), "Slider.verticalSize", new DimensionUIResource(20, 100), "TextArea.selectionBackground", colorUIResource4, "TextArea.selectionForeground", colorUIResource5, "TextField.font", proxyLazyValue3, "TextField.background", colorUIResource2, "TextField.foreground", colorUIResource3, "TextField.border", uIResource2, "TextField.margin", insetsUIResource, "TextField.opaque", Boolean.TRUE, "TextField.selectionBackground", colorUIResource4, "TextField.selectionForeground", colorUIResource5, "ToolBar.font", proxyLazyValue2, "ToolBar.background", colorUIResource2, "ToolBar.foreground", colorUIResource3, "ToolBar.dockingBackground", colorUIResource2, "ToolBar.floatingBackground", colorUIResource2, "ToolBar.border", new UIDefaults.ProxyLazyValue("org.jhotdraw.gui.plaf.palette.PaletteToolBarBorder$UIResource")};
        uIDefaults.putDefaults(objectArray);
    }

    static Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }
}

