/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import MCview.Bond;
import MCview.PDBChain;
import jalview.AlignFrame;
import jalview.AlignmentPanel;
import jalview.BigPanel;
import jalview.Blosum62ColourScheme;
import jalview.ClustalxColourScheme;
import jalview.DrawableAlignment;
import jalview.DrawableSequence;
import jalview.FeatureFrame;
import jalview.MSFfile;
import jalview.PIDColourScheme;
import jalview.ResidueColourScheme;
import jalview.SeqCanvas;
import jalview.Sequence;
import jalview.SequenceFeature;
import jalview.SequenceGroup;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.io.IOException;

public class SeqPanel
extends Panel {
    protected AlignmentPanel alignPanel;
    public SeqCanvas seqCanvas;
    protected Scrollbar hscroll;
    protected Scrollbar vscroll;
    public DrawableAlignment align;
    protected int offx;
    protected int offy;
    protected int maxoffx;
    protected int maxoffy;
    protected int startres;
    protected int lastres;
    protected int endres;
    protected long lasttime;
    protected int startseq;
    protected int padseq;
    public boolean fastDraw;
    public boolean editFlag;

    public SeqPanel(AlignmentPanel alignmentPanel, DrawableSequence[] drawableSequenceArray) {
        this.alignPanel = alignmentPanel;
        this.align = new DrawableAlignment(drawableSequenceArray);
        System.out.println("Maximum sequence length = " + this.align.maxLength);
        System.out.println("No sequences  = " + this.align.size);
        this.setFastDraw(true);
        this.componentInit();
    }

    public void setFastDraw(boolean bl) {
        this.fastDraw = bl;
        int n = 0;
        while (n < this.align.ds.length && this.align.ds[n] != null) {
            this.align.ds[n].fastDraw = bl;
            ++n;
        }
    }

    private void componentInit() {
        this.seqCanvas = new SeqCanvas(this);
        this.hscroll = new Scrollbar(0);
        this.vscroll = new Scrollbar(1);
        this.setLayout(new BorderLayout());
        this.add("Center", this.seqCanvas);
        this.add("East", this.vscroll);
        this.add("South", this.hscroll);
        this.setScrollValues(0, 0);
        System.out.println("SeqPanel initialized");
    }

    public void setScrollValues(int n, int n2) {
        int n3;
        int n4;
        System.getProperty("java.version");
        if (this.seqCanvas.size().width > 0) {
            n4 = this.seqCanvas.size().width;
            n3 = this.seqCanvas.size().height;
        } else {
            n4 = this.seqCanvas.preferredSize().width;
            n3 = this.seqCanvas.preferredSize().height;
        }
        if (this.maxoffx != this.align.maxLength + 1) {
            this.maxoffx = this.align.maxLength + 1;
        }
        if (this.maxoffy != this.align.size + 1) {
            this.maxoffy = this.align.size + 1;
        }
        this.hscroll.setValues(n, n4 / this.seqCanvas.charWidth, 0, this.maxoffx);
        this.vscroll.setValues(n2, n3 / this.seqCanvas.charHeight, 0, this.maxoffy);
        this.hscroll.setLineIncrement(1);
        this.vscroll.setLineIncrement(1);
        if (this.seqCanvas.endx > 0) {
            this.hscroll.setPageIncrement((this.seqCanvas.endx - this.seqCanvas.startx) / 2);
            if (this.seqCanvas.endy - this.seqCanvas.starty > 2) {
                this.vscroll.setPageIncrement((this.seqCanvas.endy - this.seqCanvas.starty) / 2);
            }
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                if (event.target == this.hscroll) {
                    this.offx = this.hscroll.getValue();
                    this.alignPanel.scalePanel.scaleCanvas.paintFlag = true;
                    this.seqCanvas.repaint();
                    this.alignPanel.scalePanel.scaleCanvas.repaint();
                    return true;
                }
                if (event.target != this.vscroll) break;
                this.offy = this.vscroll.getValue();
                this.alignPanel.idPanel.idCanvas.paintFlag = true;
                this.seqCanvas.repaint();
                this.alignPanel.idPanel.idCanvas.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        Object object;
        int n3;
        int n4;
        if (this.editFlag && this.align.autoConsensus) {
            System.out.println("Auto consensus");
            this.align.percentIdentity();
            BigPanel bigPanel = ((AlignFrame)this.alignPanel.parent).bp;
            if (bigPanel.scorePanel != null) {
                bigPanel.scorePanel.seqPanel.align.ds[0] = this.align.qualityScore;
            }
            n4 = 0;
            n3 = 0;
            while (n3 < this.align.groups.size()) {
                object = (SequenceGroup)this.align.groups.elementAt(n3);
                if (((SequenceGroup)object).colourScheme instanceof ClustalxColourScheme) {
                    n4 = 1;
                    ((ClustalxColourScheme)((SequenceGroup)object).colourScheme).cons2 = this.align.cons2;
                    ((SequenceGroup)object).colourScheme.setColours((SequenceGroup)object);
                } else if (((SequenceGroup)object).colourScheme instanceof PIDColourScheme) {
                    ((SequenceGroup)object).colourScheme = new PIDColourScheme(this.align.cons);
                    ((SequenceGroup)object).colourScheme.setColours((SequenceGroup)object);
                    n4 = 1;
                } else if (((SequenceGroup)object).colourScheme instanceof Blosum62ColourScheme) {
                    ((Blosum62ColourScheme)((SequenceGroup)object).colourScheme).cons = this.align.cons;
                    ((SequenceGroup)object).colourScheme.setColours((SequenceGroup)object);
                    n4 = 1;
                } else if (((SequenceGroup)object).colourScheme instanceof ResidueColourScheme) {
                    ((ResidueColourScheme)((SequenceGroup)object).colourScheme).cons = this.align.cons;
                    n4 = 1;
                    if (((ResidueColourScheme)((SequenceGroup)object).colourScheme).colourThreshold > 0) {
                        ((SequenceGroup)object).colourScheme.setColours((SequenceGroup)object);
                    }
                }
                ++n3;
            }
            if (bigPanel.scorePanel != null) {
                bigPanel.scorePanel.seqPanel.seqCanvas.paintFlag = true;
                bigPanel.scorePanel.seqPanel.seqCanvas.repaint();
            }
            if (n4 != 0) {
                this.seqCanvas.paintFlag = true;
                this.seqCanvas.repaint();
            }
        }
        try {
            int n5 = n / this.seqCanvas.charWidth + this.seqCanvas.startx;
            n4 = this.seqCanvas.getIndex(n2);
            System.out.println("Y = " + n2 + " " + n4 + " " + this.align.ds[n4].name);
            this.align.ds[n4].charAt(n5);
            this.endres = n5;
            n3 = this.align.ds[n4].findPosition(n5);
            if (this.alignPanel.parent instanceof AlignFrame && !this.editFlag) {
                object = (AlignFrame)this.alignPanel.parent;
                if (this.align.ds[n4].features != null && this.align.ds[n4].features.size() > 0) {
                    String string = "";
                    string = String.valueOf(string) + "No of features for " + this.align.ds[n4].name + " = " + this.align.ds[n4].features.size() + "\n\n";
                    string = String.valueOf(string) + "------------------------------------------------\n";
                    string = String.valueOf(string) + "Selected features for residue " + n3 + " (" + n5 + " in alignment) : \n\n";
                    if (((AlignFrame)object).ff == null) {
                        ((AlignFrame)object).ff = new FeatureFrame(object, "Sequence feature console", 15, 72, "");
                        ((AlignFrame)object).ff.setTextFont(new Font("Courier", 0, 12));
                        ((AlignFrame)object).ff.resize(500, 400);
                        ((AlignFrame)object).ff.show();
                    }
                    int n6 = 0;
                    while (n6 < this.align.ds[n4].features.size()) {
                        SequenceFeature sequenceFeature = (SequenceFeature)this.align.ds[n4].features.elementAt(n6);
                        if (n3 >= sequenceFeature.start && n3 <= sequenceFeature.end) {
                            string = String.valueOf(string) + sequenceFeature.print() + "\n";
                        }
                        ++n6;
                    }
                    string = String.valueOf(string) + "\n------------------------------------------------\n";
                    string = String.valueOf(string) + "All features : \n\n";
                    int n7 = 0;
                    while (n7 < this.align.ds[n4].features.size()) {
                        SequenceFeature sequenceFeature = (SequenceFeature)this.align.ds[n4].features.elementAt(n7);
                        string = String.valueOf(string) + sequenceFeature.print() + "\n";
                        ((AlignFrame)object).ff.setText(string);
                        ++n7;
                    }
                }
            }
            this.editFlag = false;
            this.startseq = -1;
            this.startres = -1;
            this.lastres = -1;
        }
        catch (Exception exception) {}
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3 = n / this.seqCanvas.charWidth + this.seqCanvas.startx;
        int n4 = n2 / this.seqCanvas.charHeight + this.seqCanvas.starty;
        if (n4 < this.align.size() && n3 < this.align.maxLength && n3 >= 0) {
            char c = this.align.ds[n4].charAt(n3);
            int n5 = this.align.ds[n4].findPosition(n3);
            this.startseq = n4;
            this.padseq = this.startseq == this.align.size() - 1 ? 1 : 1;
            this.startres = n3;
            this.lastres = n3;
            if (this.align.ds[n4].pdb != null) {
                PDBChain pDBChain = (PDBChain)this.align.ds[n4].pdb.chains.elementAt(this.align.ds[n4].maxchain);
                int n6 = n5 - this.align.ds[n4].seqstart + this.align.ds[n4].pdbstart + pDBChain.offset - 1;
                int n7 = 0;
                while (n7 < pDBChain.bonds.size()) {
                    if (((Bond)pDBChain.bonds.elementAt((int)n7)).at1.resNumber == n6) {
                        ((Bond)pDBChain.bonds.elementAt((int)n7)).at1.isSelected = true;
                    }
                    if (((Bond)pDBChain.bonds.elementAt((int)n7)).at2.resNumber == n6) {
                        ((Bond)pDBChain.bonds.elementAt((int)n7)).at2.isSelected = true;
                    }
                    ++n7;
                }
            }
            if (this.alignPanel.parent instanceof AlignFrame) {
                ((AlignFrame)this.alignPanel.parent).status.setText("Sequence ID : " + this.align.ds[n4].getName() + " (" + n4 + ") Residue = " + c + " (" + n5 + ") ");
            }
        } else {
            this.startseq = -1;
            this.startres = -1;
            this.lastres = -1;
        }
        return false;
    }

    public void drawChars(int n, int n2, int n3, int n4) {
        this.seqCanvas.drawPanel(this.seqCanvas.getGraphics(), n3, n4, n, n2);
        this.seqCanvas.drawPanel(this.seqCanvas.gg, n3, n4, n, n2);
        this.alignPanel.scalePanel.scaleCanvas.repaint();
    }

    public void insertChar(int n, int n2) {
        this.align.sequences[n2].insertCharAt(n, this.align.gapCharacter.charAt(0));
        this.align.maxLength();
        this.align.ds[n2].sequence.length();
        this.setScrollValues(this.offx, this.offy);
    }

    public void deleteChar(int n, int n2, int n3) {
        if (this.align.ds[n3].sequence.substring(n, n + 1).equals(".") || this.align.ds[n3].sequence.substring(n, n + 1).equals("-") || this.align.ds[n3].sequence.substring(n, n + 1).equals(" ")) {
            this.align.ds[n3].deleteCharAt(n);
        }
        this.align.maxLength();
        this.setScrollValues(this.offx, this.offy);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.editFlag = true;
        int n3 = n / this.seqCanvas.charWidth + this.seqCanvas.startx;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 != this.lastres && this.startseq != -1) {
            this.align.ds[this.startseq].charAt(n3);
            if (this.alignPanel.groupEdit) {
                int n4;
                int n5;
                SequenceGroup sequenceGroup = this.align.findGroup(this.startseq);
                if (n3 < this.align.maxLength && n3 < this.lastres) {
                    n5 = 0;
                    int n6 = 0;
                    while (n6 < sequenceGroup.sequences.size()) {
                        DrawableSequence drawableSequence = (DrawableSequence)sequenceGroup.sequences.elementAt(n6);
                        n4 = this.lastres - 1;
                        while (n4 >= n3) {
                            if (!(n5 != 0 || drawableSequence.sequence.substring(n4, n4 + 1).equals("-") || drawableSequence.sequence.substring(n4, n4 + 1).equals(".") || drawableSequence.sequence.substring(n4, n4 + 1).equals(" "))) {
                                n3 = n4 + 1;
                                System.out.print("\u0007");
                                System.out.flush();
                                n5 = 1;
                            }
                            --n4;
                        }
                        ++n6;
                    }
                }
                n5 = 0;
                while (n5 < sequenceGroup.sequences.size()) {
                    DrawableSequence drawableSequence = (DrawableSequence)sequenceGroup.sequences.elementAt(n5);
                    boolean bl = false;
                    n4 = -1;
                    int n7 = 0;
                    while (n7 < this.align.ds.length) {
                        if (this.align.ds[n7] == drawableSequence) {
                            bl = true;
                            n4 = n7;
                            break;
                        }
                        ++n7;
                    }
                    if (bl && n4 != -1) {
                        int n8;
                        int n9;
                        if (n3 < this.align.maxLength && n3 > this.lastres) {
                            n9 = this.lastres;
                            while (n9 < n3) {
                                this.insertChar(n9, n4);
                                ++n9;
                            }
                            n8 = this.align.findIndex(drawableSequence);
                            if (n8 != -1) {
                                this.drawChars(n8, n8 + 1, this.lastres, this.align.maxLength);
                            }
                        } else if (n3 < this.align.maxLength && n3 < this.lastres) {
                            n9 = n3;
                            while (n9 < this.lastres) {
                                this.deleteChar(n9, n3, n4);
                                this.startres = n3;
                                ++n9;
                            }
                            n8 = this.align.findIndex(drawableSequence);
                            if (n8 != -1) {
                                this.drawChars(n8, n8 + 1, n3, this.align.maxLength);
                            }
                        }
                    }
                    ++n5;
                }
                this.lastres = n3;
            } else if (n3 < this.align.maxLength && n3 > this.lastres) {
                int n10 = this.lastres;
                while (n10 < n3) {
                    this.insertChar(n10, this.startseq);
                    ++n10;
                }
                this.drawChars(this.startseq, this.startseq + 1, this.lastres, this.align.maxLength);
            } else if (n3 < this.align.maxLength && n3 < this.lastres) {
                int n11 = n3;
                while (n11 < this.lastres) {
                    this.deleteChar(n11, n3, this.startseq);
                    this.startres = n3;
                    ++n11;
                }
                this.drawChars(this.startseq, this.startseq + 1, n3, this.align.maxLength);
            }
        }
        this.lastres = n3;
        return false;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.setScrollValues(this.offx, this.offy);
    }

    public Dimension minimumSize() {
        return new Dimension(700, 500);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("SeqPanel");
        DrawableSequence[] drawableSequenceArray = null;
        try {
            MSFfile mSFfile = new MSFfile("pog.msf", "File");
            int n = 0;
            while (n < mSFfile.seqs.size()) {
                drawableSequenceArray[n] = new DrawableSequence((Sequence)mSFfile.seqs.elementAt(n));
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception : " + iOException);
        }
        if (drawableSequenceArray != null) {
            SeqPanel seqPanel = new SeqPanel(null, drawableSequenceArray);
            frame.add(seqPanel);
            frame.resize(700, 500);
            frame.show();
        }
    }
}

