/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.errors;

import com.almworks.tracklink.util.StringBundle;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class ErrorReporter
extends ErrorReportSubmitter {
    private static final String FEEDBACK_URL = "http://almworks.com/sendfeedback.html";
    private static final int TIMEOUT = 30000;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";

    public String getReportActionText() {
        return StringBundle.get("errorReporter.actionText", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmittedReportInfo submit(IdeaLoggingEvent[] events, Component parentComponent) {
        OutputStream out = null;
        InputStream in = null;
        try {
            String content = "productName=TrackLink&productBuildNumber= " + URLEncoder.encode(StringBundle.get("plugin.build", new Object[0])) + "&messageDescription=" + URLEncoder.encode(events[0].getMessage()) + "&messageBody=" + URLEncoder.encode(events[0].getThrowableText());
            byte[] bytes = content.getBytes("UTF-8");
            URLConnection connection = new URL(FEEDBACK_URL).openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setRequestProperty(CONTENT_TYPE, CONTENT_TYPE_FORM);
            out = connection.getOutputStream();
            out.write(bytes);
            in = connection.getInputStream();
            in.read();
            SubmittedReportInfo submittedReportInfo = new SubmittedReportInfo(null, null, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
            return submittedReportInfo;
        }
        catch (IOException e) {
            SubmittedReportInfo submittedReportInfo = new SubmittedReportInfo(null, e.getLocalizedMessage(), SubmittedReportInfo.SubmissionStatus.FAILED);
            return submittedReportInfo;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

