/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.config.DirectoryValidator;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class FileUtils {
    public static final char[] INVALID_CHARS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|', '[', ']', '\'', ';', '=', ','};
    private static final char SANITIZED_CHAR = '_';

    public static String sanitizePath(String path) {
        return FileUtils.sanitizePath(path, '_');
    }

    public static String sanitizePath(String path, char substitute) {
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            if (INVALID_CHARS[i] == File.separatorChar || -1 == path.indexOf(INVALID_CHARS[i])) continue;
            path = path.replace(INVALID_CHARS[i], substitute);
        }
        return path;
    }

    public static String sanitizeFileName(String filename) {
        return FileUtils.sanitizeFileName(filename, '_');
    }

    public static String sanitizeFileName(String filename, char substitute) {
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            if (-1 == filename.indexOf(INVALID_CHARS[i])) continue;
            filename = filename.replace(INVALID_CHARS[i], substitute);
        }
        return filename;
    }

    public static void createRestrictedDirectory(File directory) throws IOException {
        FileUtils.createRestrictedFile(directory, true, true);
    }

    public static void createRestrictedFile(File file, boolean writableByOwner) throws IOException {
        FileUtils.createRestrictedFile(file, false, writableByOwner);
    }

    public static void createParentDir(File f, String eMsg) throws IOException {
        File parent = f.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException(Translator.R("RCantCreateDir", eMsg == null ? parent : eMsg));
        }
    }

    public static void createParentDir(File f) throws IOException {
        FileUtils.createParentDir(f, null);
    }

    public static void deleteWithErrMesg(File f, String eMsg) {
        if (f.exists() && !f.delete()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RCantDeleteFile", eMsg == null ? f : eMsg));
        }
    }

    public static void deleteWithErrMesg(File f) {
        FileUtils.deleteWithErrMesg(f, null);
    }

    private static void createRestrictedFile(File file, boolean isDir, boolean writableByOwner) throws IOException {
        File tempFile = new File(file.getCanonicalPath() + ".temp");
        if (isDir) {
            if (!tempFile.mkdir()) {
                throw new IOException(Translator.R("RCantCreateDir", tempFile));
            }
        } else if (!tempFile.createNewFile()) {
            throw new IOException(Translator.R("RCantCreateFile", tempFile));
        }
        if (JNLPRuntime.isWindows()) {
            if (!tempFile.setExecutable(false, false)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RRemoveXPermFailed", tempFile));
            }
            if (!tempFile.setReadable(false, false)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RRemoveRPermFailed", tempFile));
            }
            if (!tempFile.setWritable(false, false)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RRemoveWPermFailed", tempFile));
            }
            if (!tempFile.setReadable(true, true)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RGetRPermFailed", tempFile));
            }
            if (writableByOwner && !tempFile.setWritable(true, true)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RGetWPermFailed", tempFile));
            }
            if (isDir && !tempFile.setExecutable(true, true)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RGetXPermFailed", tempFile));
            }
            if (!tempFile.renameTo(file)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RCantRename", tempFile, file));
            }
        } else {
            if (!tempFile.setExecutable(false, false)) {
                throw new IOException(Translator.R("RRemoveXPermFailed", tempFile));
            }
            if (!tempFile.setReadable(false, false)) {
                throw new IOException(Translator.R("RRemoveRPermFailed", tempFile));
            }
            if (!tempFile.setWritable(false, false)) {
                throw new IOException(Translator.R("RRemoveWPermFailed", tempFile));
            }
            if (!tempFile.setReadable(true, true)) {
                throw new IOException(Translator.R("RGetRPermFailed", tempFile));
            }
            if (writableByOwner && !tempFile.setWritable(true, true)) {
                throw new IOException(Translator.R("RGetWPermFailed", tempFile));
            }
            if (isDir && !tempFile.setExecutable(true, true)) {
                throw new IOException(Translator.R("RGetXPermFailed", tempFile));
            }
            if (!tempFile.renameTo(file)) {
                throw new IOException(Translator.R("RCantRename", tempFile, file));
            }
        }
    }

    public static DirectoryValidator.DirectoryCheckResults testDirectoryPermissions(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
            return null;
        }
        if (file == null || file.getParentFile() == null || !file.getParentFile().exists()) {
            return null;
        }
        ArrayList<File> policyDirectory = new ArrayList<File>();
        policyDirectory.add(file.getParentFile());
        DirectoryValidator validator = new DirectoryValidator(policyDirectory);
        DirectoryValidator.DirectoryCheckResults result = validator.ensureDirs();
        return result;
    }

    public static OpenFileResult testFilePermissions(File file) {
        if (file == null || !file.exists()) {
            return OpenFileResult.FAILURE;
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            return OpenFileResult.FAILURE;
        }
        DirectoryValidator.DirectoryCheckResults dcr = FileUtils.testDirectoryPermissions(file);
        if (dcr != null && dcr.getFailures() == 0) {
            if (file.isDirectory()) {
                return OpenFileResult.NOT_FILE;
            }
            try {
                if (!file.exists() && !file.createNewFile()) {
                    return OpenFileResult.CANT_CREATE;
                }
            }
            catch (IOException e) {
                return OpenFileResult.CANT_CREATE;
            }
            boolean read = file.canRead();
            boolean write = file.canWrite();
            if (read && write) {
                return OpenFileResult.SUCCESS;
            }
            if (read) {
                return OpenFileResult.CANT_WRITE;
            }
            return OpenFileResult.FAILURE;
        }
        return OpenFileResult.FAILURE;
    }

    public static void showReadOnlyDialog(final Component frame) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(frame, Translator.R("RFileReadOnly"), Translator.R("Warning"), 2);
            }
        });
    }

    public static void showCouldNotOpenFilepathDialog(Component frame, String filePath) {
        FileUtils.showCouldNotOpenDialog(frame, Translator.R("RCantOpenFile", filePath));
    }

    public static void showCouldNotOpenFileDialog(Component frame, String filePath, OpenFileResult reason) {
        String message;
        switch (reason) {
            case CANT_CREATE: {
                message = Translator.R("RCantCreateFile", filePath);
                break;
            }
            case CANT_WRITE: {
                message = Translator.R("RCantWriteFile", filePath);
                break;
            }
            case NOT_FILE: {
                message = Translator.R("RExpectedFile", filePath);
                break;
            }
            default: {
                message = Translator.R("RCantOpenFile", filePath);
            }
        }
        FileUtils.showCouldNotOpenDialog(frame, message);
    }

    public static void showCouldNotOpenDialog(final Component frame, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(frame, message, Translator.R("Error"), 0);
            }
        });
    }

    public static String displayablePath(String path) {
        int DEFAULT_LENGTH = 40;
        return FileUtils.displayablePath(path, 40);
    }

    public static String displayablePath(String path, int visibleChars) {
        if (path == null || path.length() <= visibleChars) {
            return path;
        }
        String OMITTED = "...";
        int OMITTED_LENGTH = "...".length();
        int MIN_PREFIX_LENGTH = 4;
        int MIN_SUFFIX_LENGTH = 4;
        if (visibleChars < OMITTED_LENGTH + 4 + 4) {
            return path.substring(path.length() - visibleChars);
        }
        int affixLength = (visibleChars - OMITTED_LENGTH) / 2;
        String prefix = path.substring(0, affixLength);
        String suffix = path.substring(path.length() - affixLength);
        return prefix + "..." + suffix;
    }

    public static void recursiveDelete(File file, File base) throws IOException {
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Deleting: " + file);
        if (!file.getCanonicalPath().startsWith(base.getCanonicalPath())) {
            throw new IOException("Trying to delete a file outside Netx's basedir: " + file.getCanonicalPath());
        }
        if (file.isDirectory()) {
            File[] children;
            for (File children1 : children = file.listFiles()) {
                FileUtils.recursiveDelete(children1, base);
            }
        }
        if (!file.delete()) {
            throw new IOException("Unable to delete file: " + file);
        }
    }

    public static FileLock getFileLock(String path, boolean shared, boolean allowBlock) throws FileNotFoundException {
        RandomAccessFile rafFile = new RandomAccessFile(path, "rw");
        FileChannel fc = rafFile.getChannel();
        FileLock lock = null;
        try {
            if (!shared) {
                lock = allowBlock ? fc.lock(0L, Long.MAX_VALUE, false) : fc.tryLock(0L, Long.MAX_VALUE, false);
            } else {
                lock = fc.lock(0L, 1L, true);
                if (!lock.isShared()) {
                    FileLock tempLock = null;
                    for (long pos = 1L; tempLock == null && pos < 0x7FFFFFFFFFFFFFFEL; ++pos) {
                        tempLock = fc.tryLock(pos, 1L, false);
                    }
                    lock.release();
                    lock = tempLock;
                }
            }
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        return lock;
    }

    public static void saveFile(String content, File f) throws IOException {
        FileUtils.saveFile(content, f, "utf-8");
    }

    public static void saveFile(String content, File f, String encoding) throws IOException {
        try (BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding));){
            output.write(content);
            ((Writer)output).flush();
        }
    }

    public static String getContentOfStream(InputStream is, String encoding) throws IOException {
        try {
            String string = FileUtils.getContentOfReader(new InputStreamReader(is, encoding));
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentOfReader(Reader r) throws IOException {
        try {
            String s;
            BufferedReader br = new BufferedReader(r);
            StringBuilder sb = new StringBuilder();
            while ((s = br.readLine()) != null) {
                sb.append(s).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            r.close();
        }
    }

    public static String getContentOfStream(InputStream is) throws IOException {
        return FileUtils.getContentOfStream(is, "UTF-8");
    }

    public static String loadFileAsString(File f) throws IOException {
        return FileUtils.getContentOfStream(new FileInputStream(f));
    }

    public static String loadFileAsString(File f, String encoding) throws IOException {
        return FileUtils.getContentOfStream(new FileInputStream(f), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileMD5Sum(File file, String algorithm) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        MessageDigest md5;
        InputStream is = null;
        FilterInputStream dis = null;
        try {
            md5 = MessageDigest.getInstance(algorithm);
            is = new FileInputStream(file);
            dis = new DigestInputStream(is, md5);
            md5.update(FileUtils.getContentOfStream(dis).getBytes());
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (dis != null) {
                dis.close();
            }
        }
        return md5.digest();
    }

    public static enum OpenFileResult {
        SUCCESS,
        FAILURE,
        CANT_CREATE,
        CANT_WRITE,
        NOT_FILE;

    }
}

