/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.vcardavatar;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class VCardTempXUpdatePresenceExtension
implements ExtensionElement {
    public static final String ELEMENT = "x";
    public static final String NAMESPACE = "vcard-temp:x:update";
    private String imageSha1 = null;
    private CharSequence xmlString = null;

    public VCardTempXUpdatePresenceExtension(byte[] imageBytes) {
        this.computeXML();
        this.updateImage(imageBytes);
    }

    public boolean updateImage(byte[] imageBytes) {
        boolean isImageUpdated = false;
        String tmpImageSha1 = VCardTempXUpdatePresenceExtension.getImageSha1(imageBytes);
        if (!Objects.equals(tmpImageSha1, this.imageSha1)) {
            this.imageSha1 = tmpImageSha1;
            this.computeXML();
            isImageUpdated = true;
        }
        return isImageUpdated;
    }

    public static String getImageSha1(byte[] image) {
        String imageSha1 = null;
        try {
            if (image != null) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                imageSha1 = StringUtils.encodeHex(messageDigest.digest(image));
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return imageSha1;
    }

    private void computeXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.halfOpenElement(this.getElementName()).xmlnsAttribute(this.getNamespace()).rightAngleBracket();
        if (this.imageSha1 == null) {
            xml.emptyElement("photo");
        } else {
            xml.element("photo", this.imageSha1);
        }
        xml.closeElement(this.getElementName());
        this.xmlString = xml;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        return this.xmlString;
    }
}

