/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.console.r;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.heapviewer.console.r.Bundle;
import org.graalvm.visualvm.heapviewer.console.r.CustomRQueries;
import org.graalvm.visualvm.heapviewer.console.r.RQueryCustomizer;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.windows.WindowManager;

final class RQueries {
    private static final Icon ICON_PROGRESS = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)(RQueries.class.getPackage().getName().replace('.', '/') + "/progress.png"), (boolean)true));
    static final Icon ICON_LOAD = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)(RQueries.class.getPackage().getName().replace('.', '/') + "/rLoad.png"), (boolean)true));
    static final Icon ICON_SAVE = Icons.getIcon((String)"GeneralIcons.Save");
    private static final Icon ICON_EMPTY = Icons.getIcon((String)"GeneralIcons.Empty");
    private static final int EXTERNAL_QUERIES_CACHE = 5;
    private static RQueries INSTANCE;
    private CustomRQueries customQueries;
    private List<Query> externalQueries;
    private JPopupMenu tempPopup;
    private Query tempCurrentQuery;
    private String tempQueryText;
    private Handler tempHandler;
    private boolean tempLoad;
    private File lastDirectory;

    public static synchronized RQueries instance() {
        if (INSTANCE == null) {
            INSTANCE = new RQueries();
        }
        return INSTANCE;
    }

    public void populateLoadQuery(JPopupMenu popup, Query currentQuery, final Handler handler) {
        if (this.customQueries == null) {
            JMenuItem progressItem = new JMenuItem(Bundle.RQueries_LoadingProgress(), ICON_PROGRESS);
            progressItem.setEnabled(false);
            popup.add(progressItem);
            this.tempPopup = popup;
            this.tempCurrentQuery = currentQuery;
            this.tempHandler = handler;
            this.tempLoad = true;
            return;
        }
        this.tempPopup = null;
        this.tempCurrentQuery = null;
        this.tempQueryText = null;
        this.tempHandler = null;
        popup.add(new PopupSeparator(Bundle.RQueries_PopupLoadCustomScript()));
        if (this.customQueries.isEmpty()) {
            Iterator<Query> noItems = new JMenuItem(Bundle.RQueries_PopupNoSaved(), ICON_EMPTY);
            ((JMenuItem)((Object)noItems)).setEnabled(false);
            popup.add((JMenuItem)((Object)noItems));
        } else {
            for (Query query : this.customQueries.list()) {
                popup.add(new QueryMenuItem(query, currentQuery, ICON_LOAD, null, handler));
            }
        }
        popup.add(new PopupSpacer(5));
        popup.add(new PopupSeparator(Bundle.RQueries_PopupLoadExternalScript()));
        popup.add(new JMenuItem(Bundle.RQueries_PopupLoadFromFile(), ICON_EMPTY){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RQueries.this.loadFromFile(handler);
                    }
                });
            }
        });
        if (this.externalQueries != null && !this.externalQueries.isEmpty()) {
            popup.add(new PopupSpacer(5));
            for (Query query : this.externalQueries) {
                popup.add(new QueryMenuItem(query, currentQuery, ICON_LOAD, null, handler));
            }
        }
        popup.add(new PopupSpacer(5));
        popup.add(new PopupSeparator(Bundle.RQueries_PopupLoadSampleScript()));
        String script1 = "grid.rect(width = 0.5, height = 0.45, gp=gpar(col=\"blue\",lwd=3))\ngrid.circle(x = 0.5, y = 0.5, r = 0.45, gp=gpar(col=\"red\",lwd=10))\ngrid.text(\"Box and Circle\")";
        Query sample1 = new Query(script1, "Simple Graphics", "Sample script drawing blue rectangle and red circle");
        popup.add(new QueryMenuItem(sample1, currentQuery, ICON_LOAD, null, handler));
        String script2 = "s<-HeapClasses[order(HeapClasses$Instances,decreasing=TRUE),];\nx<-s[1:15,];\nprint(x);";
        Query sample2 = new Query(script2, "Classes by Instances Count", "Sorts classes by number of instances and displays first 15 rows");
        popup.add(new QueryMenuItem(sample2, currentQuery, ICON_LOAD, null, handler));
    }

    public void populateSaveQuery(JPopupMenu popup, final Query currentQuery, final String queryText, final Handler handler) {
        if (this.customQueries == null) {
            JMenuItem progressItem = new JMenuItem(Bundle.RQueries_PopupLoadingScripts(), ICON_PROGRESS);
            progressItem.setEnabled(false);
            popup.add(progressItem);
            this.tempPopup = popup;
            this.tempCurrentQuery = currentQuery;
            this.tempQueryText = queryText;
            this.tempHandler = handler;
            this.tempLoad = false;
            return;
        }
        this.tempPopup = null;
        this.tempCurrentQuery = null;
        this.tempQueryText = null;
        this.tempHandler = null;
        popup.add(new PopupSeparator(Bundle.RQueries_PopupSaveCustomScript()));
        popup.add(new JMenuItem(Bundle.RQueries_PopupSaveNew(), ICON_EMPTY){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                Query query = RQueryCustomizer.saveCustomizer(currentQuery, queryText);
                if (query == null) {
                    return;
                }
                String name = query.getName();
                int nameExt = 0;
                while (RQueries.containsQuery(RQueries.this.customQueries.list(), query)) {
                    query.setName(name + " " + ++nameExt);
                }
                RQueries.this.customQueries.add(query);
                if (handler != null) {
                    handler.querySelected(query);
                }
            }
        });
        if (!this.customQueries.isEmpty()) {
            popup.add(new PopupSpacer(5));
            for (final Query query : this.customQueries.list()) {
                popup.add(new QueryMenuItem(query, currentQuery, ICON_SAVE, null, handler){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        query.setScript(queryText);
                        RQueries.this.customQueries.save(query);
                        super.fireActionPerformed(e);
                    }
                });
            }
        }
        popup.add(new PopupSpacer(5));
        popup.add(new PopupSeparator(Bundle.RQueries_PopupSaveExternalScript()));
        popup.add(new JMenuItem(Bundle.RQueries_PopupSaveFile(), ICON_EMPTY){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RQueries.this.saveToFile(currentQuery, queryText, handler);
                    }
                });
            }
        });
        if (this.externalQueries != null && !this.externalQueries.isEmpty()) {
            popup.add(new PopupSpacer(5));
            for (final Query query : this.externalQueries) {
                popup.add(new QueryMenuItem(query, currentQuery, ICON_SAVE, null, handler){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        query.setScript(queryText);
                        RQueries.this.saveToQuery(query, null);
                        super.fireActionPerformed(e);
                    }
                });
            }
        }
    }

    public void populateEditQuery(JPopupMenu popup, Query currentQuery) {
        if (this.customQueries == null) {
            JMenuItem progressItem = new JMenuItem(Bundle.RQueries_PopupLoadingScripts(), ICON_PROGRESS);
            progressItem.setEnabled(false);
            popup.add(progressItem);
            return;
        }
        if (this.customQueries.isEmpty()) {
            JMenuItem emptyItem = new JMenuItem(Bundle.RQueries_PopupNoCustom());
            emptyItem.setEnabled(false);
            popup.add(emptyItem);
            return;
        }
        for (final Query query : this.customQueries.list()) {
            JMenu queryM = new JMenu(QueryMenuItem.getName(query, currentQuery, null)){

                @Override
                protected void fireStateChanged() {
                    boolean active = this.isSelected() || this.isArmed();
                    StatusDisplayer.getDefault().setStatusText(active ? query.getDescription() : null);
                    super.fireStateChanged();
                }
            };
            popup.add(queryM);
            queryM.add(new JMenuItem(Bundle.RQueries_PopupEditCustom()){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List<Query> l = RQueries.this.customQueries.list();
                            for (Query q : l) {
                                if (!RQueries.sameQuery(query, q)) continue;
                                Query qq = RQueryCustomizer.editCustomizer(query, "");
                                if (qq == null) {
                                    return;
                                }
                                q.setName(qq.getName());
                                q.setDescription(qq.getDescription());
                                RQueries.this.customQueries.set(l);
                                break;
                            }
                        }
                    });
                }
            });
            queryM.add(new JMenuItem(Bundle.RQueries_PopupDeleteCustom()){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List<Query> l = RQueries.this.customQueries.list();
                            Iterator<Query> i = l.iterator();
                            while (i.hasNext()) {
                                if (!RQueries.sameQuery(query, i.next())) continue;
                                i.remove();
                                RQueries.this.customQueries.set(l);
                                break;
                            }
                        }
                    });
                }
            });
        }
        popup.addSeparator();
        popup.add(new JMenuItem(Bundle.RQueries_PopupDeleteAllCustom()){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                RQueries.this.customQueries.set(Collections.emptyList());
            }
        });
    }

    private void loadAllQueries() {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                RQueries.this.customQueries = CustomRQueries.instance();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (RQueries.this.tempPopup != null && RQueries.this.tempPopup.isShowing()) {
                            JPopupMenu popup = RQueries.this.tempPopup;
                            popup.removeAll();
                            if (RQueries.this.tempLoad) {
                                RQueries.this.populateLoadQuery(popup, RQueries.this.tempCurrentQuery, RQueries.this.tempHandler);
                            } else {
                                RQueries.this.populateSaveQuery(popup, RQueries.this.tempCurrentQuery, RQueries.this.tempQueryText, RQueries.this.tempHandler);
                            }
                            popup.pack();
                        }
                    }
                });
            }
        });
    }

    private void loadFromFile(final Handler handler) {
        JFileChooser chooser = new JFileChooser();
        if (this.lastDirectory != null) {
            chooser.setCurrentDirectory(this.lastDirectory);
        }
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(Bundle.RQueries_LoadExternalCaption());
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fname = f.getName().toLowerCase(Locale.ENGLISH);
                return fname.endsWith(".r") || fname.endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return Bundle.RQueries_RFileFilter("*.r, *.txt");
            }
        });
        if (chooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            final File file = chooser.getSelectedFile();
            this.lastDirectory = file.getParentFile();
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!file.isFile() || !file.canRead()) {
                            ProfilerDialogs.displayError((String)Bundle.RQueries_InvalidScript());
                            return;
                        }
                        String script = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                        String name = file.getName();
                        String description = file.getAbsolutePath();
                        final Query query = new Query(script, name, description);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                handler.querySelected(query);
                                if (RQueries.this.externalQueries == null) {
                                    RQueries.this.externalQueries = new ArrayList(5);
                                }
                                if (RQueries.containsQuery(RQueries.this.externalQueries, query)) {
                                    return;
                                }
                                if (RQueries.this.externalQueries.size() == 5) {
                                    RQueries.this.externalQueries.remove(RQueries.this.externalQueries.size() - 1);
                                }
                                RQueries.this.externalQueries.add(0, query);
                            }
                        });
                    }
                    catch (IOException ex) {
                        ProfilerDialogs.displayError((String)Bundle.RQueries_LoadFailed());
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    private void saveToFile(Query query, String queryText, Handler handler) {
        String descr;
        File defaultFile;
        JFileChooser chooser = new JFileChooser();
        if (query == null) {
            String name = "query.r";
            String descr2 = this.lastDirectory == null ? null : new File(this.lastDirectory, name).getPath();
            query = new Query(queryText, name, descr2);
        }
        File file = defaultFile = (descr = query.getDescription()) == null ? null : new File(descr);
        if (defaultFile != null && defaultFile.isFile()) {
            chooser.setSelectedFile(defaultFile);
        } else {
            defaultFile = this.lastDirectory == null ? new File(query.getName()) : new File(this.lastDirectory, query.getName());
            if (this.lastDirectory != null) {
                chooser.setCurrentDirectory(this.lastDirectory);
            }
            chooser.setSelectedFile(defaultFile);
        }
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(Bundle.RQueries_SaveExternalCaption());
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fname = f.getName().toLowerCase(Locale.ENGLISH);
                return fname.endsWith(".r") || fname.endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return Bundle.RQueries_RFileFilter("*.r, *.txt");
            }
        });
        if (chooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            File file2 = chooser.getSelectedFile();
            this.lastDirectory = file2.getParentFile();
            String fname = file2.getName().toLowerCase(Locale.ENGLISH);
            if (!fname.endsWith(".r") && !fname.endsWith(".txt")) {
                file2 = new File(file2.getParentFile(), file2.getName() + ".r");
            }
            String script = query.getScript();
            String name = file2.getName();
            String description = file2.getAbsolutePath();
            this.saveToQuery(new Query(script, name, description), handler);
        }
    }

    private void saveToQuery(final Query query, final Handler handler) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(query.getDescription());
                    if (file.isFile() && !file.canWrite()) {
                        ProfilerDialogs.displayError((String)Bundle.RQueries_InvalidScript());
                        return;
                    }
                    Files.write(file.toPath(), query.getScript().getBytes(), new OpenOption[0]);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (handler != null) {
                                handler.querySelected(query);
                            }
                            if (RQueries.this.externalQueries == null) {
                                RQueries.this.externalQueries = new ArrayList(5);
                            }
                            if (RQueries.containsQuery(RQueries.this.externalQueries, query)) {
                                return;
                            }
                            if (RQueries.this.externalQueries.size() == 5) {
                                RQueries.this.externalQueries.remove(RQueries.this.externalQueries.size() - 1);
                            }
                            RQueries.this.externalQueries.add(0, query);
                        }
                    });
                }
                catch (IOException ex) {
                    ProfilerDialogs.displayError((String)Bundle.RQueries_SaveFailed());
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private static boolean sameQuery(Query query1, Query query2) {
        if (query1 == null || query2 == null) {
            return false;
        }
        return query1.getName().equals(query2.getName());
    }

    private static boolean containsQuery(List<Query> queries, Query query) {
        for (Query q : queries) {
            if (!RQueries.sameQuery(q, query)) continue;
            return true;
        }
        return false;
    }

    private RQueries() {
        this.loadAllQueries();
    }

    public static final class Query {
        private String script;
        private String name;
        private String description;

        public Query(String script, String name, String description) {
            this.setScript(script);
            this.setName(name);
            this.setDescription(description);
        }

        public void setScript(String script) {
            if (script == null) {
                throw new IllegalArgumentException("Script cannot be null");
            }
            this.script = script;
        }

        public String getScript() {
            return this.script;
        }

        public void setName(String name) {
            this.name = Query.normalizeString(name);
            if (this.name == null) {
                throw new IllegalArgumentException("Name cannot be null");
            }
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String description) {
            this.description = Query.normalizeString(description);
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private static String normalizeString(String string) {
            String normalizedString = null;
            if (string != null && (normalizedString = string.trim()).isEmpty()) {
                normalizedString = null;
            }
            return normalizedString;
        }
    }

    private static class QueryMenuItem
    extends JMenuItem {
        private final Query query;
        private final Icon icon;
        private final Handler handler;

        QueryMenuItem(Query query, Query current, Icon icon, JMenu owner, Handler handler) {
            super(QueryMenuItem.getName(query, current, owner), ICON_EMPTY);
            this.query = query;
            this.icon = icon;
            this.handler = handler;
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            super.fireActionPerformed(e);
            if (this.handler != null) {
                this.handler.querySelected(this.query);
            }
        }

        @Override
        protected void fireStateChanged() {
            boolean active = this.isSelected() || this.isArmed();
            this.setIcon(active ? this.icon : ICON_EMPTY);
            StatusDisplayer.getDefault().setStatusText(active ? this.query.getDescription() : null);
            super.fireStateChanged();
        }

        private static String getName(Query query, Query current, JMenu owner) {
            String name = query.getName();
            if (RQueries.sameQuery(query, current)) {
                name = "<html><b>" + name + "</b>&nbsp;<span style='color: gray;'>" + Bundle.RQueries_CurrentScriptFlag() + "</span></html>";
                if (owner != null) {
                    owner.setText("<html><b>" + owner.getText() + "</b></html>");
                }
            }
            return name;
        }
    }

    private static class PopupSeparator
    extends JPanel {
        PopupSeparator(String text) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            JLabel l = new JLabel(text);
            l.setBorder(BorderFactory.createEmptyBorder(5, 5, 3, 3));
            if (UIUtils.isWindowsLookAndFeel()) {
                l.setOpaque(true);
            }
            l.setFont(l.getFont().deriveFont(1, l.getFont().getSize2D() - 1.0f));
            if (UIUtils.isWindowsLookAndFeel()) {
                l.setForeground(UIUtils.getDisabledLineColor());
            }
            this.add((Component)l, "West");
            if (UIUtils.isGTKLookAndFeel()) {
                this.add((Component)UIUtils.createHorizontalSeparator(), "Center");
            } else {
                JPopupMenu.Separator sep = new JPopupMenu.Separator();
                this.add((Component)sep, "Center");
                if (UIUtils.isOracleLookAndFeel()) {
                    this.setOpaque(true);
                    this.setBackground(sep.getBackground());
                    l.setForeground(sep.getForeground());
                }
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Component c = this.getComponent(1);
            int h = c.getPreferredSize().height;
            Rectangle b = c.getBounds();
            b.y = (b.height - h) / 2 + 1;
            b.height = h;
            c.setBounds(b);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = this.getComponent(0).getPreferredSize();
            d.width += 75;
            return d;
        }
    }

    private static class PopupSpacer
    extends JPanel {
        private final int size;

        PopupSpacer(int size) {
            this.size = size;
            this.setOpaque(false);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, this.size);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    static class Handler {
        Handler() {
        }

        protected void querySelected(Query query) {
        }
    }
}

