/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.mission;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.mission.AbstractMission;
import net.sf.freecol.common.model.mission.Mission;
import net.sf.freecol.common.util.CollectionUtils;

public class ImprovementMission
extends AbstractMission {
    public static final String TAG = "improvementMission";
    private TileImprovement improvement;
    private static final String IMPROVEMENT_TAG = "improvement";

    public ImprovementMission(Game game) {
        super(game);
    }

    public ImprovementMission(Game game, FreeColXMLReader xr) {
        super(game, xr);
    }

    public ImprovementMission(Game game, String id) {
        super(game, id);
    }

    public final TileImprovement getImprovement() {
        return this.improvement;
    }

    public final void setImprovement(TileImprovement newImprovement) {
        this.improvement = newImprovement;
    }

    @Override
    public Mission.MissionState doMission() {
        int work = this.getUnit().hasAbility("model.ability.expertPioneer") ? 2 : 1;
        this.setTurnCount(this.getTurnCount() - work);
        this.getUnit().setMovesLeft(0);
        return this.getTurnCount() <= 0 ? Mission.MissionState.COMPLETED : Mission.MissionState.OK;
    }

    @Override
    public boolean isValid() {
        return this.improvement != null && this.improvement.isWorkerAllowed(this.getUnit()) && super.isValid();
    }

    public static boolean isValidFor(Unit unit) {
        Specification spec = unit.getGame().getSpecification();
        return CollectionUtils.any(spec.getTileImprovementTypeList(), ti -> ti.isWorkerAllowed(unit));
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(IMPROVEMENT_TAG, this.improvement);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.improvement = xr.makeFreeColObject(this.getGame(), IMPROVEMENT_TAG, TileImprovement.class, true);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

