/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class BuildColonyMessage
extends AttributeMessage {
    public static final String TAG = "buildColony";
    private static final String NAME_TAG = "name";
    private static final String UNIT_TAG = "unit";

    public BuildColonyMessage(String colonyName, Unit builder) {
        super(TAG, NAME_TAG, colonyName, UNIT_TAG, builder.getId());
    }

    public BuildColonyMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, NAME_TAG, UNIT_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        ServerGame game = freeColServer.getGame();
        String colonyName = this.getStringAttribute(NAME_TAG);
        String unitId = this.getStringAttribute(UNIT_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.canBuildColony()) {
            return serverPlayer.clientError("Unit " + unitId + " can not build colony.");
        }
        if (colonyName == null) {
            return serverPlayer.clientError("Null colony name");
        }
        if (!"".equals(colonyName) && game.getSettlementByName(colonyName) != null) {
            return serverPlayer.clientError("Non-unique colony name " + colonyName);
        }
        Tile tile = unit.getTile();
        if (!serverPlayer.canClaimToFoundSettlement(tile)) {
            return serverPlayer.clientError("Can not build colony on tile " + tile + ": " + serverPlayer.canClaimToFoundSettlementReason(tile));
        }
        return this.igc(freeColServer).buildSettlement(serverPlayer, unit, colonyName);
    }
}

