/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood.provider;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.element.MoodConcretisation;
import org.jivesoftware.smackx.mood.element.MoodElement;
import org.jivesoftware.smackx.mood.provider.MoodConcretisationProvider;

public class MoodProvider
extends ExtensionElementProvider<MoodElement> {
    private static final Logger LOGGER = Logger.getLogger(MoodProvider.class.getName());
    public static final MoodProvider INSTANCE = new MoodProvider();

    @Override
    public MoodElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        String text = null;
        Mood mood = null;
        MoodConcretisation concretisation = null;
        while (true) {
            XmlPullParser.Event tag = parser.next();
            switch (tag) {
                case START_ELEMENT: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    if ("text".equals(name)) {
                        text = parser.nextText();
                        break;
                    }
                    if (!"http://jabber.org/protocol/mood".equals(namespace)) {
                        LOGGER.log(Level.FINE, "Foreign namespace " + namespace + " detected. Try to find suitable MoodConcretisationProvider.");
                        MoodConcretisationProvider provider = (MoodConcretisationProvider)ProviderManager.getExtensionProvider(name, namespace);
                        if (provider != null) {
                            concretisation = (MoodConcretisation)provider.parse(parser);
                            break;
                        }
                        LOGGER.log(Level.FINE, "No provider for <" + name + " xmlns:'" + namespace + "'/> found. Ignore.");
                        break;
                    }
                    try {
                        mood = Mood.valueOf(name);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XmlPullParserException("Unknown mood value: " + name + " encountered.");
                    }
                }
                case END_ELEMENT: {
                    if (!"mood".equals(parser.getName())) break;
                    MoodElement.MoodSubjectElement subjectElement = mood == null && concretisation == null ? null : new MoodElement.MoodSubjectElement(mood, concretisation);
                    return new MoodElement(subjectElement, text);
                }
            }
        }
    }
}

