/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.FixedLengthAudioStream;
import org.openhab.core.audio.utils.AudioStreamUtils;
import org.openhab.core.audio.utils.AudioWaveUtils;
import org.openhab.core.common.Disposable;

@NonNullByDefault
public class FileAudioStream
extends FixedLengthAudioStream
implements Disposable {
    public static final String WAV_EXTENSION = "wav";
    public static final String MP3_EXTENSION = "mp3";
    public static final String OGG_EXTENSION = "ogg";
    public static final String AAC_EXTENSION = "aac";
    private final File file;
    private final AudioFormat audioFormat;
    private FileInputStream inputStream;
    private final long length;
    private final boolean isTemporaryFile;
    private int markedOffset = 0;
    private int alreadyRead = 0;

    public FileAudioStream(File file) throws AudioException {
        this(file, FileAudioStream.getAudioFormat(file));
    }

    public FileAudioStream(File file, AudioFormat format) throws AudioException {
        this(file, format, false);
    }

    public FileAudioStream(File file, AudioFormat format, boolean isTemporaryFile) throws AudioException {
        this.file = file;
        this.inputStream = FileAudioStream.getInputStream(file);
        this.audioFormat = format;
        this.length = file.length();
        this.isTemporaryFile = isTemporaryFile;
    }

    private static AudioFormat getAudioFormat(File file) throws AudioException {
        String extension;
        String filename = file.getName().toLowerCase();
        switch (extension = AudioStreamUtils.getExtension(filename)) {
            case "wav": {
                return FileAudioStream.parseWavFormat(file);
            }
            case "mp3": {
                return AudioFormat.MP3;
            }
            case "ogg": {
                return AudioFormat.OGG;
            }
            case "aac": {
                return AudioFormat.AAC;
            }
        }
        throw new AudioException("Unsupported file extension!");
    }

    private static AudioFormat parseWavFormat(File file) throws AudioException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream inputStream = new BufferedInputStream(FileAudioStream.getInputStream(file));){
                return AudioWaveUtils.parseWavFormat(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new AudioException("Cannot parse wav stream", e);
        }
    }

    private static FileInputStream getInputStream(File file) throws AudioException {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new AudioException("File '" + file.getAbsolutePath() + "' not found!");
        }
    }

    @Override
    public AudioFormat getFormat() {
        return this.audioFormat;
    }

    @Override
    public int read() throws IOException {
        int read = this.inputStream.read();
        ++this.alreadyRead;
        return read;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        super.close();
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.inputStream = FileAudioStream.getInputStream(this.file);
            this.inputStream.skipNBytes(this.markedOffset);
            this.alreadyRead = this.markedOffset;
        }
        catch (AudioException e) {
            throw new IOException("Cannot reset file input stream: " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markedOffset = this.alreadyRead;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public InputStream getClonedStream() throws AudioException {
        return FileAudioStream.getInputStream(this.file);
    }

    public void dispose() throws IOException {
        if (this.isTemporaryFile) {
            Files.delete(this.file.toPath());
        }
    }
}

