import sys

if sys.platform == "win32":
    import enum
    from collections.abc import Callable, Iterable, Iterator
    from signal import Signals
    from typing import Final, Literal, TypedDict, TypeVar, overload, type_check_only
    from typing_extensions import ParamSpec

    from psutil import _psutil_windows
    from psutil._common import (
        ENCODING as ENCODING,
        AccessDenied as AccessDenied,
        NoSuchProcess as NoSuchProcess,
        TimeoutExpired as TimeoutExpired,
        conn_tmap as conn_tmap,
        conn_to_ntuple as conn_to_ntuple,
        debug as debug,
        isfile_strict as isfile_strict,
        memoize as memoize,
        memoize_when_activated as memoize_when_activated,
        parse_environ_block as parse_environ_block,
        usage_percent as usage_percent,
    )
    from psutil._psutil_windows import (
        ABOVE_NORMAL_PRIORITY_CLASS as ABOVE_NORMAL_PRIORITY_CLASS,
        BELOW_NORMAL_PRIORITY_CLASS as BELOW_NORMAL_PRIORITY_CLASS,
        HIGH_PRIORITY_CLASS as HIGH_PRIORITY_CLASS,
        IDLE_PRIORITY_CLASS as IDLE_PRIORITY_CLASS,
        NORMAL_PRIORITY_CLASS as NORMAL_PRIORITY_CLASS,
        REALTIME_PRIORITY_CLASS as REALTIME_PRIORITY_CLASS,
    )

    from . import _ntuples as ntp

    __extra__all__: Final[list[str]]
    CONN_DELETE_TCB: Final = "DELETE_TCB"
    ERROR_PARTIAL_COPY: Final = 299
    PYPY: Final[bool]

    class AddressFamily(enum.IntEnum):
        AF_LINK = -1

    AF_LINK: Final = AddressFamily.AF_LINK
    TCP_STATUSES: Final[dict[int, str]]

    # These noqas workaround https://github.com/astral-sh/ruff/issues/10874
    class Priority(enum.IntEnum):
        ABOVE_NORMAL_PRIORITY_CLASS = _psutil_windows.ABOVE_NORMAL_PRIORITY_CLASS  # noqa: F811
        BELOW_NORMAL_PRIORITY_CLASS = _psutil_windows.BELOW_NORMAL_PRIORITY_CLASS  # noqa: F811
        HIGH_PRIORITY_CLASS = _psutil_windows.HIGH_PRIORITY_CLASS  # noqa: F811
        IDLE_PRIORITY_CLASS = _psutil_windows.IDLE_PRIORITY_CLASS  # noqa: F811
        NORMAL_PRIORITY_CLASS = _psutil_windows.NORMAL_PRIORITY_CLASS  # noqa: F811
        REALTIME_PRIORITY_CLASS = _psutil_windows.REALTIME_PRIORITY_CLASS  # noqa: F811

    class IOPriority(enum.IntEnum):
        IOPRIO_VERYLOW = 0
        IOPRIO_LOW = 1
        IOPRIO_NORMAL = 2
        IOPRIO_HIGH = 3

    IOPRIO_VERYLOW: Final = IOPriority.IOPRIO_VERYLOW
    IOPRIO_LOW: Final = IOPriority.IOPRIO_LOW
    IOPRIO_NORMAL: Final = IOPriority.IOPRIO_NORMAL
    IOPRIO_HIGH: Final = IOPriority.IOPRIO_HIGH

    pinfo_map: Final[dict[str, int]]

    _P = ParamSpec("_P")
    _R = TypeVar("_R")

    def convert_dos_path(s: str) -> str: ...
    def getpagesize() -> int: ...
    def virtual_memory() -> ntp.svmem: ...
    def swap_memory() -> ntp.sswap: ...

    heap_info = _psutil_windows.heap_info
    heap_trim = _psutil_windows.heap_trim
    disk_io_counters = _psutil_windows.disk_io_counters

    def disk_usage(path: str) -> ntp.sdiskusage: ...
    def disk_partitions(all: bool) -> list[ntp.sdiskpart]: ...
    def cpu_times() -> ntp.scputimes: ...
    def per_cpu_times() -> list[ntp.scputimes]: ...
    def cpu_count_logical() -> int | None: ...
    def cpu_count_cores() -> int | None: ...
    def cpu_stats() -> ntp.scpustats: ...
    def cpu_freq() -> list[ntp.scpufreq]: ...
    def getloadavg() -> tuple[float, float, float]: ...
    @overload
    def net_connections(kind: str, _pid: Literal[-1] = -1) -> list[ntp.sconn]: ...
    @overload
    def net_connections(kind: str, _pid: int = -1) -> list[ntp.pconn]: ...
    def net_if_stats() -> dict[str, ntp.snicstats]: ...
    def net_io_counters() -> dict[str, tuple[int, int, int, int, int, int, int, int]]: ...
    def net_if_addrs() -> list[tuple[str, int, str, str | None, None, None]]: ...
    def sensors_battery() -> ntp.sbattery | None: ...
    def boot_time() -> float: ...
    def users() -> list[ntp.suser]: ...
    def win_service_iter() -> Iterator[WindowsService]: ...
    def win_service_get(name: str) -> WindowsService: ...
    @type_check_only
    class _WindowsServiceAttrs(TypedDict):
        name: str
        display_name: str | None
        description: str
        binpath: str
        username: str
        start_type: str
        status: str
        pid: int | None

    class WindowsService:
        def __init__(self, name: str, display_name: str | None) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def name(self) -> str: ...
        def display_name(self) -> str | None: ...
        def binpath(self) -> str: ...
        def username(self) -> str: ...
        def start_type(self) -> str: ...
        def pid(self) -> int: ...
        def status(self) -> str: ...
        def description(self) -> str: ...
        def as_dict(self) -> _WindowsServiceAttrs: ...

    pids = _psutil_windows.pids
    pid_exists = _psutil_windows.pid_exists
    ppid_map = _psutil_windows.ppid_map

    def is_permission_err(exc: OSError) -> bool: ...
    @overload
    def convert_oserror(exc: PermissionError, pid: int | None = None, name: str | None = None) -> AccessDenied: ...
    @overload
    def convert_oserror(exc: OSError, pid: int | None = None, name: str | None = None) -> AccessDenied | NoSuchProcess: ...
    def wrap_exceptions(fun: Callable[_P, _R]) -> Callable[_P, _R]: ...
    def retry_error_partial_copy(fun: Callable[_P, _R]) -> Callable[_P, _R]: ...

    class Process:
        __slots__ = ["_cache", "_name", "_ppid", "pid"]
        pid: int
        def __init__(self, pid: int) -> None: ...
        def oneshot_enter(self) -> None: ...
        def oneshot_exit(self) -> None: ...
        def name(self) -> str: ...
        def exe(self) -> str: ...
        def cmdline(self) -> list[str]: ...
        def environ(self) -> dict[str, str]: ...
        def ppid(self) -> int: ...
        def memory_info(self) -> ntp.pmem: ...
        def memory_full_info(self) -> ntp.pfullmem: ...
        def memory_maps(self) -> Iterator[tuple[str, str, str, int]]: ...
        def kill(self) -> None: ...
        def send_signal(self, sig: Literal[Signals.SIGTERM, Signals.CTRL_C_EVENT, Signals.CTRL_BREAK_EVENT]) -> None: ...
        def wait(self, timeout: float | None = None) -> int | None: ...
        def username(self) -> str: ...
        def create_time(self, fast_only: bool = False) -> float: ...
        def num_threads(self) -> int: ...
        def threads(self) -> list[ntp.pthread]: ...
        def cpu_times(self) -> ntp.pcputimes: ...
        def suspend(self) -> None: ...
        def resume(self) -> None: ...
        def cwd(self) -> str: ...
        def open_files(self) -> list[ntp.popenfile]: ...
        def net_connections(self, kind: str = "inet") -> list[ntp.pconn]: ...
        def nice_get(self) -> Priority: ...
        def nice_set(self, value: int) -> None: ...
        def ionice_get(self) -> IOPriority: ...
        def ionice_set(self, ioclass: int, value: None) -> None: ...
        def io_counters(self) -> ntp.pio: ...
        def status(self) -> Literal["stopped", "running"]: ...
        def cpu_affinity_get(self) -> list[int]: ...
        def cpu_affinity_set(self, value: Iterable[int]) -> None: ...
        def num_handles(self) -> int: ...
        def num_ctx_switches(self) -> ntp.pctxsw: ...
