/*
 * Decompiled with CFR 0.152.
 */
package tr.view.project.chooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.model.project.Project;
import tr.view.project.chooser.ProjectsPanel;

public class ProjectChooserDialog
extends JDialog
implements FocusListener,
ActionListener {
    private static final Class CLASS = ProjectChooserDialog.class;
    private static final String TITLE = NbBundle.getMessage((Class)CLASS, (String)"dialog.title");
    private ProjectsPanel panel;
    private JButton okayButton;
    private JButton cancelButton;
    private boolean okay;
    private boolean cancel;

    private void construct() {
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectChooserDialog.this.cancel = true;
                ProjectChooserDialog.this.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(cancelListener, stroke, 2);
        this.okayButton = new JButton(NbBundle.getMessage(ProjectChooserDialog.class, (String)"dialog.okay"));
        this.okayButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.cancelButton = new JButton(NbBundle.getMessage(ProjectChooserDialog.class, (String)"dialog.cancel"));
        this.cancelButton.addActionListener(this);
        JPanel buttonsPanel = new JPanel();
        if (Utilities.isWindows()) {
            buttonsPanel.add(this.okayButton);
            buttonsPanel.add(this.cancelButton);
        } else {
            buttonsPanel.add(this.cancelButton);
            buttonsPanel.add(this.okayButton);
        }
        this.panel = new ProjectsPanel();
        this.panel.addActionListener(this);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)buttonsPanel, "South");
        mainPanel.add((Component)this.panel, "Center");
        JPanel fillBottomPanel = new JPanel();
        fillBottomPanel.setPreferredSize(new Dimension(0, 32));
        JPanel fillWestPanel = new JPanel();
        fillWestPanel.setPreferredSize(new Dimension(32, 0));
        JPanel fillEastPanel = new JPanel();
        fillEastPanel.setPreferredSize(new Dimension(32, 0));
        Container dialog = this.getContentPane();
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)mainPanel, "Center");
        dialog.add((Component)fillBottomPanel, "South");
        dialog.add((Component)fillWestPanel, "West");
        dialog.add((Component)fillEastPanel, "East");
        this.pack();
        this.setResizable(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okayButton || e.getSource() == this.panel) {
            this.okay = true;
        } else if (e.getSource() == this.cancelButton) {
            this.cancel = true;
        }
        this.setVisible(false);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public ProjectChooserDialog(Frame owner) {
        this(owner, TITLE);
    }

    public ProjectChooserDialog(Frame owner, String title) {
        super(owner, title, true);
        this.construct();
        this.initialise();
    }

    public ProjectChooserDialog(Dialog owner) {
        this(owner, TITLE);
    }

    public ProjectChooserDialog(Dialog owner, String title) {
        super(owner, title, true);
        this.construct();
        this.initialise();
    }

    private void initialise() {
        this.setDefaultCloseOperation(1);
    }

    public Project select(Project project, Component component) {
        this.okay = false;
        this.cancel = false;
        if (component != null) {
            this.setLocationRelativeTo(component);
        }
        this.panel.refreshModel();
        this.panel.setSelected(project);
        this.setVisible(true);
        if (!this.okay) {
            return null;
        }
        return this.panel.getSelected();
    }

    public boolean cancelled() {
        return this.cancel;
    }

    public boolean okayed() {
        return this.okay;
    }

    private static class FocusablePanel
    extends JPanel {
        public FocusablePanel(LayoutManager layout) {
            super(layout);
        }

        public boolean isFocusable() {
            return true;
        }
    }
}

