/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRRtfSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_RTF = ".rtf";

    public JRRtfSaveContributor(Locale locale, ResourceBundle resBundle) {
        super(locale, resBundle);
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_RTF);
    }

    public String getDescription() {
        return this.getBundleString("file.desc.rtf");
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().toLowerCase().endsWith(EXTENSION_RTF)) {
            file = new File(file.getAbsolutePath() + EXTENSION_RTF);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(this.getBundleString("file.exists"), file.getName()), this.getBundleString("save"), 2)) {
            JRRtfExporter exporter = new JRRtfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            exporter.exportReport();
        }
    }
}

