/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.RFC7748Curve;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PointFormatter {
    private static final Logger LOGGER = LogManager.getLogger();

    public static byte[] formatToByteArray(NamedGroup group, Point point, ECPointFormat format) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int elementLength = ArrayConverter.bigIntegerToByteArray((BigInteger)point.getX().getModulus()).length;
        if (group != NamedGroup.ECDH_X448 && group != NamedGroup.ECDH_X25519) {
            switch (format) {
                case UNCOMPRESSED: {
                    stream.write(4);
                    try {
                        stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getX().getData(), (int)elementLength));
                        stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getY().getData(), (int)elementLength));
                    }
                    catch (IOException ex) {
                        throw new PreparationException("Could not serialize ec point", ex);
                    }
                    return stream.toByteArray();
                }
                case ANSIX962_COMPRESSED_CHAR2: 
                case ANSIX962_COMPRESSED_PRIME: {
                    EllipticCurve curve = CurveFactory.getCurve(group);
                    if (curve.createAPointOnCurve(point.getX().getData()).getY().getData().equals(point.getY().getData())) {
                        stream.write(3);
                    } else {
                        stream.write(2);
                    }
                    try {
                        stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getX().getData(), (int)elementLength));
                    }
                    catch (IOException ex) {
                        throw new PreparationException("Could not serialize ec point", ex);
                    }
                    return stream.toByteArray();
                }
            }
            throw new UnsupportedOperationException("Unnsupported PointFormat: " + (Object)((Object)format));
        }
        try {
            byte[] coordinate = ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getX().getData(), (int)elementLength);
            stream.write(coordinate);
        }
        catch (IOException ex) {
            throw new PreparationException("Could not serialize ec point", ex);
        }
        return stream.toByteArray();
    }

    public static byte[] toRawFormat(Point point) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int elementLenght = ArrayConverter.bigIntegerToByteArray((BigInteger)point.getX().getModulus()).length;
        try {
            stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getX().getData(), (int)elementLenght));
            stream.write(ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)point.getY().getData(), (int)elementLenght));
        }
        catch (IOException ex) {
            throw new PreparationException("Could not serialize ec point", ex);
        }
        return stream.toByteArray();
    }

    public static Point fromRawFormat(NamedGroup group, byte[] pointBytes) {
        EllipticCurve curve = CurveFactory.getCurve(group);
        int elementLenght = ArrayConverter.bigIntegerToByteArray((BigInteger)curve.getModulus()).length;
        if (pointBytes.length < elementLenght * 2) {
            LOGGER.warn("Cannot decode byte[] to point of " + (Object)((Object)group) + ". Returning Basepoint");
            return curve.getBasePoint();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pointBytes);
        byte[] xCord = new byte[elementLenght];
        byte[] yCord = new byte[elementLenght];
        try {
            inputStream.read(xCord);
            inputStream.read(yCord);
        }
        catch (IOException ex) {
            LOGGER.warn("Could not read from byteArrayStream. Returning Basepoint", (Throwable)ex);
            return curve.getBasePoint();
        }
        return curve.getPoint(new BigInteger(1, xCord), new BigInteger(1, yCord));
    }

    public static Point formatFromByteArray(NamedGroup group, byte[] compressedPoint) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(compressedPoint);
        EllipticCurve curve = CurveFactory.getCurve(group);
        int elementLength = ArrayConverter.bigIntegerToByteArray((BigInteger)curve.getModulus()).length;
        if (compressedPoint.length == 0) {
            LOGGER.warn("Could not parse point. Point is empty. Returning Basepoint");
            return curve.getBasePoint();
        }
        if (group != NamedGroup.ECDH_X448 && group != NamedGroup.ECDH_X25519) {
            int pointFormat = inputStream.read();
            byte[] xCoordinate = new byte[elementLength];
            switch (pointFormat) {
                case 2: 
                case 3: {
                    if (compressedPoint.length != elementLength + 1) {
                        LOGGER.warn("Could not parse point. Point needs to be " + (elementLength + 1) + " bytes long, but was " + compressedPoint.length + "bytes long. Returning Basepoint");
                        return curve.getBasePoint();
                    }
                    try {
                        inputStream.read(xCoordinate);
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Could not read from byteArrayStream. Returning Basepoint", (Throwable)ex);
                        return curve.getBasePoint();
                    }
                    Point decompressedPoint = curve.createAPointOnCurve(new BigInteger(1, xCoordinate));
                    if (pointFormat == 2) {
                        decompressedPoint = curve.inverseAffine(decompressedPoint);
                    }
                    return decompressedPoint;
                }
                case 4: {
                    if (compressedPoint.length != elementLength * 2 + 1) {
                        LOGGER.warn("Could not parse point. Point needs to be " + (elementLength * 2 + 1) + " bytes long, but was " + compressedPoint.length + "bytes long. Returning Basepoint");
                        return curve.getBasePoint();
                    }
                    byte[] yCoordinate = new byte[elementLength];
                    try {
                        inputStream.read(xCoordinate);
                        inputStream.read(yCoordinate);
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Could not read from byteArrayStream. Returning Basepoint", (Throwable)ex);
                        return curve.getBasePoint();
                    }
                    return curve.getPoint(new BigInteger(1, xCoordinate), new BigInteger(1, yCoordinate));
                }
            }
            throw new UnsupportedOperationException("Unnsupported PointFormat: " + pointFormat);
        }
        if (compressedPoint.length != elementLength) {
            LOGGER.warn("Could not parse point. Point needs to be " + elementLength + " bytes long, but was " + compressedPoint.length + "bytes long. Returning Basepoint");
            return curve.getBasePoint();
        }
        byte[] xCoordinate = new byte[elementLength];
        try {
            inputStream.read(xCoordinate);
        }
        catch (IOException ex) {
            LOGGER.warn("Could not read from byteArrayStream. Returning Basepoint", (Throwable)ex);
            return curve.getBasePoint();
        }
        RFC7748Curve computation = (RFC7748Curve)curve;
        return curve.createAPointOnCurve(computation.decodeCoordinate(new BigInteger(1, xCoordinate)));
    }

    private PointFormatter() {
    }
}

