/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.keys;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPublicKey;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomRsaPublicKey
extends CustomPublicKey
implements RSAPublicKey {
    private static final Logger LOGGER = LogManager.getLogger();
    private BigInteger publicExponent;
    private BigInteger modulus;

    private CustomRsaPublicKey() {
        this.publicExponent = null;
        this.modulus = null;
    }

    public CustomRsaPublicKey(BigInteger publicExponent, BigInteger modulus) {
        this.publicExponent = publicExponent;
        this.modulus = modulus;
    }

    @Override
    public void adjustInContext(TlsContext context, ConnectionEndType ownerOfKey) {
        LOGGER.debug("Adjusting RSA public key in context");
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                context.setClientRSAPublicKey(this.publicExponent);
                context.setClientRsaModulus(this.modulus);
                break;
            }
            case SERVER: {
                context.setServerRSAPublicKey(this.publicExponent);
                context.setServerRsaModulus(this.modulus);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "None";
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public void adjustInConfig(Config config, ConnectionEndType ownerOfKey) {
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                config.setDefaultClientRSAPublicKey(this.publicExponent);
                config.setDefaultClientRSAModulus(this.modulus);
                break;
            }
            case SERVER: {
                config.setDefaultServerRSAPublicKey(this.publicExponent);
                config.setDefaultServerRSAModulus(this.modulus);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.publicExponent);
        hash = 23 * hash + Objects.hashCode(this.modulus);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomRsaPublicKey other = (CustomRsaPublicKey)obj;
        if (!Objects.equals(this.publicExponent, other.publicExponent)) {
            return false;
        }
        return Objects.equals(this.modulus, other.modulus);
    }

    public void setPublicExponent(BigInteger publicExponent) {
        this.publicExponent = publicExponent;
    }

    public void setModulus(BigInteger modulus) {
        this.modulus = modulus;
    }

    @Override
    public int keysize() {
        return this.modulus.bitLength();
    }
}

